/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.messages.server;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.druid.messages.MessageBatch;
import org.apache.druid.messages.server.OutboxImpl;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OutboxImplTest {
    private static final String HOST = "h1";
    private OutboxImpl<String> outbox;

    @Before
    public void setUp() {
        this.outbox = new OutboxImpl();
    }

    @After
    public void tearDown() {
        this.outbox.stop();
    }

    @Test
    public void test_normalOperation() throws InterruptedException, ExecutionException {
        ListenableFuture sendFuture1 = this.outbox.sendMessage(HOST, (Object)"1");
        ListenableFuture sendFuture2 = this.outbox.sendMessage(HOST, (Object)"2");
        ListenableFuture sendFuture3 = this.outbox.sendMessage(HOST, (Object)"3");
        long outboxEpoch = this.outbox.getOutboxEpoch(HOST);
        Assert.assertFalse((boolean)sendFuture1.isDone());
        Assert.assertFalse((boolean)sendFuture2.isDone());
        Assert.assertFalse((boolean)sendFuture3.isDone());
        Assert.assertEquals((Object)new MessageBatch((List)ImmutableList.of((Object)"1", (Object)"2", (Object)"3"), outboxEpoch, 0L), (Object)this.outbox.getMessages(HOST, -1L, 0L).get());
        Assert.assertFalse((boolean)sendFuture1.isDone());
        Assert.assertFalse((boolean)sendFuture2.isDone());
        Assert.assertFalse((boolean)sendFuture3.isDone());
        Assert.assertEquals((Object)new MessageBatch((List)ImmutableList.of((Object)"2", (Object)"3"), outboxEpoch, 1L), (Object)this.outbox.getMessages(HOST, outboxEpoch, 1L).get());
        Assert.assertTrue((boolean)sendFuture1.isDone());
        Assert.assertFalse((boolean)sendFuture2.isDone());
        Assert.assertFalse((boolean)sendFuture3.isDone());
        ListenableFuture futureBatch = this.outbox.getMessages(HOST, outboxEpoch, 3L);
        Assert.assertFalse((boolean)futureBatch.isDone());
        Assert.assertTrue((boolean)sendFuture1.isDone());
        Assert.assertTrue((boolean)sendFuture2.isDone());
        Assert.assertTrue((boolean)sendFuture3.isDone());
        ListenableFuture sendFuture4 = this.outbox.sendMessage(HOST, (Object)"4");
        Assert.assertTrue((boolean)futureBatch.isDone());
        Assert.assertFalse((boolean)sendFuture4.isDone());
    }

    @Test
    public void test_getMessages_wrongEpoch() throws InterruptedException, ExecutionException {
        ListenableFuture sendFuture = this.outbox.sendMessage(HOST, (Object)"1");
        long outboxEpoch = this.outbox.getOutboxEpoch(HOST);
        MessageBatch batch = (MessageBatch)this.outbox.getMessages(HOST, outboxEpoch + 1L, 0L).get();
        Assert.assertEquals((Object)new MessageBatch(Collections.emptyList(), outboxEpoch, 0L), (Object)batch);
        Assert.assertFalse((boolean)sendFuture.isDone());
    }

    @Test
    public void test_getMessages_nonexistentHost() throws InterruptedException, ExecutionException {
        String nonexistentHost = "nonexistent";
        ListenableFuture batchFuture = this.outbox.getMessages("nonexistent", -1L, 0L);
        Assert.assertFalse((boolean)batchFuture.isDone());
        MatcherAssert.assertThat((Object)this.outbox.getOutboxEpoch("nonexistent"), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(0L)));
        ListenableFuture sendFuture = this.outbox.sendMessage("nonexistent", (Object)"foo");
        Assert.assertTrue((boolean)batchFuture.isDone());
        Assert.assertEquals((Object)new MessageBatch((List)ImmutableList.of((Object)"foo"), this.outbox.getOutboxEpoch("nonexistent"), 0L), (Object)batchFuture.get());
        Assert.assertFalse((boolean)sendFuture.isDone());
        ListenableFuture batchFuture2 = this.outbox.getMessages("nonexistent", this.outbox.getOutboxEpoch("nonexistent"), 1L);
        Assert.assertTrue((boolean)sendFuture.isDone());
        this.outbox.resetOutbox("nonexistent");
        Assert.assertTrue((boolean)batchFuture2.isDone());
    }

    @Test
    public void test_stop_cancelsSendMessage() {
        ListenableFuture sendFuture = this.outbox.sendMessage(HOST, (Object)"1");
        this.outbox.stop();
        Assert.assertTrue((boolean)sendFuture.isCancelled());
    }

    @Test
    public void test_stop_cancelsGetMessages() {
        ListenableFuture futureBatch = this.outbox.getMessages(HOST, -1L, 0L);
        this.outbox.stop();
        Assert.assertTrue((boolean)futureBatch.isCancelled());
    }

    @Test
    public void test_reset_cancelsSendMessage() {
        ListenableFuture sendFuture = this.outbox.sendMessage(HOST, (Object)"1");
        this.outbox.resetOutbox(HOST);
        Assert.assertTrue((boolean)sendFuture.isCancelled());
    }

    @Test
    public void test_reset_cancelsGetMessages() {
        ListenableFuture futureBatch = this.outbox.getMessages(HOST, -1L, 0L);
        this.outbox.resetOutbox(HOST);
        Assert.assertTrue((boolean)futureBatch.isCancelled());
    }

    @Test
    public void test_reset_nonexistentHost_doesNothing() {
        this.outbox.resetOutbox("nonexistent");
    }

    @Test
    public void test_stop_preventsSendMessage() {
        this.outbox.stop();
        ListenableFuture sendFuture = this.outbox.sendMessage(HOST, (Object)"1");
        Assert.assertTrue((boolean)sendFuture.isCancelled());
    }

    @Test
    public void test_stop_preventsGetMessages() {
        this.outbox.stop();
        ListenableFuture futureBatch = this.outbox.getMessages(HOST, -1L, 0L);
        Assert.assertTrue((boolean)futureBatch.isCancelled());
    }
}

