/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.initialization;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.error.DruidException;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.EqualityFilter;
import org.apache.druid.query.policy.NoRestrictionPolicy;
import org.apache.druid.query.policy.RowFilterPolicy;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.server.security.AuthorizationResult;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public class AuthorizationResultTest {
    @Test
    public void testEquals() {
        EqualsVerifier.forClass(AuthorizationResult.class).usingGetClass().verify();
    }

    @Test
    public void testToString() {
        AuthorizationResult result = AuthorizationResult.allowWithRestriction((Map)ImmutableMap.of((Object)"table1", Optional.of(NoRestrictionPolicy.instance()), (Object)"table2", Optional.of(RowFilterPolicy.from((DimFilter)new EqualityFilter("column1", ColumnType.STRING, (Object)"val1", null)))));
        Assertions.assertEquals((Object)"AuthorizationResult [permission=ALLOW_WITH_RESTRICTION, failureMessage=null, policyRestrictions={table1=Optional[NO_RESTRICTION], table2=Optional[RowFilterPolicy{rowFilter=column1 = val1}]}]", (Object)result.toString());
    }

    @Test
    public void testNoAccess() {
        AuthorizationResult result = AuthorizationResult.deny((String)"this data source is not permitted");
        Assertions.assertFalse((boolean)result.allowBasicAccess());
        Assertions.assertFalse((boolean)result.allowAccessWithNoRestriction());
        Assertions.assertEquals((Object)"this data source is not permitted", (Object)result.getErrorMessage());
        Assertions.assertFalse((boolean)result.allowAccessWithNoRestriction());
    }

    @Test
    public void testFullAccess() {
        AuthorizationResult result = AuthorizationResult.allowWithRestriction((Map)ImmutableMap.of());
        Assertions.assertTrue((boolean)result.allowBasicAccess());
        Assertions.assertTrue((boolean)result.allowAccessWithNoRestriction());
        Assertions.assertThrows(DruidException.class, () -> ((AuthorizationResult)result).getErrorMessage());
        AuthorizationResult resultWithEmptyPolicy = AuthorizationResult.allowWithRestriction((Map)ImmutableMap.of((Object)"table1", Optional.empty()));
        Assertions.assertTrue((boolean)resultWithEmptyPolicy.allowBasicAccess());
        Assertions.assertTrue((boolean)resultWithEmptyPolicy.allowAccessWithNoRestriction());
        Assertions.assertThrows(DruidException.class, () -> ((AuthorizationResult)resultWithEmptyPolicy).getErrorMessage());
        AuthorizationResult resultWithNoRestrictionPolicy = AuthorizationResult.allowWithRestriction((Map)ImmutableMap.of((Object)"table1", Optional.of(NoRestrictionPolicy.instance())));
        Assertions.assertTrue((boolean)resultWithNoRestrictionPolicy.allowBasicAccess());
        Assertions.assertTrue((boolean)resultWithNoRestrictionPolicy.allowAccessWithNoRestriction());
        Assertions.assertThrows(DruidException.class, () -> ((AuthorizationResult)resultWithNoRestrictionPolicy).getErrorMessage());
    }

    @Test
    public void testRestrictedAccess() {
        AuthorizationResult result = AuthorizationResult.allowWithRestriction((Map)ImmutableMap.of((Object)"table1", Optional.of(RowFilterPolicy.from((DimFilter)new EqualityFilter("col", ColumnType.STRING, (Object)"val1", null)))));
        Assertions.assertTrue((boolean)result.allowBasicAccess());
        Assertions.assertFalse((boolean)result.allowAccessWithNoRestriction());
        Assertions.assertEquals((Object)"Unauthorized", (Object)result.getErrorMessage());
    }
}

