/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.supervisor;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.indexing.overlord.DataSourceMetadata;
import org.apache.druid.indexing.overlord.supervisor.StreamSupervisor;
import org.apache.druid.indexing.overlord.supervisor.SupervisorReport;
import org.apache.druid.indexing.overlord.supervisor.SupervisorStateManager;
import org.apache.druid.indexing.overlord.supervisor.autoscaler.LagStats;
import org.junit.Assert;
import org.junit.Test;

public class StreamSupervisorTest {
    @Test
    public void testDefaultHandoffTaskGroupsEarly() {
        StreamSupervisor streamSupervisor = new StreamSupervisor(){

            public void start() {
            }

            public void stop(boolean stopGracefully) {
            }

            public SupervisorReport getStatus() {
                return null;
            }

            public SupervisorStateManager.State getState() {
                return null;
            }

            public void reset(@Nullable DataSourceMetadata dataSourceMetadata) {
            }

            public void resetOffsets(DataSourceMetadata resetDataSourceMetadata) {
            }

            public void checkpoint(int taskGroupId, DataSourceMetadata checkpointMetadata) {
            }

            public LagStats computeLagStats() {
                return null;
            }

            public int getActiveTaskGroupsCount() {
                return 0;
            }
        };
        Exception ex = (Exception)Assert.assertThrows(UnsupportedOperationException.class, () -> streamSupervisor.handoffTaskGroupsEarly((List)ImmutableList.of((Object)1)));
        Assert.assertEquals((Object)"Supervisor does not have the feature to handoff task groups early implemented", (Object)ex.getMessage());
    }

    @Test
    public void testDefaultStopAsync() {
        StreamSupervisor streamSupervisor = new StreamSupervisor(){
            private SupervisorStateManager.State state = SupervisorStateManager.BasicState.RUNNING;

            public void start() {
            }

            public void stop(boolean stopGracefully) {
                this.state = SupervisorStateManager.BasicState.STOPPING;
            }

            public SupervisorReport getStatus() {
                return null;
            }

            public SupervisorStateManager.State getState() {
                return this.state;
            }

            public void reset(@Nullable DataSourceMetadata dataSourceMetadata) {
            }

            public void resetOffsets(DataSourceMetadata resetDataSourceMetadata) {
            }

            public void checkpoint(int taskGroupId, DataSourceMetadata checkpointMetadata) {
            }

            public LagStats computeLagStats() {
                return null;
            }

            public int getActiveTaskGroupsCount() {
                return 0;
            }
        };
        ListenableFuture stopAsyncFuture = streamSupervisor.stopAsync();
        Assert.assertTrue((boolean)stopAsyncFuture.isDone());
        Assert.assertEquals((Object)SupervisorStateManager.BasicState.STOPPING, (Object)streamSupervisor.getState());
    }
}

