/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.guice;

import com.google.common.collect.ImmutableList;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.ProvisionException;
import com.google.inject.name.Names;
import com.google.inject.util.Modules;
import java.lang.annotation.Annotation;
import java.util.Collections;
import org.apache.druid.discovery.DataNodeService;
import org.apache.druid.error.ExceptionMatcher;
import org.apache.druid.guice.GuiceInjectors;
import org.apache.druid.guice.ServerTypeConfig;
import org.apache.druid.guice.StorageNodeModule;
import org.apache.druid.guice.annotations.Self;
import org.apache.druid.initialization.Initialization;
import org.apache.druid.query.DruidProcessingConfig;
import org.apache.druid.segment.loading.SegmentLoaderConfig;
import org.apache.druid.segment.loading.StorageLocationConfig;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.coordination.DruidServerMetadata;
import org.apache.druid.server.coordination.ServerType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class StorageNodeModuleTest {
    private static final boolean INJECT_SERVER_TYPE_CONFIG = true;
    private DruidNode self;
    private ServerTypeConfig serverTypeConfig;
    @Mock
    private DruidProcessingConfig druidProcessingConfig;
    @Mock
    private SegmentLoaderConfig segmentLoaderConfig;
    @Mock
    private StorageLocationConfig storageLocation;
    private StorageNodeModule target;

    @Before
    public void setUp() {
        this.self = new DruidNode("test", "test-host", true, Integer.valueOf(80), Integer.valueOf(443), false, true);
        this.serverTypeConfig = new ServerTypeConfig(ServerType.HISTORICAL);
        Mockito.when((Object)this.segmentLoaderConfig.getLocations()).thenReturn(Collections.singletonList(this.storageLocation));
        this.target = new StorageNodeModule();
    }

    @Test
    public void testIsSegmentCacheConfiguredIsInjected() {
        Boolean isSegmentCacheConfigured = (Boolean)this.injector().getInstance(Key.get(Boolean.class, (Annotation)Names.named((String)"IS_SEGMENT_CACHE_CONFIGURED")));
        Assert.assertNotNull((Object)isSegmentCacheConfigured);
        Assert.assertTrue((boolean)isSegmentCacheConfigured);
    }

    @Test
    public void testIsSegmentCacheConfiguredWithNoLocationsConfiguredIsInjected() {
        this.mockSegmentCacheNotConfigured();
        Boolean isSegmentCacheConfigured = (Boolean)this.injector().getInstance(Key.get(Boolean.class, (Annotation)Names.named((String)"IS_SEGMENT_CACHE_CONFIGURED")));
        Assert.assertNotNull((Object)isSegmentCacheConfigured);
        Assert.assertFalse((boolean)isSegmentCacheConfigured);
    }

    @Test
    public void getDataNodeServiceWithNoServerTypeConfigShouldThrowProvisionException() {
        Injector injector = this.makeInjector(false);
        ExceptionMatcher.of(ProvisionException.class).expectMessageContains("Must override the binding for ServerTypeConfig if you want a DataNodeService.").assertThrowsAndMatches(() -> injector.getInstance(DataNodeService.class));
    }

    @Test
    public void getDataNodeServiceWithNoSegmentCacheConfiguredThrowProvisionException() {
        this.mockSegmentCacheNotConfigured();
        ExceptionMatcher.of(ProvisionException.class).expectMessageContains("druid.segmentCache.locations must be set on historicals.").assertThrowsAndMatches(() -> this.injector().getInstance(DataNodeService.class));
    }

    @Test
    public void getDataNodeServiceIsInjectedAsSingleton() {
        Injector injector = this.injector();
        DataNodeService dataNodeService = (DataNodeService)injector.getInstance(DataNodeService.class);
        Assert.assertNotNull((Object)dataNodeService);
        DataNodeService other = (DataNodeService)injector.getInstance(DataNodeService.class);
        Assert.assertSame((Object)dataNodeService, (Object)other);
    }

    @Test
    public void getDataNodeServiceIsInjectedAndDiscoverable() {
        DataNodeService dataNodeService = (DataNodeService)this.injector().getInstance(DataNodeService.class);
        Assert.assertNotNull((Object)dataNodeService);
        Assert.assertTrue((boolean)dataNodeService.isDiscoverable());
    }

    @Test
    public void getDataNodeServiceWithSegmentCacheNotConfiguredIsInjectedAndDiscoverable() {
        this.mockSegmentCacheNotConfigured();
        this.serverTypeConfig = new ServerTypeConfig(ServerType.BROKER);
        DataNodeService dataNodeService = (DataNodeService)this.injector().getInstance(DataNodeService.class);
        Assert.assertNotNull((Object)dataNodeService);
        Assert.assertFalse((boolean)dataNodeService.isDiscoverable());
    }

    @Test
    public void testDruidServerMetadataIsInjectedAsSingleton() {
        Injector injector = this.injector();
        DruidServerMetadata druidServerMetadata = (DruidServerMetadata)injector.getInstance(DruidServerMetadata.class);
        Assert.assertNotNull((Object)druidServerMetadata);
        DruidServerMetadata other = (DruidServerMetadata)injector.getInstance(DruidServerMetadata.class);
        Assert.assertSame((Object)druidServerMetadata, (Object)other);
    }

    @Test
    public void testDruidServerMetadataWithNoServerTypeConfigShouldThrowProvisionException() {
        Injector injector = this.makeInjector(false);
        ExceptionMatcher.of(ProvisionException.class).expectMessageContains("Must override the binding for ServerTypeConfig if you want a DruidServerMetadata.").assertThrowsAndMatches(() -> injector.getInstance(DruidServerMetadata.class));
    }

    private Injector injector() {
        return this.makeInjector(true);
    }

    private Injector makeInjector(boolean withServerTypeConfig) {
        return Initialization.makeInjectorWithModules((Injector)GuiceInjectors.makeStartupInjector(), (Iterable)ImmutableList.of((Object)Modules.override((Module[])new Module[]{binder -> {
            binder.bind(DruidNode.class).annotatedWith(Self.class).toInstance((Object)this.self);
            binder.bindConstant().annotatedWith((Annotation)Names.named((String)"serviceName")).to("test");
            binder.bindConstant().annotatedWith((Annotation)Names.named((String)"servicePort")).to(0);
            binder.bindConstant().annotatedWith((Annotation)Names.named((String)"tlsServicePort")).to(-1);
            binder.bind(DruidProcessingConfig.class).toInstance((Object)this.druidProcessingConfig);
        }, this.target}).with(new Module[]{binder -> {
            binder.bind(SegmentLoaderConfig.class).toInstance((Object)this.segmentLoaderConfig);
            if (withServerTypeConfig) {
                binder.bind(ServerTypeConfig.class).toInstance((Object)this.serverTypeConfig);
            }
        }})));
    }

    private void mockSegmentCacheNotConfigured() {
        ((SegmentLoaderConfig)Mockito.doReturn(Collections.emptyList()).when((Object)this.segmentLoaderConfig)).getLocations();
    }
}

