/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.guice;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.inject.Inject;
import org.apache.druid.discovery.NodeRole;
import org.apache.druid.guice.DruidInjectorBuilder;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.StartupInjectorBuilder;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.guice.annotations.LoadScope;
import org.apache.druid.initialization.CoreInjectorBuilder;
import org.apache.druid.initialization.DruidModule;
import org.apache.druid.java.util.common.ISE;
import org.junit.Assert;
import org.junit.Test;

public class DruidInjectorBuilderTest {
    @Test
    public void testEmpty() {
        Properties props = new Properties();
        props.put("foo", "bar");
        Injector injector = new CoreInjectorBuilder(new StartupInjectorBuilder().forTests().withProperties(props).build()).build();
        Properties propsInstance = (Properties)injector.getInstance(Properties.class);
        Assert.assertSame((Object)props, (Object)propsInstance);
    }

    @Test
    public void testAddInputModules() throws IOException {
        Properties props = new Properties();
        props.put("foo", "bar");
        MockGuiceModule guiceModule = new MockGuiceModule();
        MockDruidModule druidModule = new MockDruidModule();
        Injector injector = new CoreInjectorBuilder(new StartupInjectorBuilder().forTests().withProperties(props).build()).addInput((Object)guiceModule).addInput((Object)druidModule).build();
        Assert.assertSame((Object)props, (Object)guiceModule.properties);
        Assert.assertSame((Object)props, (Object)druidModule.properties);
        this.verifyInjector(injector);
    }

    private void verifyInjector(Injector injector) throws IOException {
        Assert.assertTrue((boolean)(injector.getInstance(MockInterface.class) instanceof MockComponent));
        String json = "{\"type\": \"extn\"}";
        ObjectMapper om = (ObjectMapper)injector.getInstance(Key.get(ObjectMapper.class, Json.class));
        MockObject obj = (MockObject)om.readValue(json, MockObject.class);
        Assert.assertTrue((boolean)(obj instanceof MockObjectExtension));
    }

    @Test
    public void testAddInputClasses() throws IOException {
        Properties props = new Properties();
        props.put("foo", "bar");
        Injector injector = new CoreInjectorBuilder(new StartupInjectorBuilder().forTests().withProperties(props).build()).addInput(MockGuiceModule.class).addInput(MockDruidModule.class).build();
        this.verifyInjector(injector);
    }

    @Test
    public void testBadModule() {
        CoreInjectorBuilder builder = new CoreInjectorBuilder(new StartupInjectorBuilder().forTests().withEmptyProperties().build());
        Assert.assertThrows(ISE.class, () -> DruidInjectorBuilderTest.lambda$testBadModule$0((DruidInjectorBuilder)builder));
    }

    @Test
    public void testBadModuleClass() {
        CoreInjectorBuilder builder = new CoreInjectorBuilder(new StartupInjectorBuilder().forTests().withEmptyProperties().build());
        Assert.assertThrows(ISE.class, () -> DruidInjectorBuilderTest.lambda$testBadModuleClass$1((DruidInjectorBuilder)builder));
    }

    @Test
    public void testAddModules() throws IOException {
        Injector injector = new CoreInjectorBuilder(new StartupInjectorBuilder().forTests().withEmptyProperties().build()).addModules(new Module[]{new MockGuiceModule(), new MockDruidModule()}).build();
        this.verifyInjector(injector);
    }

    @Test
    public void testAddAll() throws IOException {
        Injector injector = new CoreInjectorBuilder(new StartupInjectorBuilder().forTests().withEmptyProperties().build()).addAll(Arrays.asList(new MockGuiceModule(), new MockDruidModule())).build();
        this.verifyInjector(injector);
    }

    @Test
    public void testExclude() {
        Properties props = new Properties();
        props.put("druid.modules.excludeList", "[\"" + MockDruidModule.class.getName() + "\"]");
        Injector injector = new CoreInjectorBuilder(new StartupInjectorBuilder().withExtensions().withProperties(props).build()).addInput(MockGuiceModule.class).addInput(MockDruidModule.class).build();
        Assert.assertThrows(IOException.class, () -> this.verifyInjector(injector));
    }

    @Test
    public void testMatchingNodeRole() throws IOException {
        Injector injector = new CoreInjectorBuilder(new StartupInjectorBuilder().forTests().withEmptyProperties().build(), (Set)ImmutableSet.of((Object)NodeRole.BROKER)).addModules(new Module[]{new MockGuiceModule(), new MockRoleModule()}).build();
        this.verifyInjector(injector);
    }

    @Test
    public void testNotMatchingNodeRole() {
        Injector injector = new CoreInjectorBuilder(new StartupInjectorBuilder().forTests().withEmptyProperties().build(), (Set)ImmutableSet.of((Object)NodeRole.COORDINATOR)).addModules(new Module[]{new MockGuiceModule(), new MockRoleModule()}).build();
        Assert.assertThrows(IOException.class, () -> this.verifyInjector(injector));
    }

    @Test
    public void testIgnoreNodeRole() throws IOException {
        Injector injector = new CoreInjectorBuilder(new StartupInjectorBuilder().forTests().withEmptyProperties().build(), (Set)ImmutableSet.of((Object)NodeRole.COORDINATOR)).ignoreLoadScopes().addModules(new Module[]{new MockGuiceModule(), new MockRoleModule()}).build();
        this.verifyInjector(injector);
    }

    private static /* synthetic */ void lambda$testBadModuleClass$1(DruidInjectorBuilder builder) throws Throwable {
        builder.addInput(Object.class);
    }

    private static /* synthetic */ void lambda$testBadModule$0(DruidInjectorBuilder builder) throws Throwable {
        builder.addInput((Object)"I'm not a module");
    }

    private static class MockGuiceModule
    implements Module {
        @Inject
        public Properties properties;

        private MockGuiceModule() {
        }

        public void configure(Binder binder) {
            binder.bind(MockInterface.class).to(MockComponent.class).in(LazySingleton.class);
        }
    }

    private static class MockDruidModule
    implements DruidModule {
        @Inject
        public Properties properties;

        private MockDruidModule() {
        }

        public void configure(Binder binder) {
        }

        public List<? extends com.fasterxml.jackson.databind.Module> getJacksonModules() {
            return ImmutableList.of((Object)new SimpleModule("MockModule").registerSubtypes(new Class[]{MockObjectExtension.class}));
        }
    }

    public static interface MockInterface {
    }

    public static class MockComponent
    implements MockInterface {
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
    public static class MockObject {
    }

    @JsonTypeName(value="extn")
    public static class MockObjectExtension
    extends MockObject {
    }

    @LoadScope(roles={"broker"})
    private static class MockRoleModule
    extends MockDruidModule {
        private MockRoleModule() {
        }
    }
}

