/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.discovery;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.druid.discovery.BaseNodeRoleWatcher;
import org.apache.druid.discovery.DiscoveryDruidNode;
import org.apache.druid.discovery.DruidNodeDiscovery;
import org.apache.druid.discovery.NodeRole;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.server.DruidNode;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class BaseNodeRoleWatcherTest {
    private static ScheduledExecutorService exec;

    @BeforeClass
    public static void setup() {
        exec = BaseNodeRoleWatcherTest.createScheduledSingleThreadedExecutor();
    }

    @AfterClass
    public static void teardown() {
        exec.shutdown();
    }

    @Test(timeout=60000L)
    public void testGeneralUseSimulation() {
        BaseNodeRoleWatcher nodeRoleWatcher = BaseNodeRoleWatcher.create((ScheduledExecutorService)exec, (NodeRole)NodeRole.BROKER);
        DiscoveryDruidNode broker1 = this.buildDiscoveryDruidNode(NodeRole.BROKER, "broker1");
        DiscoveryDruidNode broker2 = this.buildDiscoveryDruidNode(NodeRole.BROKER, "broker2");
        DiscoveryDruidNode broker3 = this.buildDiscoveryDruidNode(NodeRole.BROKER, "broker3");
        DiscoveryDruidNode notBroker = new DiscoveryDruidNode(new DruidNode("s3", "h3", false, Integer.valueOf(8080), null, true, false), NodeRole.COORDINATOR, (Map)ImmutableMap.of());
        TestListener listener1 = new TestListener();
        TestListener listener2 = new TestListener();
        TestListener listener3 = new TestListener();
        nodeRoleWatcher.registerListener((DruidNodeDiscovery.Listener)listener1);
        nodeRoleWatcher.childAdded(broker1);
        nodeRoleWatcher.childAdded(broker2);
        nodeRoleWatcher.childAdded(notBroker);
        nodeRoleWatcher.childAdded(broker3);
        nodeRoleWatcher.registerListener((DruidNodeDiscovery.Listener)listener2);
        nodeRoleWatcher.childRemoved(broker2);
        this.assertListener(listener1, false, Collections.emptyList(), Collections.emptyList());
        this.assertListener(listener2, false, Collections.emptyList(), Collections.emptyList());
        nodeRoleWatcher.cacheInitialized();
        nodeRoleWatcher.registerListener((DruidNodeDiscovery.Listener)listener3);
        ArrayList<DiscoveryDruidNode> presentNodes = new ArrayList<DiscoveryDruidNode>(nodeRoleWatcher.getAllNodes());
        Assert.assertEquals((long)2L, (long)presentNodes.size());
        Assert.assertTrue((boolean)presentNodes.contains(broker1));
        Assert.assertTrue((boolean)presentNodes.contains(broker3));
        this.assertListener(listener1, true, presentNodes, Collections.emptyList());
        this.assertListener(listener2, true, presentNodes, Collections.emptyList());
        this.assertListener(listener3, true, presentNodes, Collections.emptyList());
        nodeRoleWatcher.childRemoved(notBroker);
        nodeRoleWatcher.childRemoved(broker2);
        nodeRoleWatcher.childAdded(broker2);
        nodeRoleWatcher.childRemoved(broker3);
        nodeRoleWatcher.childAdded(broker1);
        Assert.assertEquals((Object)ImmutableSet.of((Object)broker2, (Object)broker1), new HashSet(nodeRoleWatcher.getAllNodes()));
        ArrayList<DiscoveryDruidNode> nodesAdded = new ArrayList<DiscoveryDruidNode>(presentNodes);
        nodesAdded.add(broker2);
        ArrayList<DiscoveryDruidNode> nodesRemoved = new ArrayList<DiscoveryDruidNode>();
        nodesRemoved.add(broker3);
        this.assertListener(listener1, true, nodesAdded, nodesRemoved);
        this.assertListener(listener2, true, nodesAdded, nodesRemoved);
        this.assertListener(listener3, true, nodesAdded, nodesRemoved);
        LinkedHashMap<String, DiscoveryDruidNode> resetNodes = new LinkedHashMap<String, DiscoveryDruidNode>();
        resetNodes.put(broker2.getDruidNode().getHostAndPortToUse(), broker2);
        resetNodes.put(broker3.getDruidNode().getHostAndPortToUse(), broker3);
        nodeRoleWatcher.resetNodes(resetNodes);
        Assert.assertEquals((Object)ImmutableSet.of((Object)broker2, (Object)broker3), new HashSet(nodeRoleWatcher.getAllNodes()));
        nodesAdded.add(broker3);
        nodesRemoved.add(broker1);
        this.assertListener(listener1, true, nodesAdded, nodesRemoved);
        this.assertListener(listener2, true, nodesAdded, nodesRemoved);
        this.assertListener(listener3, true, nodesAdded, nodesRemoved);
    }

    @Test(timeout=60000L)
    public void testRegisterListenerBeforeTimeout() throws InterruptedException {
        BaseNodeRoleWatcher nodeRoleWatcher = new BaseNodeRoleWatcher(exec, NodeRole.BROKER);
        TestListener listener1 = new TestListener();
        nodeRoleWatcher.registerListener((DruidNodeDiscovery.Listener)listener1);
        DiscoveryDruidNode broker1 = this.buildDiscoveryDruidNode(NodeRole.BROKER, "broker1");
        DiscoveryDruidNode broker2 = this.buildDiscoveryDruidNode(NodeRole.BROKER, "broker2");
        DiscoveryDruidNode broker3 = this.buildDiscoveryDruidNode(NodeRole.BROKER, "broker3");
        DiscoveryDruidNode notBroker = new DiscoveryDruidNode(new DruidNode("s3", "h3", false, Integer.valueOf(8080), null, true, false), NodeRole.COORDINATOR, (Map)ImmutableMap.of());
        nodeRoleWatcher.childAdded(broker1);
        nodeRoleWatcher.childAdded(notBroker);
        nodeRoleWatcher.childAdded(broker3);
        nodeRoleWatcher.childRemoved(broker2);
        this.assertListener(listener1, false, Collections.emptyList(), Collections.emptyList());
        nodeRoleWatcher.scheduleTimeout(0L);
        nodeRoleWatcher.awaitInitialization();
        Assert.assertTrue((boolean)listener1.nodeViewInitializationTimedOut.get());
        this.assertListener(listener1, true, (List<DiscoveryDruidNode>)ImmutableList.of((Object)broker1, (Object)broker3), (List<DiscoveryDruidNode>)ImmutableList.of());
    }

    @Test(timeout=60000L)
    public void testGetAllNodesBeforeTimeout() throws InterruptedException {
        BaseNodeRoleWatcher nodeRoleWatcher = new BaseNodeRoleWatcher(exec, NodeRole.BROKER);
        TestListener listener1 = new TestListener();
        nodeRoleWatcher.registerListener((DruidNodeDiscovery.Listener)listener1);
        DiscoveryDruidNode broker1 = this.buildDiscoveryDruidNode(NodeRole.BROKER, "broker1");
        DiscoveryDruidNode broker2 = this.buildDiscoveryDruidNode(NodeRole.BROKER, "broker2");
        DiscoveryDruidNode broker3 = this.buildDiscoveryDruidNode(NodeRole.BROKER, "broker3");
        DiscoveryDruidNode notBroker = new DiscoveryDruidNode(new DruidNode("s3", "h3", false, Integer.valueOf(8080), null, true, false), NodeRole.COORDINATOR, (Map)ImmutableMap.of());
        nodeRoleWatcher.childAdded(broker1);
        nodeRoleWatcher.childAdded(broker2);
        nodeRoleWatcher.childAdded(notBroker);
        nodeRoleWatcher.childAdded(broker3);
        nodeRoleWatcher.childRemoved(broker2);
        this.assertListener(listener1, false, Collections.emptyList(), Collections.emptyList());
        nodeRoleWatcher.scheduleTimeout(0L);
        nodeRoleWatcher.awaitInitialization();
        Assert.assertEquals((long)2L, (long)nodeRoleWatcher.getAllNodes().size());
        Assert.assertTrue((boolean)listener1.nodeViewInitializationTimedOut.get());
        this.assertListener(listener1, true, (List<DiscoveryDruidNode>)ImmutableList.of((Object)broker1, (Object)broker3), (List<DiscoveryDruidNode>)ImmutableList.of());
    }

    private DiscoveryDruidNode buildDiscoveryDruidNode(NodeRole role, String host) {
        return new DiscoveryDruidNode(new DruidNode("s", host, false, Integer.valueOf(8080), null, true, false), role, (Map)ImmutableMap.of());
    }

    private void assertListener(TestListener listener, boolean ready, List<DiscoveryDruidNode> nodesAdded, List<DiscoveryDruidNode> nodesRemoved) {
        int count = ready ? 0 : 1;
        Assert.assertEquals((long)count, (long)listener.ready.getCount());
        Assert.assertEquals(nodesAdded, listener.nodesAddedList);
        Assert.assertEquals(nodesRemoved, listener.nodesRemovedList);
    }

    private static ScheduledExecutorService createScheduledSingleThreadedExecutor() {
        return new ScheduledThreadPoolExecutor(1, Execs.makeThreadFactory((String)"BaseNodeRoleWatcher")){

            @Override
            public Future<?> submit(Runnable task) {
                task.run();
                return Futures.immediateFuture(null);
            }
        };
    }

    public static class TestListener
    implements DruidNodeDiscovery.Listener {
        private final CountDownLatch ready = new CountDownLatch(1);
        private final AtomicBoolean nodeViewInitializationTimedOut = new AtomicBoolean(false);
        private final List<DiscoveryDruidNode> nodesAddedList = new ArrayList<DiscoveryDruidNode>();
        private final List<DiscoveryDruidNode> nodesRemovedList = new ArrayList<DiscoveryDruidNode>();

        public void nodesAdded(Collection<DiscoveryDruidNode> nodes) {
            this.nodesAddedList.addAll(nodes);
        }

        public void nodesRemoved(Collection<DiscoveryDruidNode> nodes) {
            this.nodesRemovedList.addAll(nodes);
        }

        public void nodeViewInitialized() {
            if (this.ready.getCount() == 0L) {
                throw new RuntimeException("NodeViewInitialized called again!");
            }
            this.ready.countDown();
        }

        public void nodeViewInitializedTimedOut() {
            if (!this.nodeViewInitializationTimedOut.compareAndSet(false, true)) {
                throw new RuntimeException("NodeViewInitializedTimedOut called again!");
            }
            if (this.ready.getCount() == 0L) {
                throw new RuntimeException("NodeViewInitialized was already called!");
            }
            this.ready.countDown();
        }
    }
}

