/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.curator.announcement;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.CuratorEvent;
import org.apache.curator.framework.api.CuratorEventType;
import org.apache.curator.framework.api.CuratorListener;
import org.apache.curator.framework.api.GetDataWatchBackgroundStatable;
import org.apache.curator.framework.api.transaction.CuratorOp;
import org.apache.curator.framework.api.transaction.CuratorTransactionResult;
import org.apache.curator.test.KillSession;
import org.apache.curator.utils.ZKPaths;
import org.apache.druid.curator.CuratorTestBase;
import org.apache.druid.curator.announcement.PathChildrenAnnouncer;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PathChildrenAnnouncerTest
extends CuratorTestBase {
    private static final Logger log = new Logger(PathChildrenAnnouncerTest.class);
    private ExecutorService exec;

    @Before
    public void setUp() throws Exception {
        this.setupServerAndCurator();
        this.exec = Execs.singleThreaded((String)"test-announcer-sanity-%s");
        this.curator.start();
        this.curator.blockUntilConnected();
    }

    @After
    public void tearDown() {
        this.tearDownServerAndCurator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testSanity() throws Exception {
        PathChildrenAnnouncer announcer = new PathChildrenAnnouncer(this.curator, this.exec);
        announcer.initializeAddedChildren();
        byte[] billy = StringUtils.toUtf8((String)"billy");
        String testPath1 = "/test1";
        String testPath2 = "/somewhere/test2";
        announcer.announce("/test1", billy);
        Assert.assertNull((String)"/test1 does not exists", (Object)this.curator.checkExists().forPath("/test1"));
        Assert.assertNull((String)"/somewhere/test2 does not exists", (Object)this.curator.checkExists().forPath("/somewhere/test2"));
        announcer.start();
        while (!announcer.getAddedChildren().contains("/test1")) {
            Thread.sleep(100L);
        }
        try {
            Assert.assertArrayEquals((String)"/test1 has data", (byte[])billy, (byte[])((byte[])((GetDataWatchBackgroundStatable)this.curator.getData().decompressed()).forPath("/test1")));
            Assert.assertNull((String)"/somewhere/test2 still does not exist", (Object)this.curator.checkExists().forPath("/somewhere/test2"));
            announcer.announce("/somewhere/test2", billy);
            Assert.assertArrayEquals((String)"/test1 still has data", (byte[])billy, (byte[])((byte[])((GetDataWatchBackgroundStatable)this.curator.getData().decompressed()).forPath("/test1")));
            Assert.assertArrayEquals((String)"/somewhere/test2 has data", (byte[])billy, (byte[])((byte[])((GetDataWatchBackgroundStatable)this.curator.getData().decompressed()).forPath("/somewhere/test2")));
            CountDownLatch latch = this.createCountdownLatchForPaths("/test1");
            CuratorOp deleteOp = (CuratorOp)this.curator.transactionOp().delete().forPath("/test1");
            List results = this.curator.transaction().forOperations(new CuratorOp[]{deleteOp});
            Assert.assertEquals((long)1L, (long)results.size());
            CuratorTransactionResult result = (CuratorTransactionResult)results.iterator().next();
            Assert.assertEquals((long)KeeperException.Code.OK.intValue(), (long)result.getError());
            Assert.assertTrue((String)"Wait for /test1 to be created", (boolean)this.timing.forWaiting().awaitLatch(latch));
            Assert.assertArrayEquals((String)"expect /test1 data is restored", (byte[])billy, (byte[])((byte[])((GetDataWatchBackgroundStatable)this.curator.getData().decompressed()).forPath("/test1")));
            Assert.assertArrayEquals((String)"expect /somewhere/test2 is still there", (byte[])billy, (byte[])((byte[])((GetDataWatchBackgroundStatable)this.curator.getData().decompressed()).forPath("/somewhere/test2")));
            announcer.unannounce("/test1");
            Assert.assertNull((String)"expect /test1 unannounced", (Object)this.curator.checkExists().forPath("/test1"));
            Assert.assertArrayEquals((String)"expect /somewhere/test2 is still still there", (byte[])billy, (byte[])((byte[])((GetDataWatchBackgroundStatable)this.curator.getData().decompressed()).forPath("/somewhere/test2")));
        }
        finally {
            announcer.stop();
        }
        Assert.assertNull((String)"expect /test1 remains unannounced", (Object)this.curator.checkExists().forPath("/test1"));
        Assert.assertNull((String)"expect /somewhere/test2 unannounced", (Object)this.curator.checkExists().forPath("/somewhere/test2"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testSessionKilled() throws Exception {
        PathChildrenAnnouncer announcer = new PathChildrenAnnouncer(this.curator, this.exec);
        try {
            CuratorOp createOp = (CuratorOp)this.curator.transactionOp().create().forPath("/somewhere");
            this.curator.transaction().forOperations(new CuratorOp[]{createOp});
            announcer.start();
            byte[] billy = StringUtils.toUtf8((String)"billy");
            String testPath1 = "/test1";
            String testPath2 = "/somewhere/test2";
            String[] paths = new String[]{"/test1", "/somewhere/test2"};
            announcer.announce("/test1", billy);
            announcer.announce("/somewhere/test2", billy);
            Assert.assertArrayEquals((byte[])billy, (byte[])((byte[])((GetDataWatchBackgroundStatable)this.curator.getData().decompressed()).forPath("/test1")));
            Assert.assertArrayEquals((byte[])billy, (byte[])((byte[])((GetDataWatchBackgroundStatable)this.curator.getData().decompressed()).forPath("/somewhere/test2")));
            CountDownLatch latch = this.createCountdownLatchForPaths(paths);
            KillSession.kill((ZooKeeper)this.curator.getZookeeperClient().getZooKeeper(), (String)this.server.getConnectString());
            Assert.assertTrue((boolean)this.timing.forWaiting().awaitLatch(latch));
            Assert.assertArrayEquals((byte[])billy, (byte[])((byte[])((GetDataWatchBackgroundStatable)this.curator.getData().decompressed()).forPath("/test1")));
            Assert.assertArrayEquals((byte[])billy, (byte[])((byte[])((GetDataWatchBackgroundStatable)this.curator.getData().decompressed()).forPath("/somewhere/test2")));
            announcer.stop();
            while (this.curator.checkExists().forPath("/test1") != null || this.curator.checkExists().forPath("/somewhere/test2") != null) {
                Thread.sleep(100L);
            }
            Assert.assertNull((Object)this.curator.checkExists().forPath("/test1"));
            Assert.assertNull((Object)this.curator.checkExists().forPath("/somewhere/test2"));
        }
        finally {
            announcer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRemovesParentIfCreated() throws Exception {
        PathChildrenAnnouncer announcer = new PathChildrenAnnouncer(this.curator, this.exec);
        byte[] billy = StringUtils.toUtf8((String)"billy");
        String testPath = "/somewhere/test2";
        String parent = ZKPaths.getPathAndNode((String)"/somewhere/test2").getPath();
        announcer.start();
        try {
            Assert.assertNull((Object)this.curator.checkExists().forPath(parent));
            this.awaitAnnounce(announcer, "/somewhere/test2", billy, true);
            Assert.assertNotNull((Object)this.curator.checkExists().forPath(parent));
        }
        finally {
            announcer.stop();
        }
        Assert.assertNull((Object)this.curator.checkExists().forPath(parent));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLeavesBehindParentPathIfAlreadyExists() throws Exception {
        PathChildrenAnnouncer announcer = new PathChildrenAnnouncer(this.curator, this.exec);
        byte[] billy = StringUtils.toUtf8((String)"billy");
        String testPath = "/somewhere/test";
        String parent = ZKPaths.getPathAndNode((String)"/somewhere/test").getPath();
        this.curator.create().forPath(parent);
        Stat initialStat = (Stat)this.curator.checkExists().forPath(parent);
        announcer.start();
        try {
            Assert.assertEquals((long)initialStat.getMzxid(), (long)((Stat)this.curator.checkExists().forPath(parent)).getMzxid());
            this.awaitAnnounce(announcer, "/somewhere/test", billy, true);
            Assert.assertEquals((long)initialStat.getMzxid(), (long)((Stat)this.curator.checkExists().forPath(parent)).getMzxid());
        }
        finally {
            announcer.stop();
        }
        Assert.assertEquals((long)initialStat.getMzxid(), (long)((Stat)this.curator.checkExists().forPath(parent)).getMzxid());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLeavesParentPathsUntouchedWhenInstructed() throws Exception {
        PathChildrenAnnouncer announcer = new PathChildrenAnnouncer(this.curator, this.exec);
        byte[] billy = StringUtils.toUtf8((String)"billy");
        String testPath = "/somewhere/test";
        String parent = ZKPaths.getPathAndNode((String)"/somewhere/test").getPath();
        announcer.start();
        try {
            Assert.assertNull((Object)this.curator.checkExists().forPath(parent));
            this.awaitAnnounce(announcer, "/somewhere/test", billy, false);
            Assert.assertNotNull((Object)this.curator.checkExists().forPath(parent));
        }
        finally {
            announcer.stop();
        }
        Assert.assertNotNull((Object)this.curator.checkExists().forPath(parent));
    }

    private void awaitAnnounce(PathChildrenAnnouncer announcer, String path, byte[] bytes, boolean removeParentsIfCreated) throws InterruptedException {
        CountDownLatch latch = this.createCountdownLatchForPaths(path);
        announcer.announce(path, bytes, removeParentsIfCreated);
        latch.await();
    }

    private CountDownLatch createCountdownLatchForPaths(final String ... path) {
        final CountDownLatch latch = new CountDownLatch(path.length);
        this.curator.getCuratorListenable().addListener((Object)new CuratorListener(){

            public void eventReceived(CuratorFramework client, CuratorEvent event) {
                if (event.getType() == CuratorEventType.CREATE && Arrays.asList(path).contains(event.getPath())) {
                    latch.countDown();
                }
            }
        });
        return latch;
    }
}

