/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.curator.announcement;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import org.apache.curator.framework.api.CuratorEventType;
import org.apache.curator.framework.api.GetDataWatchBackgroundStatable;
import org.apache.curator.framework.api.transaction.CuratorOp;
import org.apache.curator.framework.api.transaction.CuratorTransactionResult;
import org.apache.curator.test.KillSession;
import org.apache.curator.utils.ZKPaths;
import org.apache.druid.curator.CuratorTestBase;
import org.apache.druid.curator.announcement.NodeAnnouncer;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class NodeAnnouncerTest
extends CuratorTestBase {
    private ExecutorService exec;

    @BeforeEach
    public void setUp() throws Exception {
        this.setupServerAndCurator();
        this.exec = Execs.singleThreaded((String)"test-node-announcer-sanity-%s");
        this.curator.start();
        this.curator.blockUntilConnected();
    }

    @AfterEach
    public void tearDown() {
        this.tearDownServerAndCurator();
    }

    @Test
    @Timeout(value=60000L)
    public void testCreateParentPath() throws Exception {
        NodeAnnouncer announcer = new NodeAnnouncer(this.curator, this.exec);
        byte[] billy = StringUtils.toUtf8((String)"billy");
        String testPath = "/newParent/testPath";
        String parentPath = ZKPaths.getPathAndNode((String)"/newParent/testPath").getPath();
        announcer.start();
        Assertions.assertNull((Object)this.curator.checkExists().forPath(parentPath), (String)"Parent path should not exist before announcement");
        announcer.announce("/newParent/testPath", billy);
        while (this.curator.checkExists().forPath("/newParent/testPath") == null) {
            Thread.sleep(100L);
        }
        Assertions.assertNotNull((Object)this.curator.checkExists().forPath(parentPath), (String)"Parent path should be created");
        Assertions.assertArrayEquals((byte[])billy, (byte[])((byte[])((GetDataWatchBackgroundStatable)this.curator.getData().decompressed()).forPath("/newParent/testPath")));
        announcer.stop();
    }

    @Test
    @Timeout(value=60000L)
    public void testAnnounceSamePathWithDifferentPayloadThrowsIAE() throws Exception {
        NodeAnnouncer announcer = new NodeAnnouncer(this.curator, this.exec);
        byte[] billy = StringUtils.toUtf8((String)"billy");
        byte[] tilly = StringUtils.toUtf8((String)"tilly");
        String testPath = "/testPath";
        announcer.start();
        announcer.announce("/testPath", billy);
        while (this.curator.checkExists().forPath("/testPath") == null) {
            Thread.sleep(100L);
        }
        Assertions.assertArrayEquals((byte[])billy, (byte[])((byte[])((GetDataWatchBackgroundStatable)this.curator.getData().decompressed()).forPath("/testPath")));
        announcer.announce("/testPath", billy);
        IAE exception = (IAE)Assertions.assertThrows(IAE.class, () -> announcer.announce("/testPath", tilly));
        Assertions.assertEquals((Object)"Cannot reannounce different values under the same path.", (Object)exception.getMessage());
        Assertions.assertArrayEquals((byte[])billy, (byte[])((byte[])((GetDataWatchBackgroundStatable)this.curator.getData().decompressed()).forPath("/testPath")));
        announcer.stop();
    }

    @Test
    public void testUpdateBeforeStartingNodeAnnouncer() throws Exception {
        NodeAnnouncer announcer = new NodeAnnouncer(this.curator, this.exec);
        byte[] billy = StringUtils.toUtf8((String)"billy");
        byte[] tilly = StringUtils.toUtf8((String)"tilly");
        String testPath = "/testAnnounce";
        announcer.update("/testAnnounce", tilly);
        announcer.announce("/testAnnounce", billy);
        announcer.start();
        Assertions.assertArrayEquals((byte[])tilly, (byte[])((byte[])((GetDataWatchBackgroundStatable)this.curator.getData().decompressed()).forPath("/testAnnounce")));
        announcer.stop();
    }

    @Test
    public void testUpdateSuccessfully() throws Exception {
        NodeAnnouncer announcer = new NodeAnnouncer(this.curator, this.exec);
        byte[] billy = StringUtils.toUtf8((String)"billy");
        byte[] tilly = StringUtils.toUtf8((String)"tilly");
        String testPath = "/testUpdate";
        announcer.start();
        announcer.announce("/testUpdate", billy);
        Assertions.assertArrayEquals((byte[])billy, (byte[])((byte[])((GetDataWatchBackgroundStatable)this.curator.getData().decompressed()).forPath("/testUpdate")));
        announcer.update("/testUpdate", billy);
        Assertions.assertArrayEquals((byte[])billy, (byte[])((byte[])((GetDataWatchBackgroundStatable)this.curator.getData().decompressed()).forPath("/testUpdate")));
        announcer.update("/testUpdate", tilly);
        Assertions.assertArrayEquals((byte[])tilly, (byte[])((byte[])((GetDataWatchBackgroundStatable)this.curator.getData().decompressed()).forPath("/testUpdate")));
        announcer.stop();
    }

    @Test
    public void testUpdateNonExistentPath() {
        NodeAnnouncer announcer = new NodeAnnouncer(this.curator, this.exec);
        byte[] billy = StringUtils.toUtf8((String)"billy");
        String testPath = "/testUpdate";
        announcer.start();
        ISE exception = (ISE)Assertions.assertThrows(ISE.class, () -> announcer.update("/testUpdate", billy));
        Assertions.assertEquals((Object)"Cannot update path[/testUpdate] that hasn't been announced!", (Object)exception.getMessage());
        announcer.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=60000L)
    public void testSanity() throws Exception {
        NodeAnnouncer announcer = new NodeAnnouncer(this.curator, this.exec);
        byte[] billy = StringUtils.toUtf8((String)"billy");
        String testPath1 = "/test1";
        String testPath2 = "/somewhere/test2";
        announcer.announce("/test1", billy);
        Assertions.assertNull((Object)this.curator.checkExists().forPath("/test1"), (String)"/test1 does not exist before announcer start");
        Assertions.assertNull((Object)this.curator.checkExists().forPath("/somewhere/test2"), (String)"/somewhere/test2 does not exist before announcer start");
        announcer.start();
        while (!announcer.getAddedPaths().contains("/test1")) {
            Thread.sleep(100L);
        }
        try {
            Assertions.assertArrayEquals((byte[])billy, (byte[])((byte[])((GetDataWatchBackgroundStatable)this.curator.getData().decompressed()).forPath("/test1")), (String)"/test1 has data");
            Assertions.assertNull((Object)this.curator.checkExists().forPath("/somewhere/test2"), (String)"/somewhere/test2 still does not exist");
            announcer.announce("/somewhere/test2", billy);
            Assertions.assertArrayEquals((byte[])billy, (byte[])((byte[])((GetDataWatchBackgroundStatable)this.curator.getData().decompressed()).forPath("/test1")), (String)"/test1 still has data");
            Assertions.assertArrayEquals((byte[])billy, (byte[])((byte[])((GetDataWatchBackgroundStatable)this.curator.getData().decompressed()).forPath("/somewhere/test2")), (String)"/somewhere/test2 has data");
            CountDownLatch latch = new CountDownLatch(1);
            this.curator.getCuratorListenable().addListener((client, event) -> {
                if (event.getType() == CuratorEventType.CREATE && event.getPath().equals("/test1")) {
                    latch.countDown();
                }
            });
            CuratorOp deleteOp = (CuratorOp)this.curator.transactionOp().delete().forPath("/test1");
            List results = this.curator.transaction().forOperations(new CuratorOp[]{deleteOp});
            Assertions.assertEquals((int)1, (int)results.size(), (String)"Expected one result from the delete op");
            CuratorTransactionResult result = (CuratorTransactionResult)results.iterator().next();
            Assertions.assertEquals((int)KeeperException.Code.OK.intValue(), (int)result.getError(), (String)"Expected OK code on delete");
            Assertions.assertTrue((boolean)this.timing.forWaiting().awaitLatch(latch), (String)"Wait for /test1 to be recreated");
            Assertions.assertArrayEquals((byte[])billy, (byte[])((byte[])((GetDataWatchBackgroundStatable)this.curator.getData().decompressed()).forPath("/test1")), (String)"Expected /test1 data to be restored");
            Assertions.assertArrayEquals((byte[])billy, (byte[])((byte[])((GetDataWatchBackgroundStatable)this.curator.getData().decompressed()).forPath("/somewhere/test2")), (String)"Expected /somewhere/test2 data to remain");
            announcer.unannounce("/test1");
            Assertions.assertNull((Object)this.curator.checkExists().forPath("/test1"), (String)"Expected /test1 to be unannounced");
            Assertions.assertArrayEquals((byte[])billy, (byte[])((byte[])((GetDataWatchBackgroundStatable)this.curator.getData().decompressed()).forPath("/somewhere/test2")), (String)"Expected /somewhere/test2 to remain");
        }
        finally {
            announcer.stop();
        }
        Assertions.assertNull((Object)this.curator.checkExists().forPath("/test1"), (String)"Expected /test1 to remain unannounced");
        Assertions.assertNull((Object)this.curator.checkExists().forPath("/somewhere/test2"), (String)"Expected /somewhere/test2 to be unannounced");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=60000L)
    public void testSessionKilled() throws Exception {
        NodeAnnouncer announcer = new NodeAnnouncer(this.curator, this.exec);
        try {
            CuratorOp createOp = (CuratorOp)this.curator.transactionOp().create().forPath("/somewhere");
            this.curator.transaction().forOperations(new CuratorOp[]{createOp});
            announcer.start();
            byte[] billy = StringUtils.toUtf8((String)"billy");
            String testPath1 = "/test1";
            String testPath2 = "/somewhere/test2";
            String[] paths = new String[]{"/test1", "/somewhere/test2"};
            announcer.announce("/test1", billy);
            announcer.announce("/somewhere/test2", billy);
            Assertions.assertArrayEquals((byte[])billy, (byte[])((byte[])((GetDataWatchBackgroundStatable)this.curator.getData().decompressed()).forPath("/test1")));
            Assertions.assertArrayEquals((byte[])billy, (byte[])((byte[])((GetDataWatchBackgroundStatable)this.curator.getData().decompressed()).forPath("/somewhere/test2")));
            CountDownLatch latch = this.createCountdownLatchForPaths(paths);
            KillSession.kill((ZooKeeper)this.curator.getZookeeperClient().getZooKeeper(), (String)this.server.getConnectString());
            Assertions.assertTrue((boolean)this.timing.forWaiting().awaitLatch(latch), (String)"Await latch after killing session");
            Assertions.assertArrayEquals((byte[])billy, (byte[])((byte[])((GetDataWatchBackgroundStatable)this.curator.getData().decompressed()).forPath("/test1")));
            Assertions.assertArrayEquals((byte[])billy, (byte[])((byte[])((GetDataWatchBackgroundStatable)this.curator.getData().decompressed()).forPath("/somewhere/test2")));
            announcer.stop();
            while (this.curator.checkExists().forPath("/test1") != null || this.curator.checkExists().forPath("/somewhere/test2") != null) {
                Thread.sleep(100L);
            }
            Assertions.assertNull((Object)this.curator.checkExists().forPath("/test1"));
            Assertions.assertNull((Object)this.curator.checkExists().forPath("/somewhere/test2"));
        }
        finally {
            announcer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRemovesParentIfCreated() throws Exception {
        NodeAnnouncer announcer = new NodeAnnouncer(this.curator, this.exec);
        byte[] billy = StringUtils.toUtf8((String)"billy");
        String testPath = "/somewhere/test";
        String parent = ZKPaths.getPathAndNode((String)"/somewhere/test").getPath();
        announcer.start();
        try {
            Assertions.assertNull((Object)this.curator.checkExists().forPath(parent));
            this.awaitAnnounce(announcer, "/somewhere/test", billy, true);
            Assertions.assertNotNull((Object)this.curator.checkExists().forPath(parent));
        }
        finally {
            announcer.stop();
        }
        Assertions.assertNull((Object)this.curator.checkExists().forPath(parent));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLeavesBehindParentPathIfAlreadyExists() throws Exception {
        NodeAnnouncer announcer = new NodeAnnouncer(this.curator, this.exec);
        byte[] billy = StringUtils.toUtf8((String)"billy");
        String testPath = "/somewhere/test2";
        String parent = ZKPaths.getPathAndNode((String)"/somewhere/test2").getPath();
        this.curator.create().forPath(parent);
        Stat initialStat = (Stat)this.curator.checkExists().forPath(parent);
        announcer.start();
        try {
            Assertions.assertEquals((long)initialStat.getMzxid(), (long)((Stat)this.curator.checkExists().forPath(parent)).getMzxid());
            this.awaitAnnounce(announcer, "/somewhere/test2", billy, true);
            Assertions.assertEquals((long)initialStat.getMzxid(), (long)((Stat)this.curator.checkExists().forPath(parent)).getMzxid());
        }
        finally {
            announcer.stop();
        }
        Assertions.assertEquals((long)initialStat.getMzxid(), (long)((Stat)this.curator.checkExists().forPath(parent)).getMzxid());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLeavesParentPathsUntouchedWhenInstructed() throws Exception {
        NodeAnnouncer announcer = new NodeAnnouncer(this.curator, this.exec);
        byte[] billy = StringUtils.toUtf8((String)"billy");
        String testPath = "/somewhere/test2";
        String parent = ZKPaths.getPathAndNode((String)"/somewhere/test2").getPath();
        announcer.start();
        try {
            Assertions.assertNull((Object)this.curator.checkExists().forPath(parent));
            this.awaitAnnounce(announcer, "/somewhere/test2", billy, false);
            Assertions.assertNotNull((Object)this.curator.checkExists().forPath(parent));
        }
        finally {
            announcer.stop();
        }
        Assertions.assertNotNull((Object)this.curator.checkExists().forPath(parent));
    }

    private void awaitAnnounce(NodeAnnouncer announcer, String path, byte[] bytes, boolean removeParentsIfCreated) throws InterruptedException {
        CountDownLatch latch = this.createCountdownLatchForPaths(path);
        announcer.announce(path, bytes, removeParentsIfCreated);
        latch.await();
    }

    private CountDownLatch createCountdownLatchForPaths(String ... paths) {
        CountDownLatch latch = new CountDownLatch(paths.length);
        this.curator.getCuratorListenable().addListener((client, event) -> {
            if (event.getType() == CuratorEventType.CREATE && Arrays.asList(paths).contains(event.getPath())) {
                latch.countDown();
            }
        });
        return latch;
    }
}

