/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client.selector;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.client.DirectDruidClient;
import org.apache.druid.client.DruidServer;
import org.apache.druid.client.QueryableDruidServer;
import org.apache.druid.client.selector.ConnectionCountServerSelectorStrategy;
import org.apache.druid.client.selector.CustomTierSelectorStrategy;
import org.apache.druid.client.selector.CustomTierSelectorStrategyConfig;
import org.apache.druid.client.selector.HighestPriorityTierSelectorStrategy;
import org.apache.druid.client.selector.HistoricalFilter;
import org.apache.druid.client.selector.LowestPriorityTierSelectorStrategy;
import org.apache.druid.client.selector.PreferredTierSelectorStrategy;
import org.apache.druid.client.selector.PreferredTierSelectorStrategyConfig;
import org.apache.druid.client.selector.RandomServerSelectorStrategy;
import org.apache.druid.client.selector.ServerSelector;
import org.apache.druid.client.selector.ServerSelectorStrategy;
import org.apache.druid.client.selector.TierSelectorStrategy;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.query.CloneQueryMode;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.server.coordination.DruidServerMetadata;
import org.apache.druid.server.coordination.ServerType;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.NoneShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class TierSelectorStrategyTest {
    @Test
    public void testHighestPriorityTierSelectorStrategyRealtime() {
        DirectDruidClient client = (DirectDruidClient)EasyMock.createMock(DirectDruidClient.class);
        QueryableDruidServer lowPriority = new QueryableDruidServer(new DruidServer("test1", "localhost", null, 0L, ServerType.REALTIME, "_default_tier", 0), (QueryRunner)client);
        QueryableDruidServer highPriority = new QueryableDruidServer(new DruidServer("test1", "localhost", null, 0L, ServerType.REALTIME, "_default_tier", 1), (QueryRunner)client);
        this.testTierSelectorStrategy((TierSelectorStrategy)new HighestPriorityTierSelectorStrategy((ServerSelectorStrategy)new ConnectionCountServerSelectorStrategy()), highPriority, lowPriority);
    }

    @Test
    public void testHighestPriorityTierSelectorStrategy() {
        DirectDruidClient client = (DirectDruidClient)EasyMock.createMock(DirectDruidClient.class);
        QueryableDruidServer lowPriority = new QueryableDruidServer(new DruidServer("test1", "localhost", null, 0L, ServerType.HISTORICAL, "_default_tier", 0), (QueryRunner)client);
        QueryableDruidServer highPriority = new QueryableDruidServer(new DruidServer("test1", "localhost", null, 0L, ServerType.HISTORICAL, "_default_tier", 1), (QueryRunner)client);
        this.testTierSelectorStrategy((TierSelectorStrategy)new HighestPriorityTierSelectorStrategy((ServerSelectorStrategy)new ConnectionCountServerSelectorStrategy()), highPriority, lowPriority);
    }

    @Test
    public void testLowestPriorityTierSelectorStrategy() {
        DirectDruidClient client = (DirectDruidClient)EasyMock.createMock(DirectDruidClient.class);
        QueryableDruidServer lowPriority = new QueryableDruidServer(new DruidServer("test1", "localhost", null, 0L, ServerType.HISTORICAL, "_default_tier", 0), (QueryRunner)client);
        QueryableDruidServer highPriority = new QueryableDruidServer(new DruidServer("test1", "localhost", null, 0L, ServerType.HISTORICAL, "_default_tier", 1), (QueryRunner)client);
        this.testTierSelectorStrategy((TierSelectorStrategy)new LowestPriorityTierSelectorStrategy((ServerSelectorStrategy)new ConnectionCountServerSelectorStrategy()), lowPriority, highPriority);
    }

    @Test
    public void testCustomPriorityTierSelectorStrategy() {
        DirectDruidClient client = (DirectDruidClient)EasyMock.createMock(DirectDruidClient.class);
        QueryableDruidServer lowPriority = new QueryableDruidServer(new DruidServer("test1", "localhost", null, 0L, ServerType.HISTORICAL, "_default_tier", -1), (QueryRunner)client);
        QueryableDruidServer mediumPriority = new QueryableDruidServer(new DruidServer("test1", "localhost", null, 0L, ServerType.HISTORICAL, "_default_tier", 0), (QueryRunner)client);
        QueryableDruidServer highPriority = new QueryableDruidServer(new DruidServer("test1", "localhost", null, 0L, ServerType.HISTORICAL, "_default_tier", 1), (QueryRunner)client);
        this.testTierSelectorStrategy((TierSelectorStrategy)new CustomTierSelectorStrategy((ServerSelectorStrategy)new ConnectionCountServerSelectorStrategy(), new CustomTierSelectorStrategyConfig(){

            public List<Integer> getPriorities() {
                return Arrays.asList(2, 0, -1, 1);
            }
        }), mediumPriority, lowPriority, highPriority);
    }

    @Test
    public void testEmptyCustomPriorityTierSelectorStrategy() {
        DirectDruidClient client = (DirectDruidClient)EasyMock.createMock(DirectDruidClient.class);
        QueryableDruidServer lowPriority = new QueryableDruidServer(new DruidServer("test1", "localhost", null, 0L, ServerType.HISTORICAL, "_default_tier", -1), (QueryRunner)client);
        QueryableDruidServer mediumPriority = new QueryableDruidServer(new DruidServer("test1", "localhost", null, 0L, ServerType.HISTORICAL, "_default_tier", 0), (QueryRunner)client);
        QueryableDruidServer highPriority = new QueryableDruidServer(new DruidServer("test1", "localhost", null, 0L, ServerType.HISTORICAL, "_default_tier", 1), (QueryRunner)client);
        this.testTierSelectorStrategy((TierSelectorStrategy)new CustomTierSelectorStrategy((ServerSelectorStrategy)new ConnectionCountServerSelectorStrategy(), new CustomTierSelectorStrategyConfig(){

            public List<Integer> getPriorities() {
                return new ArrayList<Integer>();
            }
        }), highPriority, mediumPriority, lowPriority);
    }

    @Test
    public void testIncompleteCustomPriorityTierSelectorStrategy() {
        DirectDruidClient client = (DirectDruidClient)EasyMock.createMock(DirectDruidClient.class);
        QueryableDruidServer p0 = new QueryableDruidServer(new DruidServer("test1", "localhost", null, 0L, ServerType.HISTORICAL, "_default_tier", -1), (QueryRunner)client);
        QueryableDruidServer p1 = new QueryableDruidServer(new DruidServer("test1", "localhost", null, 0L, ServerType.HISTORICAL, "_default_tier", 0), (QueryRunner)client);
        QueryableDruidServer p2 = new QueryableDruidServer(new DruidServer("test1", "localhost", null, 0L, ServerType.HISTORICAL, "_default_tier", 1), (QueryRunner)client);
        QueryableDruidServer p3 = new QueryableDruidServer(new DruidServer("test1", "localhost", null, 0L, ServerType.HISTORICAL, "_default_tier", 2), (QueryRunner)client);
        QueryableDruidServer p4 = new QueryableDruidServer(new DruidServer("test1", "localhost", null, 0L, ServerType.HISTORICAL, "_default_tier", 3), (QueryRunner)client);
        CustomTierSelectorStrategy tierSelectorStrategy = new CustomTierSelectorStrategy((ServerSelectorStrategy)new ConnectionCountServerSelectorStrategy(), new CustomTierSelectorStrategyConfig(){

            public List<Integer> getPriorities() {
                return Arrays.asList(2, 0, -1);
            }
        });
        this.testTierSelectorStrategy((TierSelectorStrategy)tierSelectorStrategy, p3, p1, p0, p4, p2);
    }

    private void testTierSelectorStrategy(TierSelectorStrategy tierSelectorStrategy, QueryableDruidServer ... expectedSelection) {
        ServerSelector serverSelector = new ServerSelector(new DataSegment("test", Intervals.of((String)"2013-01-01/2013-01-02"), DateTimes.of((String)"2013-01-01").toString(), new HashMap(), new ArrayList(), new ArrayList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(0), 0L), tierSelectorStrategy, HistoricalFilter.IDENTITY_FILTER);
        ArrayList<QueryableDruidServer> servers = new ArrayList<QueryableDruidServer>(Arrays.asList(expectedSelection));
        ArrayList<DruidServerMetadata> expectedCandidates = new ArrayList<DruidServerMetadata>();
        for (QueryableDruidServer server : servers) {
            expectedCandidates.add(server.getServer().getMetadata());
        }
        Collections.shuffle(servers);
        for (QueryableDruidServer server : servers) {
            serverSelector.addServerAndUpdateSegment(server, serverSelector.getSegment());
        }
        Assert.assertEquals((Object)expectedSelection[0], (Object)serverSelector.pick(null, CloneQueryMode.EXCLUDECLONES));
        Assert.assertEquals((Object)expectedSelection[0], (Object)serverSelector.pick((Query)EasyMock.createMock(Query.class), CloneQueryMode.EXCLUDECLONES));
        Assert.assertEquals(expectedCandidates, (Object)serverSelector.getCandidates(-1, CloneQueryMode.EXCLUDECLONES));
        Assert.assertEquals(expectedCandidates.subList(0, 2), (Object)serverSelector.getCandidates(2, CloneQueryMode.EXCLUDECLONES));
    }

    @Test
    public void testServerSelectorStrategyDefaults() {
        DirectDruidClient client = (DirectDruidClient)EasyMock.createMock(DirectDruidClient.class);
        QueryableDruidServer p0 = new QueryableDruidServer(new DruidServer("test1", "localhost", null, 0L, ServerType.HISTORICAL, "_default_tier", -1), (QueryRunner)client);
        HashSet<QueryableDruidServer> servers = new HashSet<QueryableDruidServer>();
        servers.add(p0);
        final RandomServerSelectorStrategy strategy = new RandomServerSelectorStrategy();
        Assert.assertEquals((Object)strategy.pick(servers, (DataSegment)EasyMock.createMock(DataSegment.class)), (Object)p0);
        Assert.assertEquals((Object)strategy.pick((Query)EasyMock.createMock(Query.class), servers, (DataSegment)EasyMock.createMock(DataSegment.class)), (Object)p0);
        ServerSelectorStrategy defaultDeprecatedServerSelectorStrategy = new ServerSelectorStrategy(){

            public <T> List<QueryableDruidServer> pick(@Nullable Query<T> query, Set<QueryableDruidServer> servers, DataSegment segment, int numServersToPick) {
                return strategy.pick(servers, segment, numServersToPick);
            }
        };
        Assert.assertEquals((Object)defaultDeprecatedServerSelectorStrategy.pick(servers, (DataSegment)EasyMock.createMock(DataSegment.class)), (Object)p0);
        Assert.assertEquals(defaultDeprecatedServerSelectorStrategy.pick(servers, (DataSegment)EasyMock.createMock(DataSegment.class), 1).get(0), (Object)p0);
    }

    private void testPreferredTierSelectorStrategy(PreferredTierSelectorStrategy tierSelectorStrategy, QueryableDruidServer ... expectedSelection) {
        ServerSelector serverSelector = new ServerSelector(new DataSegment("test", Intervals.of((String)"2013-01-01/2013-01-02"), DateTimes.of((String)"2013-01-01").toString(), new HashMap(), new ArrayList(), new ArrayList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(0), 0L), (TierSelectorStrategy)tierSelectorStrategy, HistoricalFilter.IDENTITY_FILTER);
        ArrayList<QueryableDruidServer> servers = new ArrayList<QueryableDruidServer>(Arrays.asList(expectedSelection));
        ArrayList<DruidServerMetadata> expectedCandidates = new ArrayList<DruidServerMetadata>();
        for (QueryableDruidServer server : servers) {
            expectedCandidates.add(server.getServer().getMetadata());
        }
        for (QueryableDruidServer server : servers) {
            serverSelector.addServerAndUpdateSegment(server, serverSelector.getSegment());
        }
        Assert.assertEquals((Object)expectedSelection[0], (Object)serverSelector.pick(null, CloneQueryMode.EXCLUDECLONES));
        Assert.assertEquals((Object)expectedSelection[0], (Object)serverSelector.pick((Query)EasyMock.createMock(Query.class), CloneQueryMode.EXCLUDECLONES));
        ArrayList allServers = new ArrayList(expectedCandidates);
        allServers.sort((o1, o2) -> tierSelectorStrategy.getComparator().compare(o1.getPriority(), o2.getPriority()));
        Assert.assertEquals(allServers.stream().map(DruidServerMetadata::getPriority).collect(Collectors.toList()), serverSelector.getCandidates(-1, CloneQueryMode.EXCLUDECLONES).stream().map(DruidServerMetadata::getPriority).collect(Collectors.toList()));
        Assert.assertEquals(expectedCandidates.subList(0, 2), (Object)serverSelector.getCandidates(2, CloneQueryMode.EXCLUDECLONES));
    }

    @Test
    public void testPreferredTierSelectorStrategyHighestPriority() {
        DirectDruidClient client = (DirectDruidClient)EasyMock.createMock(DirectDruidClient.class);
        QueryableDruidServer preferredTierLowPriority = new QueryableDruidServer(new DruidServer("test1", "localhost", null, 0L, ServerType.HISTORICAL, "preferred", 0), (QueryRunner)client);
        QueryableDruidServer preferredTierHighPriority = new QueryableDruidServer(new DruidServer("test2", "localhost", null, 0L, ServerType.HISTORICAL, "preferred", 1), (QueryRunner)client);
        QueryableDruidServer preferredTierHighPriority2 = new QueryableDruidServer(new DruidServer("test3", "localhost", null, 0L, ServerType.HISTORICAL, "preferred", 1), (QueryRunner)client);
        QueryableDruidServer nonPreferredTierHighestPriority = new QueryableDruidServer(new DruidServer("test4", "localhost", null, 0L, ServerType.HISTORICAL, "non-preferred", 2), (QueryRunner)client);
        PreferredTierSelectorStrategy tierSelectorStrategy = new PreferredTierSelectorStrategy(new ServerSelectorStrategy(){

            public List<QueryableDruidServer> pick(Set<QueryableDruidServer> servers, DataSegment segment, int numServersToPick) {
                if (servers.size() <= numServersToPick) {
                    return ImmutableList.copyOf(servers);
                }
                ArrayList<QueryableDruidServer> list = new ArrayList<QueryableDruidServer>(servers);
                if (numServersToPick == 1) {
                    return list.stream().sorted((o1, o2) -> o1.getServer().getName().compareTo(o2.getServer().getName())).skip(1L).limit(1L).collect(Collectors.toList());
                }
                return list.stream().limit(numServersToPick).collect(Collectors.toList());
            }
        }, new PreferredTierSelectorStrategyConfig("preferred", "highest"));
        ServerSelector serverSelector = new ServerSelector(new DataSegment("test", Intervals.of((String)"2013-01-01/2013-01-02"), DateTimes.of((String)"2013-01-01").toString(), new HashMap(), new ArrayList(), new ArrayList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(0), 0L), (TierSelectorStrategy)tierSelectorStrategy, HistoricalFilter.IDENTITY_FILTER);
        ArrayList<QueryableDruidServer> servers = new ArrayList<QueryableDruidServer>(Arrays.asList(preferredTierLowPriority, preferredTierHighPriority, preferredTierHighPriority2, nonPreferredTierHighestPriority));
        ArrayList<DruidServerMetadata> expectedCandidates = new ArrayList<DruidServerMetadata>();
        for (QueryableDruidServer server : servers) {
            expectedCandidates.add(server.getServer().getMetadata());
        }
        for (QueryableDruidServer server : servers) {
            serverSelector.addServerAndUpdateSegment(server, serverSelector.getSegment());
        }
        Assert.assertEquals((Object)preferredTierHighPriority2, (Object)serverSelector.pick(null, CloneQueryMode.EXCLUDECLONES));
        Assert.assertEquals((Object)preferredTierHighPriority2, (Object)serverSelector.pick((Query)EasyMock.createMock(Query.class), CloneQueryMode.EXCLUDECLONES));
        ArrayList allServers = new ArrayList(expectedCandidates);
        allServers.sort((o1, o2) -> tierSelectorStrategy.getComparator().compare(o1.getPriority(), o2.getPriority()));
        Assert.assertEquals(allServers.stream().map(DruidServerMetadata::getPriority).collect(Collectors.toList()), serverSelector.getCandidates(-1, CloneQueryMode.EXCLUDECLONES).stream().map(DruidServerMetadata::getPriority).collect(Collectors.toList()));
        Assert.assertEquals(Arrays.asList(preferredTierHighPriority.getServer().getMetadata(), preferredTierHighPriority2.getServer().getMetadata()), serverSelector.getCandidates(2, CloneQueryMode.EXCLUDECLONES).stream().sorted((o1, o2) -> o1.getName().compareTo(o2.getName())).collect(Collectors.toList()));
    }

    @Test
    public void testPreferredTierSelectorStrategyLowestPriority() {
        DirectDruidClient client = (DirectDruidClient)EasyMock.createMock(DirectDruidClient.class);
        QueryableDruidServer preferredTierLowPriority = new QueryableDruidServer(new DruidServer("test1", "localhost", null, 0L, ServerType.HISTORICAL, "preferred", 0), (QueryRunner)client);
        QueryableDruidServer preferredTierHighPriority = new QueryableDruidServer(new DruidServer("test2", "localhost", null, 0L, ServerType.HISTORICAL, "preferred", 1), (QueryRunner)client);
        QueryableDruidServer nonPreferredTierLowestPriority = new QueryableDruidServer(new DruidServer("test3", "localhost", null, 0L, ServerType.HISTORICAL, "non-preferred", -1), (QueryRunner)client);
        this.testPreferredTierSelectorStrategy(new PreferredTierSelectorStrategy((ServerSelectorStrategy)new ConnectionCountServerSelectorStrategy(), new PreferredTierSelectorStrategyConfig("preferred", "lowest")), preferredTierLowPriority, preferredTierHighPriority, nonPreferredTierLowestPriority);
    }

    @Test
    public void testPreferredTierSelectorStrategyWithFallback() {
        DirectDruidClient client = (DirectDruidClient)EasyMock.createMock(DirectDruidClient.class);
        QueryableDruidServer nonPreferredTierLowPriority = new QueryableDruidServer(new DruidServer("test1", "localhost", null, 0L, ServerType.HISTORICAL, "non-preferred", 0), (QueryRunner)client);
        QueryableDruidServer nonPreferredTierMediumPriority = new QueryableDruidServer(new DruidServer("test2", "localhost", null, 0L, ServerType.HISTORICAL, "non-preferred", 1), (QueryRunner)client);
        QueryableDruidServer nonPreferredTierHighPriority = new QueryableDruidServer(new DruidServer("test3", "localhost", null, 0L, ServerType.HISTORICAL, "non-preferred", 2), (QueryRunner)client);
        this.testPreferredTierSelectorStrategy(new PreferredTierSelectorStrategy((ServerSelectorStrategy)new ConnectionCountServerSelectorStrategy(), new PreferredTierSelectorStrategyConfig("preferred", "highest")), nonPreferredTierHighPriority, nonPreferredTierMediumPriority, nonPreferredTierLowPriority);
    }

    @Test
    public void testPreferredTierSelectorStrategyMixedServers() {
        DirectDruidClient client = (DirectDruidClient)EasyMock.createMock(DirectDruidClient.class);
        QueryableDruidServer preferredTierLowPriority = new QueryableDruidServer(new DruidServer("test1", "localhost", null, 0L, ServerType.HISTORICAL, "preferred", 0), (QueryRunner)client);
        QueryableDruidServer preferredTierHighPriority = new QueryableDruidServer(new DruidServer("test2", "localhost", null, 0L, ServerType.HISTORICAL, "preferred", 1), (QueryRunner)client);
        QueryableDruidServer anotherTierHighPriority = new QueryableDruidServer(new DruidServer("test3", "localhost", null, 0L, ServerType.HISTORICAL, "tier1", 3), (QueryRunner)client);
        QueryableDruidServer yetAnotherTierMediumPriority = new QueryableDruidServer(new DruidServer("test4", "localhost", null, 0L, ServerType.HISTORICAL, "tier2", 2), (QueryRunner)client);
        this.testPreferredTierSelectorStrategy(new PreferredTierSelectorStrategy((ServerSelectorStrategy)new ConnectionCountServerSelectorStrategy(), new PreferredTierSelectorStrategyConfig("preferred", "highest")), preferredTierHighPriority, preferredTierLowPriority, anotherTierHighPriority, yetAnotherTierMediumPriority);
    }

    @Test
    public void testPreferredTierSelectorStrategyDefaultPriority() {
        DirectDruidClient client = (DirectDruidClient)EasyMock.createMock(DirectDruidClient.class);
        QueryableDruidServer preferredTierLowPriority = new QueryableDruidServer(new DruidServer("test1", "localhost", null, 0L, ServerType.HISTORICAL, "preferred", 0), (QueryRunner)client);
        QueryableDruidServer preferredTierHighPriority = new QueryableDruidServer(new DruidServer("test2", "localhost", null, 0L, ServerType.HISTORICAL, "preferred", 1), (QueryRunner)client);
        QueryableDruidServer nonPreferredTierHighestPriority = new QueryableDruidServer(new DruidServer("test3", "localhost", null, 0L, ServerType.HISTORICAL, "non-preferred", 2), (QueryRunner)client);
        this.testPreferredTierSelectorStrategy(new PreferredTierSelectorStrategy((ServerSelectorStrategy)new ConnectionCountServerSelectorStrategy(), new PreferredTierSelectorStrategyConfig("preferred", null)), preferredTierHighPriority, preferredTierLowPriority, nonPreferredTierHighestPriority);
    }
}

