/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client.indexing;

import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.client.indexing.ClientKillUnusedSegmentsTaskQuery;
import org.apache.druid.java.util.common.DateTimes;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ClientKillUnusedSegmentsTaskQueryTest {
    private static final String DATA_SOURCE = "data_source";
    public static final DateTime START = DateTimes.nowUtc();
    private static final Interval INTERVAL = new Interval((ReadableInstant)START, (ReadableInstant)START.plus(1L));
    private static final Integer BATCH_SIZE = 999;
    private static final Integer LIMIT = 1000;
    ClientKillUnusedSegmentsTaskQuery clientKillUnusedSegmentsQuery;

    @Before
    public void setUp() {
        this.clientKillUnusedSegmentsQuery = new ClientKillUnusedSegmentsTaskQuery("killTaskId", DATA_SOURCE, INTERVAL, null, BATCH_SIZE, LIMIT, null);
    }

    @After
    public void tearDown() {
        this.clientKillUnusedSegmentsQuery = null;
    }

    @Test
    public void testGetType() {
        Assert.assertEquals((Object)"kill", (Object)this.clientKillUnusedSegmentsQuery.getType());
    }

    @Test
    public void testGetDataSource() {
        Assert.assertEquals((Object)DATA_SOURCE, (Object)this.clientKillUnusedSegmentsQuery.getDataSource());
    }

    @Test
    public void testGetInterval() {
        Assert.assertEquals((Object)INTERVAL, (Object)this.clientKillUnusedSegmentsQuery.getInterval());
    }

    @Test
    public void testGetBatchSize() {
        Assert.assertEquals((Object)BATCH_SIZE, (Object)this.clientKillUnusedSegmentsQuery.getBatchSize());
    }

    @Test
    public void testGetLimit() {
        Assert.assertEquals((Object)LIMIT, (Object)this.clientKillUnusedSegmentsQuery.getLimit());
    }

    @Test
    public void testEquals() {
        EqualsVerifier.forClass(ClientKillUnusedSegmentsTaskQuery.class).usingGetClass().withNonnullFields(new String[]{"id", "dataSource", "interval", "batchSize", "limit"}).verify();
    }
}

