/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client.indexing;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.client.indexing.ClientCompactionRunnerInfo;
import org.apache.druid.data.input.SegmentsSplitHintSpec;
import org.apache.druid.data.input.SplitHintSpec;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.data.input.impl.LongDimensionSchema;
import org.apache.druid.indexer.CompactionEngine;
import org.apache.druid.indexer.partitions.DimensionRangePartitionsSpec;
import org.apache.druid.indexer.partitions.DynamicPartitionsSpec;
import org.apache.druid.indexer.partitions.HashedPartitionsSpec;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.java.util.common.HumanReadableBytes;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.data.CompressionFactory;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.druid.segment.writeout.TmpFileSegmentWriteOutMediumFactory;
import org.apache.druid.server.coordinator.CompactionConfigValidationResult;
import org.apache.druid.server.coordinator.DataSourceCompactionConfig;
import org.apache.druid.server.coordinator.InlineSchemaDataSourceCompactionConfig;
import org.apache.druid.server.coordinator.UserCompactionTaskDimensionsConfig;
import org.apache.druid.server.coordinator.UserCompactionTaskGranularityConfig;
import org.apache.druid.server.coordinator.UserCompactionTaskQueryTuningConfig;
import org.joda.time.Duration;
import org.joda.time.Period;
import org.junit.Assert;
import org.junit.Test;

public class ClientCompactionRunnerInfoTest {
    @Test
    public void testMSQEngineWithHashedPartitionsSpecIsInvalid() {
        DataSourceCompactionConfig compactionConfig = ClientCompactionRunnerInfoTest.createMSQCompactionConfig((PartitionsSpec)new HashedPartitionsSpec(Integer.valueOf(100), null, null), Collections.emptyMap(), null, null, null);
        CompactionConfigValidationResult validationResult = ClientCompactionRunnerInfo.validateCompactionConfig((DataSourceCompactionConfig)compactionConfig, (CompactionEngine)CompactionEngine.NATIVE);
        Assert.assertFalse((boolean)validationResult.isValid());
        Assert.assertEquals((Object)"MSQ: Invalid partitioning type[HashedPartitionsSpec]. Must be either 'dynamic' or 'range'", (Object)validationResult.getReason());
    }

    @Test
    public void testMSQEngineWithMaxTotalRowsIsInvalid() {
        DataSourceCompactionConfig compactionConfig = ClientCompactionRunnerInfoTest.createMSQCompactionConfig((PartitionsSpec)new DynamicPartitionsSpec(Integer.valueOf(100), Long.valueOf(100L)), Collections.emptyMap(), null, null, null);
        CompactionConfigValidationResult validationResult = ClientCompactionRunnerInfo.validateCompactionConfig((DataSourceCompactionConfig)compactionConfig, (CompactionEngine)CompactionEngine.NATIVE);
        Assert.assertFalse((boolean)validationResult.isValid());
        Assert.assertEquals((Object)"MSQ: 'maxTotalRows' not supported with 'dynamic' partitioning", (Object)validationResult.getReason());
    }

    @Test
    public void testMSQEngineWithNullPartitionsSpecIsInvalid() {
        DataSourceCompactionConfig compactionConfig = ClientCompactionRunnerInfoTest.createMSQCompactionConfig(null, Collections.emptyMap(), null, null, null);
        CompactionConfigValidationResult validationResult = ClientCompactionRunnerInfo.validateCompactionConfig((DataSourceCompactionConfig)compactionConfig, (CompactionEngine)CompactionEngine.NATIVE);
        Assert.assertFalse((boolean)validationResult.isValid());
        Assert.assertEquals((Object)"MSQ: tuningConfig.partitionsSpec must be specified", (Object)validationResult.getReason());
    }

    @Test
    public void testMSQEngineWithDynamicPartitionsSpecIsValid() {
        DataSourceCompactionConfig compactionConfig = ClientCompactionRunnerInfoTest.createMSQCompactionConfig((PartitionsSpec)new DynamicPartitionsSpec(Integer.valueOf(100), null), Collections.emptyMap(), null, null, null);
        Assert.assertTrue((boolean)ClientCompactionRunnerInfo.validateCompactionConfig((DataSourceCompactionConfig)compactionConfig, (CompactionEngine)CompactionEngine.NATIVE).isValid());
    }

    @Test
    public void testMSQEngineWithStringDimensionsInRangePartitionsSpecIsValid() {
        DataSourceCompactionConfig compactionConfig = ClientCompactionRunnerInfoTest.createMSQCompactionConfig((PartitionsSpec)new DimensionRangePartitionsSpec(Integer.valueOf(100), null, (List)ImmutableList.of((Object)"partitionDim"), false), Collections.emptyMap(), null, null, null);
        Assert.assertTrue((boolean)ClientCompactionRunnerInfo.validateCompactionConfig((DataSourceCompactionConfig)compactionConfig, (CompactionEngine)CompactionEngine.NATIVE).isValid());
    }

    @Test
    public void testMSQEngineWithLongDimensionsInRangePartitionsSpecIsInvalid() {
        DataSourceCompactionConfig compactionConfig = ClientCompactionRunnerInfoTest.createMSQCompactionConfig((PartitionsSpec)new DimensionRangePartitionsSpec(Integer.valueOf(100), null, (List)ImmutableList.of((Object)"partitionDim"), false), Collections.emptyMap(), null, null, (List<DimensionSchema>)ImmutableList.of((Object)new LongDimensionSchema("partitionDim")));
        CompactionConfigValidationResult validationResult = ClientCompactionRunnerInfo.validateCompactionConfig((DataSourceCompactionConfig)compactionConfig, (CompactionEngine)CompactionEngine.NATIVE);
        Assert.assertFalse((boolean)validationResult.isValid());
        Assert.assertEquals((Object)"MSQ: Non-string partition dimension[partitionDim] of type[long] not supported with 'range' partition spec", (Object)validationResult.getReason());
    }

    @Test
    public void testMSQEngineWithQueryGranularityAllIsValid() {
        DataSourceCompactionConfig compactionConfig = ClientCompactionRunnerInfoTest.createMSQCompactionConfig((PartitionsSpec)new DynamicPartitionsSpec(Integer.valueOf(3), null), Collections.emptyMap(), new UserCompactionTaskGranularityConfig(Granularities.ALL, Granularities.ALL, Boolean.valueOf(false)), null, null);
        Assert.assertTrue((boolean)ClientCompactionRunnerInfo.validateCompactionConfig((DataSourceCompactionConfig)compactionConfig, (CompactionEngine)CompactionEngine.NATIVE).isValid());
    }

    @Test
    public void testMSQEngineWithRollupFalseWithMetricsSpecIsInvalid() {
        DataSourceCompactionConfig compactionConfig = ClientCompactionRunnerInfoTest.createMSQCompactionConfig((PartitionsSpec)new DynamicPartitionsSpec(Integer.valueOf(3), null), Collections.emptyMap(), new UserCompactionTaskGranularityConfig(null, null, Boolean.valueOf(false)), new AggregatorFactory[]{new LongSumAggregatorFactory("sum", "sum")}, null);
        CompactionConfigValidationResult validationResult = ClientCompactionRunnerInfo.validateCompactionConfig((DataSourceCompactionConfig)compactionConfig, (CompactionEngine)CompactionEngine.NATIVE);
        Assert.assertFalse((boolean)validationResult.isValid());
        Assert.assertEquals((Object)"MSQ: 'granularitySpec.rollup' must be true if and only if 'metricsSpec' is specified", (Object)validationResult.getReason());
    }

    @Test
    public void testMSQEngineWithRollupTrueWithoutMetricsSpecIsInvalid() {
        DataSourceCompactionConfig compactionConfig = ClientCompactionRunnerInfoTest.createMSQCompactionConfig((PartitionsSpec)new DynamicPartitionsSpec(Integer.valueOf(3), null), Collections.emptyMap(), new UserCompactionTaskGranularityConfig(null, null, Boolean.valueOf(true)), null, null);
        CompactionConfigValidationResult validationResult = ClientCompactionRunnerInfo.validateCompactionConfig((DataSourceCompactionConfig)compactionConfig, (CompactionEngine)CompactionEngine.NATIVE);
        Assert.assertFalse((boolean)validationResult.isValid());
        Assert.assertEquals((Object)"MSQ: 'granularitySpec.rollup' must be true if and only if 'metricsSpec' is specified", (Object)validationResult.getReason());
    }

    @Test
    public void testMSQEngineWithUnsupportedMetricsSpecIsInvalid() {
        String inputColName = "added";
        String outputColName = "sum_added";
        DataSourceCompactionConfig compactionConfig = ClientCompactionRunnerInfoTest.createMSQCompactionConfig((PartitionsSpec)new DynamicPartitionsSpec(Integer.valueOf(3), null), Collections.emptyMap(), new UserCompactionTaskGranularityConfig(null, null, Boolean.valueOf(true)), new AggregatorFactory[]{new LongSumAggregatorFactory("sum_added", "added")}, null);
        CompactionConfigValidationResult validationResult = ClientCompactionRunnerInfo.validateCompactionConfig((DataSourceCompactionConfig)compactionConfig, (CompactionEngine)CompactionEngine.NATIVE);
        Assert.assertFalse((boolean)validationResult.isValid());
        Assert.assertEquals((Object)"MSQ: Aggregator[sum_added] not supported in 'metricsSpec'", (Object)validationResult.getReason());
    }

    @Test
    public void testMSQEngineWithRollupNullWithMetricsSpecIsInvalid() {
        DataSourceCompactionConfig compactionConfig = ClientCompactionRunnerInfoTest.createMSQCompactionConfig((PartitionsSpec)new DynamicPartitionsSpec(Integer.valueOf(3), null), Collections.emptyMap(), new UserCompactionTaskGranularityConfig(null, null, null), new AggregatorFactory[]{new LongSumAggregatorFactory("sum", "sum")}, null);
        CompactionConfigValidationResult validationResult = ClientCompactionRunnerInfo.validateCompactionConfig((DataSourceCompactionConfig)compactionConfig, (CompactionEngine)CompactionEngine.NATIVE);
        Assert.assertFalse((boolean)validationResult.isValid());
        Assert.assertEquals((Object)"MSQ: 'granularitySpec.rollup' must be true if and only if 'metricsSpec' is specified", (Object)validationResult.getReason());
    }

    private static DataSourceCompactionConfig createMSQCompactionConfig(PartitionsSpec partitionsSpec, Map<String, Object> context, @Nullable UserCompactionTaskGranularityConfig granularitySpec, @Nullable AggregatorFactory[] metricsSpec, List<DimensionSchema> dimensions) {
        return InlineSchemaDataSourceCompactionConfig.builder().forDataSource("dataSource").withInputSegmentSizeBytes(Long.valueOf(500L)).withMaxRowsPerSegment(Integer.valueOf(10000)).withSkipOffsetFromLatest(new Period(3600L)).withTuningConfig(ClientCompactionRunnerInfoTest.createTuningConfig(partitionsSpec)).withGranularitySpec(granularitySpec).withDimensionsSpec(new UserCompactionTaskDimensionsConfig(dimensions)).withMetricsSpec(metricsSpec).withEngine(CompactionEngine.MSQ).withTaskContext(context).build();
    }

    private static UserCompactionTaskQueryTuningConfig createTuningConfig(PartitionsSpec partitionsSpec) {
        return new UserCompactionTaskQueryTuningConfig(Integer.valueOf(40000), null, Long.valueOf(2000L), null, (SplitHintSpec)new SegmentsSplitHintSpec(new HumanReadableBytes(100000L), null), partitionsSpec, IndexSpec.builder().withDimensionCompression(CompressionStrategy.LZ4).withMetricCompression(CompressionStrategy.LZF).withLongEncoding(CompressionFactory.LongEncodingStrategy.LONGS).build(), IndexSpec.builder().withDimensionCompression(CompressionStrategy.LZ4).withMetricCompression(CompressionStrategy.UNCOMPRESSED).withLongEncoding(CompressionFactory.LongEncodingStrategy.AUTO).build(), Integer.valueOf(2), Long.valueOf(1000L), (SegmentWriteOutMediumFactory)TmpFileSegmentWriteOutMediumFactory.instance(), Integer.valueOf(100), Integer.valueOf(5), Long.valueOf(1000L), new Duration(3000L), Integer.valueOf(7), Integer.valueOf(1000), Integer.valueOf(100), Integer.valueOf(2));
    }
}

