/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client;

import com.fasterxml.jackson.core.io.JsonEOFException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import java.util.HashMap;
import org.apache.druid.client.InternalQueryConfig;
import org.apache.druid.guice.ConfigModule;
import org.apache.druid.guice.DruidGuiceExtensions;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.segment.TestHelper;
import org.junit.Assert;
import org.junit.Test;

public class InternalQueryConfigTest {
    private static final ObjectMapper MAPPER = TestHelper.makeJsonMapper();

    @Test
    public void testSerde() throws Exception {
        String json = "{}";
        InternalQueryConfig config = (InternalQueryConfig)MAPPER.readValue(MAPPER.writeValueAsString(MAPPER.readValue(json, InternalQueryConfig.class)), InternalQueryConfig.class);
        Assert.assertEquals((Object)ImmutableMap.of(), (Object)config.getContext());
        json = "{ \"context\": {\"priority\": 5}}";
        config = (InternalQueryConfig)MAPPER.readValue(MAPPER.writeValueAsString(MAPPER.readValue(json, InternalQueryConfig.class)), InternalQueryConfig.class);
        HashMap<String, Integer> expected = new HashMap<String, Integer>();
        expected.put("priority", 5);
        Assert.assertEquals(expected, (Object)config.getContext());
    }

    @Test(expected=JsonEOFException.class)
    public void testMalfomattedContext() throws Exception {
        String malformedJson = "{\"priority: 5}";
        MAPPER.readValue(MAPPER.writeValueAsString(MAPPER.readValue(malformedJson, InternalQueryConfig.class)), InternalQueryConfig.class);
    }

    @Test
    public void testDefaultBehavior() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new Module(){

            public void configure(Binder binder) {
                binder.install((Module)new ConfigModule());
                binder.install((Module)new DruidGuiceExtensions());
                JsonConfigProvider.bind((Binder)binder, (String)"druid.broker.internal.query.config", InternalQueryConfig.class);
            }

            @Provides
            @LazySingleton
            public ObjectMapper jsonMapper() {
                return new DefaultObjectMapper();
            }
        }});
        InternalQueryConfig config = (InternalQueryConfig)injector.getInstance(InternalQueryConfig.class);
        Assert.assertEquals((Object)ImmutableMap.of(), (Object)config.getContext());
    }
}

