/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.catalog;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.catalog.MetadataCatalog;
import org.apache.druid.catalog.model.ResolvedTable;
import org.apache.druid.catalog.model.TableDefnRegistry;
import org.apache.druid.catalog.model.TableId;
import org.apache.druid.catalog.model.TableMetadata;
import org.apache.druid.catalog.model.TableSpec;

public class MapMetadataCatalog
implements MetadataCatalog {
    private final TableDefnRegistry registry;
    private final Map<TableId, TableMetadata> metadata = new HashMap<TableId, TableMetadata>();

    public MapMetadataCatalog(ObjectMapper mapper) {
        this.registry = new TableDefnRegistry(mapper);
    }

    public void addSpec(TableId id, TableSpec spec) {
        this.metadata.put(id, TableMetadata.newTable((TableId)id, (TableSpec)spec));
    }

    @Nullable
    public TableMetadata getTable(TableId tableId) {
        return this.metadata.get(tableId);
    }

    @Nullable
    public ResolvedTable resolveTable(TableId tableId) {
        TableMetadata tableMetadata = this.metadata.get(tableId);
        if (tableMetadata == null) {
            return null;
        }
        return this.registry.resolve(tableMetadata.spec());
    }

    public List<TableMetadata> tables(String schemaName) {
        return ImmutableList.copyOf(this.metadata.values());
    }

    public Set<String> tableNames(String schemaName) {
        return this.metadata.keySet().stream().filter(x -> x.schema().equals(schemaName)).map(TableId::name).collect(Collectors.toSet());
    }
}

