/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.worker.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.io.ByteSource;
import com.google.inject.Inject;
import com.sun.jersey.spi.container.ResourceFilters;
import java.io.IOException;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.druid.indexing.overlord.TaskRunner;
import org.apache.druid.indexing.overlord.TaskRunnerWorkItem;
import org.apache.druid.indexing.worker.Worker;
import org.apache.druid.indexing.worker.WorkerCuratorCoordinator;
import org.apache.druid.indexing.worker.WorkerTaskMonitor;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.server.http.security.ConfigResourceFilter;
import org.apache.druid.server.http.security.StateResourceFilter;
import org.apache.druid.tasklogs.TaskLogStreamer;

@Path(value="/druid/worker/v1")
public class WorkerResource {
    private static final Logger log = new Logger(WorkerResource.class);
    private static String DISABLED_VERSION = "";
    private final Worker enabledWorker;
    private final WorkerCuratorCoordinator curatorCoordinator;
    private final TaskRunner taskRunner;
    private final WorkerTaskMonitor workerTaskManager;

    @Inject
    public WorkerResource(Worker worker, WorkerCuratorCoordinator curatorCoordinator, TaskRunner taskRunner, WorkerTaskMonitor workerTaskManager) {
        this.enabledWorker = worker;
        this.curatorCoordinator = curatorCoordinator;
        this.taskRunner = taskRunner;
        this.workerTaskManager = workerTaskManager;
    }

    @POST
    @Path(value="/disable")
    @Produces(value={"application/json"})
    @ResourceFilters(value={ConfigResourceFilter.class})
    public Response doDisable() {
        try {
            Worker disabledWorker = new Worker(this.enabledWorker.getScheme(), this.enabledWorker.getHost(), this.enabledWorker.getIp(), this.enabledWorker.getCapacity(), DISABLED_VERSION);
            this.curatorCoordinator.updateWorkerAnnouncement(disabledWorker);
            this.workerTaskManager.workerDisabled();
            return Response.ok((Object)ImmutableMap.of((Object)disabledWorker.getHost(), (Object)"disabled")).build();
        }
        catch (Exception e) {
            return Response.serverError().build();
        }
    }

    @POST
    @Path(value="/enable")
    @Produces(value={"application/json"})
    @ResourceFilters(value={ConfigResourceFilter.class})
    public Response doEnable() {
        try {
            this.curatorCoordinator.updateWorkerAnnouncement(this.enabledWorker);
            this.workerTaskManager.workerEnabled();
            return Response.ok((Object)ImmutableMap.of((Object)this.enabledWorker.getHost(), (Object)"enabled")).build();
        }
        catch (Exception e) {
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="/enabled")
    @Produces(value={"application/json"})
    @ResourceFilters(value={StateResourceFilter.class})
    public Response isEnabled() {
        try {
            Worker theWorker = this.curatorCoordinator.getWorker();
            boolean enabled = !theWorker.getVersion().equalsIgnoreCase(DISABLED_VERSION);
            return Response.ok((Object)ImmutableMap.of((Object)theWorker.getHost(), (Object)enabled)).build();
        }
        catch (Exception e) {
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="/tasks")
    @Produces(value={"application/json"})
    @ResourceFilters(value={StateResourceFilter.class})
    public Response getTasks() {
        try {
            return Response.ok((Object)Lists.newArrayList((Iterable)Collections2.transform(this.taskRunner.getKnownTasks(), (Function)new Function<TaskRunnerWorkItem, String>(){

                public String apply(TaskRunnerWorkItem input) {
                    return input.getTaskId();
                }
            }))).build();
        }
        catch (Exception e) {
            return Response.serverError().build();
        }
    }

    @POST
    @Path(value="/task/{taskid}/shutdown")
    @Produces(value={"application/json"})
    @ResourceFilters(value={StateResourceFilter.class})
    public Response doShutdown(@PathParam(value="taskid") String taskid) {
        try {
            this.taskRunner.shutdown(taskid, "shut down request via HTTP endpoint");
        }
        catch (Exception e) {
            log.error((Throwable)e, "Failed to issue shutdown for task: %s", new Object[]{taskid});
            return Response.serverError().build();
        }
        return Response.ok((Object)ImmutableMap.of((Object)"task", (Object)taskid)).build();
    }

    @GET
    @Path(value="/task/{taskid}/log")
    @Produces(value={"text/plain; charset=UTF-8"})
    @ResourceFilters(value={StateResourceFilter.class})
    public Response doGetLog(@PathParam(value="taskid") String taskid, @QueryParam(value="offset") @DefaultValue(value="0") long offset) {
        if (!(this.taskRunner instanceof TaskLogStreamer)) {
            return Response.status((int)501).entity((Object)StringUtils.format((String)"Log streaming not supported by [%s]", (Object[])new Object[]{this.taskRunner.getClass().getCanonicalName()})).build();
        }
        try {
            Optional stream = ((TaskLogStreamer)this.taskRunner).streamTaskLog(taskid, offset);
            if (stream.isPresent()) {
                return Response.ok((Object)((ByteSource)stream.get()).openStream()).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (IOException e) {
            log.warn((Throwable)e, "Failed to read log for task: %s", new Object[]{taskid});
            return Response.serverError().build();
        }
    }
}

