/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.worker;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import org.apache.druid.client.indexing.IndexingService;
import org.apache.druid.discovery.DruidLeaderClient;
import org.apache.druid.indexer.TaskLocation;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.common.config.TaskConfig;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.TaskRunner;
import org.apache.druid.indexing.worker.TaskAnnouncement;
import org.apache.druid.indexing.worker.WorkerCuratorCoordinator;
import org.apache.druid.indexing.worker.WorkerTaskManager;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.druid.java.util.emitter.EmittingLogger;

@Deprecated
public class WorkerTaskMonitor
extends WorkerTaskManager {
    private static final EmittingLogger log = new EmittingLogger(WorkerTaskMonitor.class);
    private final ObjectMapper jsonMapper;
    private final PathChildrenCache pathChildrenCache;
    private final CuratorFramework cf;
    private final WorkerCuratorCoordinator workerCuratorCoordinator;
    private final Object lifecycleLock = new Object();
    private volatile boolean started = false;

    @Inject
    public WorkerTaskMonitor(ObjectMapper jsonMapper, TaskRunner taskRunner, TaskConfig taskConfig, CuratorFramework cf, WorkerCuratorCoordinator workerCuratorCoordinator, @IndexingService DruidLeaderClient overlordClient) {
        super(jsonMapper, taskRunner, taskConfig, overlordClient);
        this.jsonMapper = jsonMapper;
        this.pathChildrenCache = new PathChildrenCache(cf, workerCuratorCoordinator.getTaskPathForWorker(), false, true, Execs.makeThreadFactory((String)"TaskMonitorCache-%s"));
        this.cf = cf;
        this.workerCuratorCoordinator = workerCuratorCoordinator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @LifecycleStart
    public void start() throws Exception {
        super.start();
        Object object = this.lifecycleLock;
        synchronized (object) {
            Preconditions.checkState((!this.started ? 1 : 0) != 0, (Object)"already started");
            this.started = true;
            try {
                this.cleanupStaleAnnouncements();
                this.registerRunListener();
                this.pathChildrenCache.start();
                log.info("Started WorkerTaskMonitor.", new Object[0]);
                this.started = true;
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Exception e) {
                log.makeAlert((Throwable)e, "Exception starting WorkerTaskMonitor", new Object[0]).emit();
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupStaleAnnouncements() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            for (TaskAnnouncement announcement : this.workerCuratorCoordinator.getAnnouncements()) {
                if (!announcement.getTaskStatus().isRunnable()) continue;
                TaskStatus completionStatus = null;
                TaskAnnouncement completedAnnouncement = (TaskAnnouncement)this.completedTasks.get(announcement.getTaskId());
                if (completedAnnouncement != null) {
                    completionStatus = completedAnnouncement.getTaskStatus();
                } else if (!this.runningTasks.containsKey(announcement.getTaskStatus().getId())) {
                    completionStatus = TaskStatus.failure((String)announcement.getTaskStatus().getId());
                }
                if (completionStatus == null) continue;
                log.info("Cleaning up stale announcement for task [%s]. New status is [%s].", new Object[]{announcement.getTaskStatus().getId(), completionStatus.getStatusCode()});
                this.workerCuratorCoordinator.updateTaskStatusAnnouncement(TaskAnnouncement.create(announcement.getTaskStatus().getId(), announcement.getTaskType(), announcement.getTaskResource(), completionStatus, TaskLocation.unknown(), announcement.getTaskDataSource()));
            }
        }
    }

    private void registerRunListener() {
        this.pathChildrenCache.getListenable().addListener((Object)new PathChildrenCacheListener(){

            public void childEvent(CuratorFramework curatorFramework, PathChildrenCacheEvent pathChildrenCacheEvent) throws Exception {
                if (pathChildrenCacheEvent.getType().equals((Object)PathChildrenCacheEvent.Type.CHILD_ADDED)) {
                    Task task = (Task)WorkerTaskMonitor.this.jsonMapper.readValue((byte[])WorkerTaskMonitor.this.cf.getData().forPath(pathChildrenCacheEvent.getData().getPath()), Task.class);
                    WorkerTaskMonitor.this.assignTask(task);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @LifecycleStop
    public void stop() throws Exception {
        super.stop();
        Object object = this.lifecycleLock;
        synchronized (object) {
            Preconditions.checkState((boolean)this.started, (Object)"not started");
            try {
                this.started = false;
                this.pathChildrenCache.close();
                log.info("Stopped WorkerTaskMonitor.", new Object[0]);
            }
            catch (Exception e) {
                log.makeAlert((Throwable)e, "Exception stopping WorkerTaskMonitor", new Object[0]).emit();
            }
        }
    }

    @Override
    protected void taskStarted(String taskId) {
        try {
            this.workerCuratorCoordinator.removeTaskRunZnode(taskId);
        }
        catch (Exception ex) {
            log.error((Throwable)ex, "Unknown exception while deleting task[%s] znode.", new Object[]{taskId});
        }
    }

    @Override
    protected void taskAnnouncementChanged(TaskAnnouncement announcement) {
        try {
            this.workerCuratorCoordinator.updateTaskStatusAnnouncement(announcement);
        }
        catch (Exception ex) {
            log.makeAlert((Throwable)ex, "Failed to update task announcement", new Object[0]).addData("task", (Object)announcement.getTaskId()).emit();
        }
    }
}

