/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.seekablestream.supervisor;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.indexing.common.stats.RowIngestionMetersFactory;
import org.apache.druid.indexing.overlord.IndexerMetadataStorageCoordinator;
import org.apache.druid.indexing.overlord.TaskMaster;
import org.apache.druid.indexing.overlord.TaskStorage;
import org.apache.druid.indexing.overlord.supervisor.Supervisor;
import org.apache.druid.indexing.overlord.supervisor.SupervisorSpec;
import org.apache.druid.indexing.seekablestream.SeekableStreamIndexTaskClientFactory;
import org.apache.druid.indexing.seekablestream.supervisor.SeekableStreamSupervisorIOConfig;
import org.apache.druid.indexing.seekablestream.supervisor.SeekableStreamSupervisorTuningConfig;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.server.metrics.DruidMonitorSchedulerConfig;

public abstract class SeekableStreamSupervisorSpec
implements SupervisorSpec {
    protected final TaskStorage taskStorage;
    protected final TaskMaster taskMaster;
    protected final IndexerMetadataStorageCoordinator indexerMetadataStorageCoordinator;
    protected final SeekableStreamIndexTaskClientFactory indexTaskClientFactory;
    protected final ObjectMapper mapper;
    protected final RowIngestionMetersFactory rowIngestionMetersFactory;
    private final DataSchema dataSchema;
    private final SeekableStreamSupervisorTuningConfig tuningConfig;
    private final SeekableStreamSupervisorIOConfig ioConfig;
    @Nullable
    private final Map<String, Object> context;
    protected final ServiceEmitter emitter;
    protected final DruidMonitorSchedulerConfig monitorSchedulerConfig;
    private final boolean suspended;

    @JsonCreator
    public SeekableStreamSupervisorSpec(@JsonProperty(value="dataSchema") DataSchema dataSchema, @JsonProperty(value="tuningConfig") SeekableStreamSupervisorTuningConfig tuningConfig, @JsonProperty(value="ioConfig") SeekableStreamSupervisorIOConfig ioConfig, @JsonProperty(value="context") @Nullable Map<String, Object> context, @JsonProperty(value="suspended") Boolean suspended, @JacksonInject TaskStorage taskStorage, @JacksonInject TaskMaster taskMaster, @JacksonInject IndexerMetadataStorageCoordinator indexerMetadataStorageCoordinator, @JacksonInject SeekableStreamIndexTaskClientFactory indexTaskClientFactory, @JacksonInject @Json ObjectMapper mapper, @JacksonInject ServiceEmitter emitter, @JacksonInject DruidMonitorSchedulerConfig monitorSchedulerConfig, @JacksonInject RowIngestionMetersFactory rowIngestionMetersFactory) {
        this.dataSchema = (DataSchema)Preconditions.checkNotNull((Object)dataSchema, (Object)"dataSchema");
        this.tuningConfig = tuningConfig;
        this.ioConfig = (SeekableStreamSupervisorIOConfig)Preconditions.checkNotNull((Object)ioConfig, (Object)"ioConfig");
        this.context = context;
        this.taskStorage = taskStorage;
        this.taskMaster = taskMaster;
        this.indexerMetadataStorageCoordinator = indexerMetadataStorageCoordinator;
        this.indexTaskClientFactory = indexTaskClientFactory;
        this.mapper = mapper;
        this.emitter = emitter;
        this.monitorSchedulerConfig = monitorSchedulerConfig;
        this.rowIngestionMetersFactory = rowIngestionMetersFactory;
        this.suspended = suspended != null ? suspended : false;
    }

    @JsonProperty
    public DataSchema getDataSchema() {
        return this.dataSchema;
    }

    @JsonProperty
    public SeekableStreamSupervisorTuningConfig getTuningConfig() {
        return this.tuningConfig;
    }

    @JsonProperty
    public SeekableStreamSupervisorIOConfig getIoConfig() {
        return this.ioConfig;
    }

    @Nullable
    @JsonProperty
    public Map<String, Object> getContext() {
        return this.context;
    }

    public ServiceEmitter getEmitter() {
        return this.emitter;
    }

    public String getId() {
        return this.dataSchema.getDataSource();
    }

    public DruidMonitorSchedulerConfig getMonitorSchedulerConfig() {
        return this.monitorSchedulerConfig;
    }

    public abstract Supervisor createSupervisor();

    public List<String> getDataSources() {
        return ImmutableList.of((Object)this.getDataSchema().getDataSource());
    }

    public SeekableStreamSupervisorSpec createSuspendedSpec() {
        return this.toggleSuspend(true);
    }

    public SeekableStreamSupervisorSpec createRunningSpec() {
        return this.toggleSuspend(false);
    }

    @JsonProperty(value="suspended")
    public boolean isSuspended() {
        return this.suspended;
    }

    protected abstract SeekableStreamSupervisorSpec toggleSuspend(boolean var1);
}

