/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.seekablestream.supervisor;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import org.joda.time.Duration;
import org.joda.time.Period;

public abstract class SeekableStreamSupervisorIOConfig {
    private final String stream;
    private final Integer replicas;
    private final Integer taskCount;
    private final Duration taskDuration;
    private final Duration startDelay;
    private final Duration period;
    private final boolean useEarliestSequenceNumber;
    private final Duration completionTimeout;
    private final Optional<Duration> lateMessageRejectionPeriod;
    private final Optional<Duration> earlyMessageRejectionPeriod;

    public SeekableStreamSupervisorIOConfig(String stream, Integer replicas, Integer taskCount, Period taskDuration, Period startDelay, Period period, Boolean useEarliestSequenceNumber, Period completionTimeout, Period lateMessageRejectionPeriod, Period earlyMessageRejectionPeriod) {
        this.stream = (String)Preconditions.checkNotNull((Object)stream, (Object)"stream cannot be null");
        this.replicas = replicas != null ? replicas : 1;
        this.taskCount = taskCount != null ? taskCount : 1;
        this.taskDuration = SeekableStreamSupervisorIOConfig.defaultDuration(taskDuration, "PT1H");
        this.startDelay = SeekableStreamSupervisorIOConfig.defaultDuration(startDelay, "PT5S");
        this.period = SeekableStreamSupervisorIOConfig.defaultDuration(period, "PT30S");
        this.useEarliestSequenceNumber = useEarliestSequenceNumber != null ? useEarliestSequenceNumber : false;
        this.completionTimeout = SeekableStreamSupervisorIOConfig.defaultDuration(completionTimeout, "PT30M");
        this.lateMessageRejectionPeriod = lateMessageRejectionPeriod == null ? Optional.absent() : Optional.of((Object)lateMessageRejectionPeriod.toStandardDuration());
        this.earlyMessageRejectionPeriod = earlyMessageRejectionPeriod == null ? Optional.absent() : Optional.of((Object)earlyMessageRejectionPeriod.toStandardDuration());
    }

    private static Duration defaultDuration(Period period, String theDefault) {
        return (period == null ? new Period((Object)theDefault) : period).toStandardDuration();
    }

    @JsonProperty
    public String getStream() {
        return this.stream;
    }

    @JsonProperty
    public Integer getReplicas() {
        return this.replicas;
    }

    @JsonProperty
    public Integer getTaskCount() {
        return this.taskCount;
    }

    @JsonProperty
    public Duration getTaskDuration() {
        return this.taskDuration;
    }

    @JsonProperty
    public Duration getStartDelay() {
        return this.startDelay;
    }

    @JsonProperty
    public Duration getPeriod() {
        return this.period;
    }

    @JsonProperty
    public boolean isUseEarliestSequenceNumber() {
        return this.useEarliestSequenceNumber;
    }

    @JsonProperty
    public Duration getCompletionTimeout() {
        return this.completionTimeout;
    }

    @JsonProperty
    public Optional<Duration> getEarlyMessageRejectionPeriod() {
        return this.earlyMessageRejectionPeriod;
    }

    @JsonProperty
    public Optional<Duration> getLateMessageRejectionPeriod() {
        return this.lateMessageRejectionPeriod;
    }
}

