/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.supervisor;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.inject.Inject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.apache.druid.indexing.overlord.DataSourceMetadata;
import org.apache.druid.indexing.overlord.supervisor.NoopSupervisorSpec;
import org.apache.druid.indexing.overlord.supervisor.Supervisor;
import org.apache.druid.indexing.overlord.supervisor.SupervisorReport;
import org.apache.druid.indexing.overlord.supervisor.SupervisorSpec;
import org.apache.druid.indexing.overlord.supervisor.VersionedSupervisorSpec;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.metadata.MetadataSupervisorManager;

public class SupervisorManager {
    private static final EmittingLogger log = new EmittingLogger(SupervisorManager.class);
    private final MetadataSupervisorManager metadataSupervisorManager;
    private final ConcurrentHashMap<String, Pair<Supervisor, SupervisorSpec>> supervisors = new ConcurrentHashMap();
    private final Object lock = new Object();
    private volatile boolean started = false;

    @Inject
    public SupervisorManager(MetadataSupervisorManager metadataSupervisorManager) {
        this.metadataSupervisorManager = metadataSupervisorManager;
    }

    public Set<String> getSupervisorIds() {
        return this.supervisors.keySet();
    }

    public Optional<SupervisorSpec> getSupervisorSpec(String id) {
        Pair<Supervisor, SupervisorSpec> supervisor = this.supervisors.get(id);
        return supervisor == null ? Optional.absent() : Optional.fromNullable((Object)supervisor.rhs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createOrUpdateAndStartSupervisor(SupervisorSpec spec) {
        Preconditions.checkState((boolean)this.started, (Object)"SupervisorManager not started");
        Preconditions.checkNotNull((Object)spec, (Object)"spec");
        Preconditions.checkNotNull((Object)spec.getId(), (Object)"spec.getId()");
        Preconditions.checkNotNull((Object)spec.getDataSources(), (Object)"spec.getDatasources()");
        Object object = this.lock;
        synchronized (object) {
            Preconditions.checkState((boolean)this.started, (Object)"SupervisorManager not started");
            this.possiblyStopAndRemoveSupervisorInternal(spec.getId(), false);
            return this.createAndStartSupervisorInternal(spec, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stopAndRemoveSupervisor(String id) {
        Preconditions.checkState((boolean)this.started, (Object)"SupervisorManager not started");
        Preconditions.checkNotNull((Object)id, (Object)"id");
        Object object = this.lock;
        synchronized (object) {
            Preconditions.checkState((boolean)this.started, (Object)"SupervisorManager not started");
            return this.possiblyStopAndRemoveSupervisorInternal(id, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean suspendOrResumeSupervisor(String id, boolean suspend) {
        Preconditions.checkState((boolean)this.started, (Object)"SupervisorManager not started");
        Preconditions.checkNotNull((Object)id, (Object)"id");
        Object object = this.lock;
        synchronized (object) {
            Preconditions.checkState((boolean)this.started, (Object)"SupervisorManager not started");
            return this.possiblySuspendOrResumeSupervisorInternal(id, suspend);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAndRemoveAllSupervisors() {
        Preconditions.checkState((boolean)this.started, (Object)"SupervisorManager not started");
        Object object = this.lock;
        synchronized (object) {
            Preconditions.checkState((boolean)this.started, (Object)"SupervisorManager not started");
            ((ConcurrentHashMap.KeySetView)this.supervisors.keySet()).forEach(id -> this.possiblyStopAndRemoveSupervisorInternal((String)id, true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspendOrResumeAllSupervisors(boolean suspend) {
        Preconditions.checkState((boolean)this.started, (Object)"SupervisorManager not started");
        Object object = this.lock;
        synchronized (object) {
            Preconditions.checkState((boolean)this.started, (Object)"SupervisorManager not started");
            ((ConcurrentHashMap.KeySetView)this.supervisors.keySet()).forEach(id -> this.possiblySuspendOrResumeSupervisorInternal((String)id, suspend));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStart
    public void start() {
        Preconditions.checkState((!this.started ? 1 : 0) != 0, (Object)"SupervisorManager already started");
        log.info("Loading stored supervisors from database", new Object[0]);
        Object object = this.lock;
        synchronized (object) {
            Map supervisors = this.metadataSupervisorManager.getLatest();
            for (String id : supervisors.keySet()) {
                SupervisorSpec spec = (SupervisorSpec)supervisors.get(id);
                if (spec instanceof NoopSupervisorSpec) continue;
                try {
                    this.createAndStartSupervisorInternal(spec, false);
                }
                catch (Exception ex) {
                    log.error((Throwable)ex, "Failed to start supervisor: [%s]", new Object[]{spec.getId()});
                }
            }
            this.started = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStop
    public void stop() {
        Preconditions.checkState((boolean)this.started, (Object)"SupervisorManager not started");
        Object object = this.lock;
        synchronized (object) {
            for (String id : this.supervisors.keySet()) {
                try {
                    ((Supervisor)this.supervisors.get((Object)id).lhs).stop(false);
                }
                catch (Exception e) {
                    log.warn((Throwable)e, "Caught exception while stopping supervisor [%s]", new Object[]{id});
                }
            }
            this.supervisors.clear();
            this.started = false;
        }
        log.info("SupervisorManager stopped.", new Object[0]);
    }

    public Map<String, List<VersionedSupervisorSpec>> getSupervisorHistory() {
        return this.metadataSupervisorManager.getAll();
    }

    public Optional<SupervisorReport> getSupervisorStatus(String id) {
        Pair<Supervisor, SupervisorSpec> supervisor = this.supervisors.get(id);
        return supervisor == null ? Optional.absent() : Optional.fromNullable((Object)((Supervisor)supervisor.lhs).getStatus());
    }

    public Optional<Map<String, Map<String, Object>>> getSupervisorStats(String id) {
        Pair<Supervisor, SupervisorSpec> supervisor = this.supervisors.get(id);
        return supervisor == null ? Optional.absent() : Optional.fromNullable((Object)((Supervisor)supervisor.lhs).getStats());
    }

    public boolean resetSupervisor(String id, @Nullable DataSourceMetadata dataSourceMetadata) {
        Preconditions.checkState((boolean)this.started, (Object)"SupervisorManager not started");
        Preconditions.checkNotNull((Object)id, (Object)"id");
        Pair<Supervisor, SupervisorSpec> supervisor = this.supervisors.get(id);
        if (supervisor == null) {
            return false;
        }
        ((Supervisor)supervisor.lhs).reset(dataSourceMetadata);
        return true;
    }

    public boolean checkPointDataSourceMetadata(String supervisorId, @Nullable Integer taskGroupId, String baseSequenceName, DataSourceMetadata previousDataSourceMetadata, DataSourceMetadata currentDataSourceMetadata) {
        try {
            Preconditions.checkState((boolean)this.started, (Object)"SupervisorManager not started");
            Preconditions.checkNotNull((Object)supervisorId, (Object)"supervisorId cannot be null");
            Pair<Supervisor, SupervisorSpec> supervisor = this.supervisors.get(supervisorId);
            Preconditions.checkNotNull(supervisor, (Object)"supervisor could not be found");
            ((Supervisor)supervisor.lhs).checkpoint(taskGroupId, baseSequenceName, previousDataSourceMetadata, currentDataSourceMetadata);
            return true;
        }
        catch (Exception e) {
            log.error((Throwable)e, "Checkpoint request failed", new Object[0]);
            return false;
        }
    }

    private boolean possiblyStopAndRemoveSupervisorInternal(String id, boolean writeTombstone) {
        Pair<Supervisor, SupervisorSpec> pair = this.supervisors.get(id);
        if (pair == null) {
            return false;
        }
        if (writeTombstone) {
            this.metadataSupervisorManager.insert(id, (SupervisorSpec)new NoopSupervisorSpec(null, ((SupervisorSpec)pair.rhs).getDataSources()));
        }
        ((Supervisor)pair.lhs).stop(true);
        this.supervisors.remove(id);
        return true;
    }

    private boolean possiblySuspendOrResumeSupervisorInternal(String id, boolean suspend) {
        Pair<Supervisor, SupervisorSpec> pair = this.supervisors.get(id);
        if (pair == null || ((SupervisorSpec)pair.rhs).isSuspended() == suspend) {
            return false;
        }
        SupervisorSpec nextState = suspend ? ((SupervisorSpec)pair.rhs).createSuspendedSpec() : ((SupervisorSpec)pair.rhs).createRunningSpec();
        this.possiblyStopAndRemoveSupervisorInternal(nextState.getId(), false);
        return this.createAndStartSupervisorInternal(nextState, true);
    }

    private boolean createAndStartSupervisorInternal(SupervisorSpec spec, boolean persistSpec) {
        Supervisor supervisor;
        String id = spec.getId();
        if (this.supervisors.containsKey(id)) {
            return false;
        }
        if (persistSpec) {
            this.metadataSupervisorManager.insert(id, spec);
        }
        try {
            supervisor = spec.createSupervisor();
            supervisor.start();
        }
        catch (Exception e) {
            if (persistSpec) {
                this.metadataSupervisorManager.insert(id, (SupervisorSpec)new NoopSupervisorSpec(null, spec.getDataSources()));
            }
            throw Throwables.propagate((Throwable)e);
        }
        this.supervisors.put(id, (Pair<Supervisor, SupervisorSpec>)Pair.of((Object)supervisor, (Object)spec));
        return true;
    }
}

