/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.http;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import java.net.URL;
import java.util.Set;
import org.apache.druid.indexing.overlord.TaskMaster;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.server.http.RedirectInfo;

public class OverlordRedirectInfo
implements RedirectInfo {
    private static final Set<String> LOCAL_PATHS = ImmutableSet.of((Object)"/druid/indexer/v1/leader", (Object)"/druid/indexer/v1/isLeader");
    private final TaskMaster taskMaster;

    @Inject
    public OverlordRedirectInfo(TaskMaster taskMaster) {
        this.taskMaster = taskMaster;
    }

    public boolean doLocal(String requestURI) {
        return requestURI != null && LOCAL_PATHS.contains(requestURI) || this.taskMaster.isLeader();
    }

    public URL getRedirectURL(String queryString, String requestURI) {
        try {
            String leader = this.taskMaster.getCurrentLeader();
            if (leader == null || leader.isEmpty()) {
                return null;
            }
            String location = StringUtils.format((String)"%s%s", (Object[])new Object[]{leader, requestURI});
            if (queryString != null) {
                location = StringUtils.format((String)"%s?%s", (Object[])new Object[]{location, queryString});
            }
            return new URL(location);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

