/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.hrtr;

import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.sun.jersey.spi.container.ResourceFilters;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.druid.indexing.overlord.TaskMaster;
import org.apache.druid.indexing.overlord.TaskRunner;
import org.apache.druid.indexing.overlord.hrtr.HttpRemoteTaskRunner;
import org.apache.druid.server.http.security.StateResourceFilter;

@Path(value="/druid-internal/v1/httpRemoteTaskRunner")
@ResourceFilters(value={StateResourceFilter.class})
public class HttpRemoteTaskRunnerResource {
    private final TaskMaster taskMaster;

    @Inject
    public HttpRemoteTaskRunnerResource(TaskMaster taskMaster) {
        this.taskMaster = taskMaster;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getDebugInfo() {
        HttpRemoteTaskRunner httpRemoteTaskRunner = this.getHttpRemoteTaskRunner();
        if (httpRemoteTaskRunner == null) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"HttpRemoteTaskRunner is NULL.").build();
        }
        return Response.ok().entity(httpRemoteTaskRunner.getDebugInfo()).build();
    }

    @GET
    @Path(value="/blacklistedWorkers")
    @Produces(value={"application/json"})
    public Response getBlacklistedWorkers() {
        HttpRemoteTaskRunner httpRemoteTaskRunner = this.getHttpRemoteTaskRunner();
        if (httpRemoteTaskRunner == null) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"HttpRemoteTaskRunner is NULL.").build();
        }
        return Response.ok().entity(httpRemoteTaskRunner.getBlacklistedWorkers()).build();
    }

    private HttpRemoteTaskRunner getHttpRemoteTaskRunner() {
        Optional<TaskRunner> taskRunnerOpt = this.taskMaster.getTaskRunner();
        if (taskRunnerOpt.isPresent() && taskRunnerOpt.get() instanceof HttpRemoteTaskRunner) {
            return (HttpRemoteTaskRunner)taskRunnerOpt.get();
        }
        return null;
    }
}

