/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.hrtr;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Supplier;
import com.google.inject.Inject;
import org.apache.curator.framework.CuratorFramework;
import org.apache.druid.discovery.DruidNodeDiscoveryProvider;
import org.apache.druid.guice.annotations.EscalatedGlobal;
import org.apache.druid.guice.annotations.Smile;
import org.apache.druid.indexing.overlord.TaskRunnerFactory;
import org.apache.druid.indexing.overlord.TaskStorage;
import org.apache.druid.indexing.overlord.autoscaling.NoopProvisioningStrategy;
import org.apache.druid.indexing.overlord.autoscaling.ProvisioningSchedulerConfig;
import org.apache.druid.indexing.overlord.autoscaling.ProvisioningStrategy;
import org.apache.druid.indexing.overlord.config.HttpRemoteTaskRunnerConfig;
import org.apache.druid.indexing.overlord.hrtr.HttpRemoteTaskRunner;
import org.apache.druid.indexing.overlord.setup.WorkerBehaviorConfig;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.server.initialization.IndexerZkConfig;

public class HttpRemoteTaskRunnerFactory
implements TaskRunnerFactory<HttpRemoteTaskRunner> {
    public static final String TYPE_NAME = "httpRemote";
    private final ObjectMapper smileMapper;
    private final HttpRemoteTaskRunnerConfig httpRemoteTaskRunnerConfig;
    private final HttpClient httpClient;
    private final Supplier<WorkerBehaviorConfig> workerConfigRef;
    private final ProvisioningSchedulerConfig provisioningSchedulerConfig;
    private final ProvisioningStrategy provisioningStrategy;
    private final DruidNodeDiscoveryProvider druidNodeDiscoveryProvider;
    private final TaskStorage taskStorage;
    private final CuratorFramework cf;
    private final IndexerZkConfig indexerZkConfig;

    @Inject
    public HttpRemoteTaskRunnerFactory(@Smile ObjectMapper smileMapper, HttpRemoteTaskRunnerConfig httpRemoteTaskRunnerConfig, @EscalatedGlobal HttpClient httpClient, Supplier<WorkerBehaviorConfig> workerConfigRef, ProvisioningSchedulerConfig provisioningSchedulerConfig, ProvisioningStrategy provisioningStrategy, DruidNodeDiscoveryProvider druidNodeDiscoveryProvider, TaskStorage taskStorage, CuratorFramework cf, IndexerZkConfig indexerZkConfig) {
        this.smileMapper = smileMapper;
        this.httpRemoteTaskRunnerConfig = httpRemoteTaskRunnerConfig;
        this.httpClient = httpClient;
        this.workerConfigRef = workerConfigRef;
        this.provisioningSchedulerConfig = provisioningSchedulerConfig;
        this.provisioningStrategy = provisioningStrategy;
        this.druidNodeDiscoveryProvider = druidNodeDiscoveryProvider;
        this.taskStorage = taskStorage;
        this.cf = cf;
        this.indexerZkConfig = indexerZkConfig;
    }

    @Override
    public HttpRemoteTaskRunner build() {
        return new HttpRemoteTaskRunner(this.smileMapper, this.httpRemoteTaskRunnerConfig, this.httpClient, this.workerConfigRef, this.provisioningSchedulerConfig.isDoAutoscale() ? this.provisioningStrategy : new NoopProvisioningStrategy(), this.druidNodeDiscoveryProvider, this.taskStorage, this.cf, this.indexerZkConfig);
    }
}

