/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.helpers;

import com.google.inject.Inject;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.druid.indexing.overlord.TaskStorage;
import org.apache.druid.indexing.overlord.helpers.OverlordHelper;
import org.apache.druid.indexing.overlord.helpers.TaskLogAutoCleanerConfig;
import org.apache.druid.java.util.common.concurrent.ScheduledExecutors;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.tasklogs.TaskLogKiller;
import org.joda.time.Duration;

public class TaskLogAutoCleaner
implements OverlordHelper {
    private static final Logger log = new Logger(TaskLogAutoCleaner.class);
    private final TaskLogKiller taskLogKiller;
    private final TaskLogAutoCleanerConfig config;
    private final TaskStorage taskStorage;

    @Inject
    public TaskLogAutoCleaner(TaskLogKiller taskLogKiller, TaskLogAutoCleanerConfig config, TaskStorage taskStorage) {
        this.taskLogKiller = taskLogKiller;
        this.config = config;
        this.taskStorage = taskStorage;
    }

    @Override
    public boolean isEnabled() {
        return this.config.isEnabled();
    }

    @Override
    public void schedule(ScheduledExecutorService exec) {
        log.info("Scheduling TaskLogAutoCleaner with config [%s].", new Object[]{this.config.toString()});
        ScheduledExecutors.scheduleWithFixedDelay((ScheduledExecutorService)exec, (Duration)Duration.millis((long)this.config.getInitialDelay()), (Duration)Duration.millis((long)this.config.getDelay()), (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    long timestamp = System.currentTimeMillis() - TaskLogAutoCleaner.this.config.getDurationToRetain();
                    TaskLogAutoCleaner.this.taskLogKiller.killOlderThan(timestamp);
                    TaskLogAutoCleaner.this.taskStorage.removeTasksOlderThan(timestamp);
                }
                catch (Exception ex) {
                    log.error((Throwable)ex, "Failed to clean-up the task logs", new Object[0]);
                }
            }
        });
    }
}

