/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.util.Iterator;

class QuotableWhiteSpaceSplitter
implements Iterable<String> {
    private final String string;

    public QuotableWhiteSpaceSplitter(String string) {
        this.string = (String)Preconditions.checkNotNull((Object)string);
    }

    @Override
    public Iterator<String> iterator() {
        return Splitter.on((CharMatcher)new CharMatcher(){
            private boolean inQuotes = false;

            public boolean matches(char c) {
                if ('\"' == c) {
                    boolean bl = this.inQuotes = !this.inQuotes;
                }
                if (this.inQuotes) {
                    return false;
                }
                return CharMatcher.BREAKING_WHITESPACE.matches(c);
            }
        }).omitEmptyStrings().split((CharSequence)this.string).iterator();
    }
}

