/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.worker.Worker;
import org.joda.time.DateTime;

public class ImmutableWorkerInfo {
    private final Worker worker;
    private final int currCapacityUsed;
    private final ImmutableSet<String> availabilityGroups;
    private final ImmutableSet<String> runningTasks;
    private final DateTime lastCompletedTaskTime;
    private final DateTime blacklistedUntil;

    @JsonCreator
    public ImmutableWorkerInfo(@JsonProperty(value="worker") Worker worker, @JsonProperty(value="currCapacityUsed") int currCapacityUsed, @JsonProperty(value="availabilityGroups") Set<String> availabilityGroups, @JsonProperty(value="runningTasks") Collection<String> runningTasks, @JsonProperty(value="lastCompletedTaskTime") DateTime lastCompletedTaskTime, @Nullable @JsonProperty(value="blacklistedUntil") DateTime blacklistedUntil) {
        this.worker = worker;
        this.currCapacityUsed = currCapacityUsed;
        this.availabilityGroups = ImmutableSet.copyOf(availabilityGroups);
        this.runningTasks = ImmutableSet.copyOf(runningTasks);
        this.lastCompletedTaskTime = lastCompletedTaskTime;
        this.blacklistedUntil = blacklistedUntil;
    }

    public ImmutableWorkerInfo(Worker worker, int currCapacityUsed, Set<String> availabilityGroups, Collection<String> runningTasks, DateTime lastCompletedTaskTime) {
        this(worker, currCapacityUsed, availabilityGroups, runningTasks, lastCompletedTaskTime, null);
    }

    @JsonProperty(value="worker")
    public Worker getWorker() {
        return this.worker;
    }

    @JsonProperty(value="currCapacityUsed")
    public int getCurrCapacityUsed() {
        return this.currCapacityUsed;
    }

    @JsonProperty(value="availabilityGroups")
    public Set<String> getAvailabilityGroups() {
        return this.availabilityGroups;
    }

    public int getAvailableCapacity() {
        return this.getWorker().getCapacity() - this.getCurrCapacityUsed();
    }

    @JsonProperty(value="runningTasks")
    public Set<String> getRunningTasks() {
        return this.runningTasks;
    }

    @JsonProperty(value="lastCompletedTaskTime")
    public DateTime getLastCompletedTaskTime() {
        return this.lastCompletedTaskTime;
    }

    @JsonProperty
    public DateTime getBlacklistedUntil() {
        return this.blacklistedUntil;
    }

    public boolean isValidVersion(String minVersion) {
        return this.worker.getVersion().compareTo(minVersion) >= 0;
    }

    public boolean canRunTask(Task task) {
        return this.worker.getCapacity() - this.getCurrCapacityUsed() >= task.getTaskResource().getRequiredCapacity() && !this.getAvailabilityGroups().contains(task.getTaskResource().getAvailabilityGroup());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableWorkerInfo that = (ImmutableWorkerInfo)o;
        if (this.currCapacityUsed != that.currCapacityUsed) {
            return false;
        }
        if (!this.worker.equals(that.worker)) {
            return false;
        }
        if (!this.availabilityGroups.equals(that.availabilityGroups)) {
            return false;
        }
        if (!this.runningTasks.equals(that.runningTasks)) {
            return false;
        }
        if (!this.lastCompletedTaskTime.equals((Object)that.lastCompletedTaskTime)) {
            return false;
        }
        return !(this.blacklistedUntil == null ? that.blacklistedUntil != null : !this.blacklistedUntil.equals((Object)that.blacklistedUntil));
    }

    public int hashCode() {
        int result = this.worker.hashCode();
        result = 31 * result + this.currCapacityUsed;
        result = 31 * result + this.availabilityGroups.hashCode();
        result = 31 * result + this.runningTasks.hashCode();
        result = 31 * result + this.lastCompletedTaskTime.hashCode();
        result = 31 * result + (this.blacklistedUntil != null ? this.blacklistedUntil.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ImmutableWorkerInfo{worker=" + this.worker + ", currCapacityUsed=" + this.currCapacityUsed + ", availabilityGroups=" + this.availabilityGroups + ", runningTasks=" + this.runningTasks + ", lastCompletedTaskTime=" + this.lastCompletedTaskTime + ", blacklistedUntil=" + this.blacklistedUntil + '}';
    }
}

