/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.firehose;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.druid.data.input.Firehose;
import org.apache.druid.data.input.FirehoseFactory;
import org.apache.druid.data.input.impl.InputRowParser;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.actions.SegmentListUsedAction;
import org.apache.druid.java.util.common.parsers.ParseException;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.QueryableIndexStorageAdapter;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.loading.SegmentLoadingException;
import org.apache.druid.segment.realtime.firehose.IngestSegmentFirehose;
import org.apache.druid.segment.realtime.firehose.WindowedStorageAdapter;
import org.apache.druid.segment.transform.TransformSpec;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.TimelineObjectHolder;
import org.apache.druid.timeline.VersionedIntervalTimeline;
import org.apache.druid.timeline.partition.PartitionChunk;
import org.joda.time.Interval;

public class IngestSegmentFirehoseFactory
implements FirehoseFactory<InputRowParser> {
    private static final EmittingLogger log = new EmittingLogger(IngestSegmentFirehoseFactory.class);
    private final String dataSource;
    private final Interval interval;
    private final DimFilter dimFilter;
    private final List<String> dimensions;
    private final List<String> metrics;
    private final IndexIO indexIO;
    private TaskToolbox taskToolbox;

    @JsonCreator
    public IngestSegmentFirehoseFactory(@JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="interval") Interval interval, @JsonProperty(value="filter") DimFilter dimFilter, @JsonProperty(value="dimensions") List<String> dimensions, @JsonProperty(value="metrics") List<String> metrics, @JacksonInject IndexIO indexIO) {
        Preconditions.checkNotNull((Object)dataSource, (Object)"dataSource");
        Preconditions.checkNotNull((Object)interval, (Object)"interval");
        this.dataSource = dataSource;
        this.interval = interval;
        this.dimFilter = dimFilter;
        this.dimensions = dimensions;
        this.metrics = metrics;
        this.indexIO = (IndexIO)Preconditions.checkNotNull((Object)indexIO, (Object)"null IndexIO");
    }

    @JsonProperty
    public String getDataSource() {
        return this.dataSource;
    }

    @JsonProperty
    public Interval getInterval() {
        return this.interval;
    }

    @JsonProperty(value="filter")
    public DimFilter getDimensionsFilter() {
        return this.dimFilter;
    }

    @JsonProperty
    public List<String> getDimensions() {
        return this.dimensions;
    }

    @JsonProperty
    public List<String> getMetrics() {
        return this.metrics;
    }

    public void setTaskToolbox(TaskToolbox taskToolbox) {
        this.taskToolbox = taskToolbox;
    }

    public Firehose connect(InputRowParser inputRowParser, File temporaryDirectory) throws ParseException {
        log.info("Connecting firehose: dataSource[%s], interval[%s]", new Object[]{this.dataSource, this.interval});
        Preconditions.checkNotNull((Object)this.taskToolbox, (Object)"taskToolbox is not set");
        try {
            List<DataSegment> usedSegments = this.taskToolbox.getTaskActionClient().submit(new SegmentListUsedAction(this.dataSource, this.interval, null));
            final Map<DataSegment, File> segmentFileMap = this.taskToolbox.fetchSegments(usedSegments);
            List timeLineSegments = VersionedIntervalTimeline.forSegments(usedSegments).lookup(this.interval);
            List<String> dims = this.dimensions != null ? this.dimensions : (inputRowParser.getParseSpec().getDimensionsSpec().hasCustomDimensions() ? inputRowParser.getParseSpec().getDimensionsSpec().getDimensionNames() : IngestSegmentFirehoseFactory.getUniqueDimensions(timeLineSegments, inputRowParser.getParseSpec().getDimensionsSpec().getDimensionExclusions()));
            List<String> metricsList = this.metrics == null ? IngestSegmentFirehoseFactory.getUniqueMetrics(timeLineSegments) : this.metrics;
            ArrayList adapters = Lists.newArrayList((Iterable)Iterables.concat((Iterable)Iterables.transform((Iterable)timeLineSegments, (Function)new Function<TimelineObjectHolder<String, DataSegment>, Iterable<WindowedStorageAdapter>>(){

                public Iterable<WindowedStorageAdapter> apply(final TimelineObjectHolder<String, DataSegment> holder) {
                    return Iterables.transform((Iterable)holder.getObject(), (Function)new Function<PartitionChunk<DataSegment>, WindowedStorageAdapter>(){

                        public WindowedStorageAdapter apply(PartitionChunk<DataSegment> input) {
                            DataSegment segment = (DataSegment)input.getObject();
                            try {
                                return new WindowedStorageAdapter((StorageAdapter)new QueryableIndexStorageAdapter(IngestSegmentFirehoseFactory.this.indexIO.loadIndex((File)Preconditions.checkNotNull(segmentFileMap.get(segment), (String)"File for segment %s", (Object[])new Object[]{segment.getId()}))), holder.getInterval());
                            }
                            catch (IOException e) {
                                throw Throwables.propagate((Throwable)e);
                            }
                        }
                    });
                }
            })));
            TransformSpec transformSpec = TransformSpec.fromInputRowParser((InputRowParser)inputRowParser);
            return new IngestSegmentFirehose((List)adapters, transformSpec, dims, metricsList, this.dimFilter);
        }
        catch (IOException | SegmentLoadingException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @VisibleForTesting
    static List<String> getUniqueDimensions(List<TimelineObjectHolder<String, DataSegment>> timelineSegments, @Nullable Set<String> excludeDimensions) {
        HashBiMap uniqueDims = HashBiMap.create();
        int index = 0;
        for (TimelineObjectHolder timelineHolder : Lists.reverse(timelineSegments)) {
            for (PartitionChunk chunk : timelineHolder.getObject()) {
                for (String dimension : ((DataSegment)chunk.getObject()).getDimensions()) {
                    if (uniqueDims.containsKey((Object)dimension) || excludeDimensions != null && excludeDimensions.contains(dimension)) continue;
                    uniqueDims.put((Object)dimension, (Object)index++);
                }
            }
        }
        BiMap orderedDims = uniqueDims.inverse();
        return IntStream.range(0, orderedDims.size()).mapToObj(arg_0 -> orderedDims.get(arg_0)).collect(Collectors.toList());
    }

    @VisibleForTesting
    static List<String> getUniqueMetrics(List<TimelineObjectHolder<String, DataSegment>> timelineSegments) {
        HashBiMap uniqueMetrics = HashBiMap.create();
        int index = 0;
        for (TimelineObjectHolder timelineHolder : Lists.reverse(timelineSegments)) {
            for (PartitionChunk chunk : timelineHolder.getObject()) {
                for (String metric : ((DataSegment)chunk.getObject()).getMetrics()) {
                    if (uniqueMetrics.containsKey((Object)metric)) continue;
                    uniqueMetrics.put((Object)metric, (Object)index++);
                }
            }
        }
        BiMap orderedMetrics = uniqueMetrics.inverse();
        return IntStream.range(0, orderedMetrics.size()).mapToObj(arg_0 -> orderedMetrics.get(arg_0)).collect(Collectors.toList());
    }
}

