/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.indexing.common.task.IndexTask;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.joda.time.Duration;
import org.joda.time.Period;

@JsonTypeName(value="index_parallel")
public class ParallelIndexTuningConfig
extends IndexTask.IndexTuningConfig {
    private static final int DEFAULT_MAX_NUM_BATCH_TASKS = 1;
    private static final int DEFAULT_MAX_RETRY = 3;
    private static final long DEFAULT_TASK_STATUS_CHECK_PERIOD_MS = 1000L;
    private static final Duration DEFAULT_CHAT_HANDLER_TIMEOUT = new Period((Object)"PT10S").toStandardDuration();
    private static final int DEFAULT_CHAT_HANDLER_NUM_RETRIES = 5;
    private final int maxNumSubTasks;
    private final int maxRetry;
    private final long taskStatusCheckPeriodMs;
    private final Duration chatHandlerTimeout;
    private final int chatHandlerNumRetries;

    public static ParallelIndexTuningConfig defaultConfig() {
        return new ParallelIndexTuningConfig(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    @JsonCreator
    public ParallelIndexTuningConfig(@JsonProperty(value="targetPartitionSize") @Deprecated @Nullable Integer targetPartitionSize, @JsonProperty(value="maxRowsPerSegment") @Nullable Integer maxRowsPerSegment, @JsonProperty(value="maxRowsInMemory") @Nullable Integer maxRowsInMemory, @JsonProperty(value="maxBytesInMemory") @Nullable Long maxBytesInMemory, @JsonProperty(value="maxTotalRows") @Nullable Long maxTotalRows, @JsonProperty(value="numShards") @Nullable Integer numShards, @JsonProperty(value="indexSpec") @Nullable IndexSpec indexSpec, @JsonProperty(value="maxPendingPersists") @Nullable Integer maxPendingPersists, @JsonProperty(value="forceExtendableShardSpecs") @Nullable Boolean forceExtendableShardSpecs, @JsonProperty(value="forceGuaranteedRollup") @Nullable Boolean forceGuaranteedRollup, @JsonProperty(value="reportParseExceptions") @Nullable Boolean reportParseExceptions, @JsonProperty(value="pushTimeout") @Nullable Long pushTimeout, @JsonProperty(value="segmentWriteOutMediumFactory") @Nullable SegmentWriteOutMediumFactory segmentWriteOutMediumFactory, @JsonProperty(value="maxNumSubTasks") @Nullable Integer maxNumSubTasks, @JsonProperty(value="maxRetry") @Nullable Integer maxRetry, @JsonProperty(value="taskStatusCheckPeriodMs") @Nullable Integer taskStatusCheckPeriodMs, @JsonProperty(value="chatHandlerTimeout") @Nullable Duration chatHandlerTimeout, @JsonProperty(value="chatHandlerNumRetries") @Nullable Integer chatHandlerNumRetries, @JsonProperty(value="logParseExceptions") @Nullable Boolean logParseExceptions, @JsonProperty(value="maxParseExceptions") @Nullable Integer maxParseExceptions, @JsonProperty(value="maxSavedParseExceptions") @Nullable Integer maxSavedParseExceptions) {
        super(targetPartitionSize, maxRowsPerSegment, maxRowsInMemory, maxBytesInMemory, maxTotalRows, null, numShards, null, indexSpec, maxPendingPersists, null, forceExtendableShardSpecs, forceGuaranteedRollup, reportParseExceptions, null, pushTimeout, segmentWriteOutMediumFactory, logParseExceptions, maxParseExceptions, maxSavedParseExceptions);
        this.maxNumSubTasks = maxNumSubTasks == null ? 1 : maxNumSubTasks;
        this.maxRetry = maxRetry == null ? 3 : maxRetry;
        this.taskStatusCheckPeriodMs = taskStatusCheckPeriodMs == null ? 1000L : (long)taskStatusCheckPeriodMs.intValue();
        this.chatHandlerTimeout = DEFAULT_CHAT_HANDLER_TIMEOUT;
        this.chatHandlerNumRetries = 5;
        Preconditions.checkArgument((this.maxNumSubTasks > 0 ? 1 : 0) != 0, (Object)"maxNumSubTasks must be positive");
    }

    @JsonProperty
    public int getMaxNumSubTasks() {
        return this.maxNumSubTasks;
    }

    @JsonProperty
    public int getMaxRetry() {
        return this.maxRetry;
    }

    @JsonProperty
    public long getTaskStatusCheckPeriodMs() {
        return this.taskStatusCheckPeriodMs;
    }

    @JsonProperty
    public Duration getChatHandlerTimeout() {
        return this.chatHandlerTimeout;
    }

    @JsonProperty
    public int getChatHandlerNumRetries() {
        return this.chatHandlerNumRetries;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ParallelIndexTuningConfig that = (ParallelIndexTuningConfig)o;
        return this.maxNumSubTasks == that.maxNumSubTasks && this.maxRetry == that.maxRetry && this.taskStatusCheckPeriodMs == that.taskStatusCheckPeriodMs && this.chatHandlerNumRetries == that.chatHandlerNumRetries && Objects.equals(this.chatHandlerTimeout, that.chatHandlerTimeout);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.maxNumSubTasks, this.maxRetry, this.taskStatusCheckPeriodMs, this.chatHandlerTimeout, this.chatHandlerNumRetries);
    }
}

