/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.indexer.TaskState;
import org.apache.druid.indexer.TaskStatusPlus;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexSubTaskSpec;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexingProgress;
import org.apache.druid.indexing.common.task.batch.parallel.PushedSegmentsReport;
import org.apache.druid.indexing.common.task.batch.parallel.SubTaskSpec;
import org.apache.druid.indexing.common.task.batch.parallel.TaskHistory;

public interface ParallelIndexTaskRunner<T extends Task> {
    public TaskState run() throws Exception;

    public void collectReport(PushedSegmentsReport var1);

    public ParallelIndexingProgress getProgress();

    public Set<String> getRunningTaskIds();

    public List<SubTaskSpec<T>> getSubTaskSpecs();

    public List<SubTaskSpec<T>> getRunningSubTaskSpecs();

    public List<SubTaskSpec<T>> getCompleteSubTaskSpecs();

    @Nullable
    public SubTaskSpec<T> getSubTaskSpec(String var1);

    @Nullable
    public SubTaskSpecStatus getSubTaskState(String var1);

    @Nullable
    public TaskHistory<T> getCompleteSubTaskSpecAttemptHistory(String var1);

    public static class SubTaskSpecStatus {
        private final ParallelIndexSubTaskSpec spec;
        @Nullable
        private final TaskStatusPlus currentStatus;
        private final List<TaskStatusPlus> taskHistory;

        @JsonCreator
        public SubTaskSpecStatus(@JsonProperty(value="spec") ParallelIndexSubTaskSpec spec, @JsonProperty(value="currentStatus") @Nullable TaskStatusPlus currentStatus, @JsonProperty(value="taskHistory") List<TaskStatusPlus> taskHistory) {
            this.spec = spec;
            this.currentStatus = currentStatus;
            this.taskHistory = taskHistory;
        }

        @JsonProperty
        public ParallelIndexSubTaskSpec getSpec() {
            return this.spec;
        }

        @JsonProperty
        @Nullable
        public TaskStatusPlus getCurrentStatus() {
            return this.currentStatus;
        }

        @JsonProperty
        public List<TaskStatusPlus> getTaskHistory() {
            return this.taskHistory;
        }
    }
}

