/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import org.apache.druid.guice.annotations.EscalatedGlobal;
import org.apache.druid.guice.annotations.Smile;
import org.apache.druid.indexing.common.TaskInfoProvider;
import org.apache.druid.indexing.common.task.IndexTaskClientFactory;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexTaskClient;
import org.apache.druid.java.util.http.client.HttpClient;
import org.joda.time.Duration;

public class ParallelIndexTaskClientFactory
implements IndexTaskClientFactory<ParallelIndexTaskClient> {
    private final HttpClient httpClient;
    private final ObjectMapper mapper;

    @Inject
    public ParallelIndexTaskClientFactory(@EscalatedGlobal HttpClient httpClient, @Smile ObjectMapper mapper) {
        this.httpClient = httpClient;
        this.mapper = mapper;
    }

    @Override
    public ParallelIndexTaskClient build(TaskInfoProvider taskInfoProvider, String callerId, int numThreads, Duration httpTimeout, long numRetries) {
        Preconditions.checkState((numThreads == 1 ? 1 : 0) != 0, (Object)"expect numThreads to be 1");
        return new ParallelIndexTaskClient(this.httpClient, this.mapper, taskInfoProvider, httpTimeout, callerId, numRetries);
    }
}

