/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import org.apache.druid.indexing.common.IndexTaskClient;
import org.apache.druid.indexing.common.TaskInfoProvider;
import org.apache.druid.indexing.common.task.batch.parallel.PushedSegmentsReport;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.java.util.http.client.response.FullResponseHolder;
import org.apache.druid.segment.realtime.appenderator.SegmentIdWithShardSpec;
import org.apache.druid.timeline.DataSegment;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.joda.time.DateTime;
import org.joda.time.Duration;

public class ParallelIndexTaskClient
extends IndexTaskClient {
    private final String subtaskId;

    ParallelIndexTaskClient(HttpClient httpClient, ObjectMapper objectMapper, TaskInfoProvider taskInfoProvider, Duration httpTimeout, String callerId, long numRetries) {
        super(httpClient, objectMapper, taskInfoProvider, httpTimeout, callerId, 1, numRetries);
        this.subtaskId = callerId;
    }

    String getSubtaskId() {
        return this.subtaskId;
    }

    public SegmentIdWithShardSpec allocateSegment(String supervisorTaskId, DateTime timestamp) throws IOException {
        FullResponseHolder response = this.submitSmileRequest(supervisorTaskId, HttpMethod.POST, "segment/allocate", null, this.serialize(timestamp), true);
        if (!this.isSuccess(response)) {
            throw new ISE("task[%s] failed to allocate a new segment identifier with the HTTP code[%d] and content[%s]", new Object[]{supervisorTaskId, response.getStatus().getCode(), response.getContent()});
        }
        return this.deserialize(response.getContent(), new TypeReference<SegmentIdWithShardSpec>(){});
    }

    public void report(String supervisorTaskId, List<DataSegment> pushedSegments) {
        try {
            FullResponseHolder response = this.submitSmileRequest(supervisorTaskId, HttpMethod.POST, "report", null, this.serialize(new PushedSegmentsReport(this.subtaskId, pushedSegments)), true);
            if (!this.isSuccess(response)) {
                throw new ISE("Failed to send taskReports to task[%s] with the HTTP code [%d]", new Object[]{supervisorTaskId, response.getStatus().getCode()});
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

