/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.druid.client.indexing.IndexingServiceClient;
import org.apache.druid.data.input.FirehoseFactory;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.appenderator.ActionBasedSegmentAllocator;
import org.apache.druid.indexing.appenderator.ActionBasedUsedSegmentChecker;
import org.apache.druid.indexing.common.TaskLockType;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.actions.LockTryAcquireAction;
import org.apache.druid.indexing.common.actions.SegmentAllocateAction;
import org.apache.druid.indexing.common.actions.SurrogateAction;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.common.task.AbstractTask;
import org.apache.druid.indexing.common.task.ClientBasedTaskInfoProvider;
import org.apache.druid.indexing.common.task.IndexTaskClientFactory;
import org.apache.druid.indexing.common.task.TaskResource;
import org.apache.druid.indexing.common.task.Tasks;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexIOConfig;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexIngestionSpec;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexTaskClient;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexTuningConfig;
import org.apache.druid.indexing.firehose.IngestSegmentFirehoseFactory;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.IndexMerger;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.segment.loading.DataSegmentPusher;
import org.apache.druid.segment.realtime.FireDepartmentMetrics;
import org.apache.druid.segment.realtime.appenderator.Appenderator;
import org.apache.druid.segment.realtime.appenderator.AppenderatorConfig;
import org.apache.druid.segment.realtime.appenderator.Appenderators;
import org.apache.druid.segment.realtime.appenderator.BatchAppenderatorDriver;
import org.apache.druid.segment.realtime.appenderator.SegmentAllocator;
import org.apache.druid.segment.realtime.appenderator.UsedSegmentChecker;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.Interval;

public class ParallelIndexSubTask
extends AbstractTask {
    public static final String TYPE = "index_sub";
    private static final Logger log = new Logger(ParallelIndexSubTask.class);
    private final int numAttempts;
    private final ParallelIndexIngestionSpec ingestionSchema;
    private final String supervisorTaskId;
    private final IndexingServiceClient indexingServiceClient;
    private final IndexTaskClientFactory<ParallelIndexTaskClient> taskClientFactory;

    @JsonCreator
    public ParallelIndexSubTask(@JsonProperty(value="id") @Nullable String id, @JsonProperty(value="groupId") String groupId, @JsonProperty(value="resource") TaskResource taskResource, @JsonProperty(value="supervisorTaskId") String supervisorTaskId, @JsonProperty(value="numAttempts") int numAttempts, @JsonProperty(value="spec") ParallelIndexIngestionSpec ingestionSchema, @JsonProperty(value="context") Map<String, Object> context, @JacksonInject IndexingServiceClient indexingServiceClient, @JacksonInject IndexTaskClientFactory<ParallelIndexTaskClient> taskClientFactory) {
        super(ParallelIndexSubTask.getOrMakeId(id, TYPE, ingestionSchema.getDataSchema().getDataSource()), groupId, taskResource, ingestionSchema.getDataSchema().getDataSource(), context);
        if (ingestionSchema.getTuningConfig().isForceGuaranteedRollup()) {
            throw new UnsupportedOperationException("Guaranteed rollup is not supported");
        }
        this.numAttempts = numAttempts;
        this.ingestionSchema = ingestionSchema;
        this.supervisorTaskId = supervisorTaskId;
        this.indexingServiceClient = indexingServiceClient;
        this.taskClientFactory = taskClientFactory;
    }

    @Override
    public int getPriority() {
        return this.getContextValue("priority", 50);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public boolean isReady(TaskActionClient taskActionClient) {
        Optional intervals = this.ingestionSchema.getDataSchema().getGranularitySpec().bucketIntervals();
        return !intervals.isPresent() || this.checkLockAcquired(taskActionClient, (SortedSet)intervals.get());
    }

    private boolean checkLockAcquired(TaskActionClient actionClient, SortedSet<Interval> intervals) {
        try {
            this.tryAcquireExclusiveSurrogateLocks(actionClient, intervals);
            return true;
        }
        catch (Exception e) {
            log.error((Throwable)e, "Failed to acquire locks for intervals[%s]", new Object[]{intervals});
            return false;
        }
    }

    @JsonProperty
    public int getNumAttempts() {
        return this.numAttempts;
    }

    @JsonProperty(value="spec")
    public ParallelIndexIngestionSpec getIngestionSchema() {
        return this.ingestionSchema;
    }

    @JsonProperty
    public String getSupervisorTaskId() {
        return this.supervisorTaskId;
    }

    @Override
    public TaskStatus run(TaskToolbox toolbox) throws Exception {
        FirehoseFactory firehoseFactory = this.ingestionSchema.getIOConfig().getFirehoseFactory();
        if (firehoseFactory instanceof IngestSegmentFirehoseFactory) {
            ((IngestSegmentFirehoseFactory)firehoseFactory).setTaskToolbox(toolbox);
        }
        File firehoseTempDir = toolbox.getFirehoseTemporaryDir();
        FileUtils.forceMkdir((File)firehoseTempDir);
        ParallelIndexTaskClient taskClient = this.taskClientFactory.build(new ClientBasedTaskInfoProvider(this.indexingServiceClient), this.getId(), 1, this.ingestionSchema.getTuningConfig().getChatHandlerTimeout(), this.ingestionSchema.getTuningConfig().getChatHandlerNumRetries());
        List<DataSegment> pushedSegments = this.generateAndPushSegments(toolbox, taskClient, firehoseFactory, firehoseTempDir);
        taskClient.report(this.supervisorTaskId, pushedSegments);
        return TaskStatus.success((String)this.getId());
    }

    private void tryAcquireExclusiveSurrogateLocks(TaskActionClient client, SortedSet<Interval> intervals) throws IOException {
        for (Interval interval : Tasks.computeCompactIntervals(intervals)) {
            Preconditions.checkNotNull(client.submit(new SurrogateAction(this.supervisorTaskId, new LockTryAcquireAction(TaskLockType.EXCLUSIVE, interval))), (String)"Cannot acquire a lock for interval[%s]", (Object[])new Object[]{interval});
        }
    }

    private SegmentAllocator createSegmentAllocator(TaskToolbox toolbox, ParallelIndexTaskClient taskClient, ParallelIndexIngestionSpec ingestionSchema) {
        DataSchema dataSchema = ingestionSchema.getDataSchema();
        ParallelIndexIOConfig ioConfig = ingestionSchema.getIOConfig();
        if (ioConfig.isAppendToExisting()) {
            return new ActionBasedSegmentAllocator(toolbox.getTaskActionClient(), dataSchema, (schema, row, sequenceName, previousSegmentId, skipSegmentLineageCheck) -> new SurrogateAction(this.supervisorTaskId, new SegmentAllocateAction(schema.getDataSource(), row.getTimestamp(), schema.getGranularitySpec().getQueryGranularity(), schema.getGranularitySpec().getSegmentGranularity(), sequenceName, previousSegmentId, skipSegmentLineageCheck)));
        }
        return (row, sequenceName, previousSegmentId, skipSegmentLineageCheck) -> taskClient.allocateSegment(this.supervisorTaskId, row.getTimestamp());
    }

    /*
     * Exception decompiling
     */
    private List<DataSegment> generateAndPushSegments(TaskToolbox toolbox, ParallelIndexTaskClient taskClient, FirehoseFactory firehoseFactory, File firehoseTempDir) throws IOException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Appenderator newAppenderator(FireDepartmentMetrics metrics, TaskToolbox toolbox, DataSchema dataSchema, ParallelIndexTuningConfig tuningConfig) {
        return Appenderators.createOffline((DataSchema)dataSchema, (AppenderatorConfig)tuningConfig.withBasePersistDirectory(toolbox.getPersistDir()), (FireDepartmentMetrics)metrics, (DataSegmentPusher)toolbox.getSegmentPusher(), (ObjectMapper)toolbox.getObjectMapper(), (IndexIO)toolbox.getIndexIO(), (IndexMerger)toolbox.getIndexMergerV9());
    }

    private static BatchAppenderatorDriver newDriver(Appenderator appenderator, TaskToolbox toolbox, SegmentAllocator segmentAllocator) {
        return new BatchAppenderatorDriver(appenderator, segmentAllocator, (UsedSegmentChecker)new ActionBasedUsedSegmentChecker(toolbox.getTaskActionClient()), toolbox.getDataSegmentKiller());
    }
}

