/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.indexer.TaskState;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.actions.SegmentListUsedAction;
import org.apache.druid.indexing.common.task.AbstractFixedIntervalTask;
import org.apache.druid.indexing.common.task.MergeTask;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.Interval;

public class SameIntervalMergeTask
extends AbstractFixedIntervalTask {
    private static final String TYPE = "same_interval_merge";
    @JsonIgnore
    private final List<AggregatorFactory> aggregators;
    private final Boolean rollup;
    private final IndexSpec indexSpec;
    @Nullable
    private final SegmentWriteOutMediumFactory segmentWriteOutMediumFactory;

    public SameIntervalMergeTask(@JsonProperty(value="id") String id, @JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="interval") Interval interval, @JsonProperty(value="aggregations") List<AggregatorFactory> aggregators, @JsonProperty(value="rollup") Boolean rollup, @JsonProperty(value="indexSpec") IndexSpec indexSpec, @JsonProperty(value="buildV9Directly") Boolean buildV9Directly, @JsonProperty(value="segmentWriteOutMediumFactory") @Nullable SegmentWriteOutMediumFactory segmentWriteOutMediumFactory, @JsonProperty(value="context") Map<String, Object> context) {
        super(SameIntervalMergeTask.makeId(id, TYPE, dataSource, interval), dataSource, interval, context);
        this.aggregators = (List)Preconditions.checkNotNull(aggregators, (Object)"null aggregations");
        this.rollup = rollup == null ? Boolean.TRUE : rollup;
        this.indexSpec = indexSpec == null ? new IndexSpec() : indexSpec;
        this.segmentWriteOutMediumFactory = segmentWriteOutMediumFactory;
    }

    @JsonProperty(value="aggregations")
    public List<AggregatorFactory> getAggregators() {
        return this.aggregators;
    }

    @JsonProperty
    public Boolean getRollup() {
        return this.rollup;
    }

    @JsonProperty
    public IndexSpec getIndexSpec() {
        return this.indexSpec;
    }

    @Deprecated
    @JsonProperty
    public Boolean getBuildV9Directly() {
        return true;
    }

    public static String makeId(String id, String typeName, String dataSource, Interval interval) {
        return id != null ? id : SameIntervalMergeTask.joinId(typeName, dataSource, interval.getStart(), interval.getEnd(), DateTimes.nowUtc().toString());
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public TaskStatus run(TaskToolbox toolbox) throws Exception {
        List<DataSegment> segments = toolbox.getTaskActionClient().submit(new SegmentListUsedAction(this.getDataSource(), this.getInterval(), null));
        SubTask mergeTask = new SubTask(this.getId(), this.getDataSource(), segments, this.aggregators, this.rollup, this.indexSpec, this.segmentWriteOutMediumFactory, this.getContext());
        TaskStatus status = mergeTask.run(toolbox);
        if (!status.isSuccess()) {
            return TaskStatus.fromCode((String)this.getId(), (TaskState)status.getStatusCode());
        }
        return this.success();
    }

    public static class SubTask
    extends MergeTask {
        private SubTask(String baseId, String dataSource, List<DataSegment> segments, List<AggregatorFactory> aggregators, Boolean rollup, IndexSpec indexSpec, @Nullable SegmentWriteOutMediumFactory segmentWriteOutMediumFactory, Map<String, Object> context) {
            super("sub_" + baseId, dataSource, segments, aggregators, rollup, indexSpec, true, segmentWriteOutMediumFactory, context);
        }

        @Override
        protected void verifyInputSegments(List<DataSegment> segments) {
        }
    }
}

