/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.common.TaskLock;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.actions.SegmentListUnusedAction;
import org.apache.druid.indexing.common.actions.SegmentNukeAction;
import org.apache.druid.indexing.common.task.AbstractFixedIntervalTask;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.Interval;

public class KillTask
extends AbstractFixedIntervalTask {
    private static final Logger log = new Logger(KillTask.class);

    @JsonCreator
    public KillTask(@JsonProperty(value="id") String id, @JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="interval") Interval interval, @JsonProperty(value="context") Map<String, Object> context) {
        super(KillTask.getOrMakeId(id, "kill", dataSource, interval), dataSource, interval, context);
    }

    @Override
    public String getType() {
        return "kill";
    }

    @Override
    public TaskStatus run(TaskToolbox toolbox) throws Exception {
        TaskLock myLock = (TaskLock)Iterables.getOnlyElement(KillTask.getTaskLocks(toolbox.getTaskActionClient()));
        if (!myLock.getDataSource().equals(this.getDataSource())) {
            throw new ISE("WTF?! Lock dataSource[%s] != task dataSource[%s]", new Object[]{myLock.getDataSource(), this.getDataSource()});
        }
        if (!myLock.getInterval().equals((Object)this.getInterval())) {
            throw new ISE("WTF?! Lock interval[%s] != task interval[%s]", new Object[]{myLock.getInterval(), this.getInterval()});
        }
        List<DataSegment> unusedSegments = toolbox.getTaskActionClient().submit(new SegmentListUnusedAction(myLock.getDataSource(), myLock.getInterval()));
        for (DataSegment unusedSegment : unusedSegments) {
            if (unusedSegment.getVersion().compareTo(myLock.getVersion()) > 0) {
                throw new ISE("WTF?! Unused segment[%s] has version[%s] > task version[%s]", new Object[]{unusedSegment.getId(), unusedSegment.getVersion(), myLock.getVersion()});
            }
            log.info("OK to kill segment: %s", new Object[]{unusedSegment.getId()});
        }
        for (DataSegment segment : unusedSegments) {
            toolbox.getDataSegmentKiller().kill(segment);
            toolbox.getTaskActionClient().submit(new SegmentNukeAction((Set<DataSegment>)ImmutableSet.of((Object)segment)));
        }
        return TaskStatus.success((String)this.getId());
    }
}

