/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.server.security.Access;
import org.apache.druid.server.security.Action;
import org.apache.druid.server.security.AuthorizationUtils;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.server.security.ForbiddenException;
import org.apache.druid.server.security.Resource;
import org.apache.druid.server.security.ResourceAction;
import org.apache.druid.server.security.ResourceType;
import org.apache.druid.utils.CircularBuffer;

public class IndexTaskUtils {
    @Nullable
    public static List<String> getMessagesFromSavedParseExceptions(CircularBuffer<Throwable> savedParseExceptions) {
        if (savedParseExceptions == null) {
            return null;
        }
        ArrayList<String> events = new ArrayList<String>();
        for (int i = 0; i < savedParseExceptions.size(); ++i) {
            events.add(((Throwable)savedParseExceptions.getLatest(i)).getMessage());
        }
        return events;
    }

    public static Access datasourceAuthorizationCheck(HttpServletRequest req, Action action, String datasource, AuthorizerMapper authorizerMapper) {
        ResourceAction resourceAction = new ResourceAction(new Resource(datasource, ResourceType.DATASOURCE), action);
        Access access = AuthorizationUtils.authorizeResourceAction((HttpServletRequest)req, (ResourceAction)resourceAction, (AuthorizerMapper)authorizerMapper);
        if (!access.isAllowed()) {
            throw new ForbiddenException(access.toString());
        }
        return access;
    }

    public static void setTaskDimensions(ServiceMetricEvent.Builder metricBuilder, Task task) {
        metricBuilder.setDimension("taskId", task.getId());
        metricBuilder.setDimension("taskType", task.getType());
        metricBuilder.setDimension("dataSource", task.getDataSource());
    }

    public static void setTaskStatusDimensions(ServiceMetricEvent.Builder metricBuilder, TaskStatus taskStatus) {
        metricBuilder.setDimension("taskId", taskStatus.getId());
        metricBuilder.setDimension("taskStatus", taskStatus.getStatusCode().toString());
    }
}

