/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.druid.data.input.FirehoseFactory;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.hll.HyperLogLogCollector;
import org.apache.druid.indexer.IngestionState;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.appenderator.ActionBasedUsedSegmentChecker;
import org.apache.druid.indexing.common.IngestionStatsAndErrorsTaskReport;
import org.apache.druid.indexing.common.IngestionStatsAndErrorsTaskReportData;
import org.apache.druid.indexing.common.TaskLock;
import org.apache.druid.indexing.common.TaskReport;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.actions.SegmentAllocateAction;
import org.apache.druid.indexing.common.actions.SegmentTransactionalInsertAction;
import org.apache.druid.indexing.common.actions.TaskAction;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.common.stats.RowIngestionMeters;
import org.apache.druid.indexing.common.stats.RowIngestionMetersFactory;
import org.apache.druid.indexing.common.stats.RowIngestionMetersTotals;
import org.apache.druid.indexing.common.task.AbstractTask;
import org.apache.druid.indexing.common.task.IndexTaskUtils;
import org.apache.druid.indexing.common.task.TaskResource;
import org.apache.druid.indexing.common.task.Tasks;
import org.apache.druid.indexing.firehose.IngestSegmentFirehoseFactory;
import org.apache.druid.indexing.overlord.SegmentPublishResult;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.JodaUtils;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.common.parsers.ParseException;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.IndexMerger;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.segment.indexing.IOConfig;
import org.apache.druid.segment.indexing.IngestionSpec;
import org.apache.druid.segment.indexing.TuningConfig;
import org.apache.druid.segment.indexing.granularity.GranularitySpec;
import org.apache.druid.segment.loading.DataSegmentPusher;
import org.apache.druid.segment.realtime.FireDepartmentMetrics;
import org.apache.druid.segment.realtime.appenderator.Appenderator;
import org.apache.druid.segment.realtime.appenderator.AppenderatorConfig;
import org.apache.druid.segment.realtime.appenderator.Appenderators;
import org.apache.druid.segment.realtime.appenderator.BatchAppenderatorDriver;
import org.apache.druid.segment.realtime.appenderator.SegmentAllocator;
import org.apache.druid.segment.realtime.appenderator.SegmentIdWithShardSpec;
import org.apache.druid.segment.realtime.appenderator.SegmentsAndMetadata;
import org.apache.druid.segment.realtime.appenderator.UsedSegmentChecker;
import org.apache.druid.segment.realtime.firehose.ChatHandler;
import org.apache.druid.segment.realtime.firehose.ChatHandlerProvider;
import org.apache.druid.segment.realtime.firehose.CombiningFirehoseFactory;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.druid.server.security.Action;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.timeline.partition.HashBasedNumberedShardSpec;
import org.apache.druid.timeline.partition.NoneShardSpec;
import org.apache.druid.timeline.partition.NumberedShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.druid.utils.CircularBuffer;
import org.codehaus.plexus.util.FileUtils;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableInterval;

public class IndexTask
extends AbstractTask
implements ChatHandler {
    private static final Logger log = new Logger(IndexTask.class);
    private static final HashFunction hashFunction = Hashing.murmur3_128();
    private static final String TYPE = "index";
    @JsonIgnore
    private final IndexIngestionSpec ingestionSchema;
    @JsonIgnore
    private IngestionState ingestionState;
    @JsonIgnore
    private final AuthorizerMapper authorizerMapper;
    @JsonIgnore
    private final Optional<ChatHandlerProvider> chatHandlerProvider;
    @JsonIgnore
    private FireDepartmentMetrics buildSegmentsFireDepartmentMetrics;
    @JsonIgnore
    private CircularBuffer<Throwable> buildSegmentsSavedParseExceptions;
    @JsonIgnore
    private CircularBuffer<Throwable> determinePartitionsSavedParseExceptions;
    @JsonIgnore
    private String errorMsg;
    @JsonIgnore
    private final RowIngestionMeters determinePartitionsMeters;
    @JsonIgnore
    private final RowIngestionMeters buildSegmentsMeters;

    private static String makeGroupId(IndexIngestionSpec ingestionSchema) {
        return IndexTask.makeGroupId(ingestionSchema.ioConfig.appendToExisting, ingestionSchema.dataSchema.getDataSource());
    }

    private static String makeGroupId(boolean isAppendToExisting, String dataSource) {
        if (isAppendToExisting) {
            return StringUtils.format((String)"%s_append_%s", (Object[])new Object[]{TYPE, dataSource});
        }
        return null;
    }

    @JsonCreator
    public IndexTask(@JsonProperty(value="id") String id, @JsonProperty(value="resource") TaskResource taskResource, @JsonProperty(value="spec") IndexIngestionSpec ingestionSchema, @JsonProperty(value="context") Map<String, Object> context, @JacksonInject AuthorizerMapper authorizerMapper, @JacksonInject ChatHandlerProvider chatHandlerProvider, @JacksonInject RowIngestionMetersFactory rowIngestionMetersFactory) {
        this(id, IndexTask.makeGroupId(ingestionSchema), taskResource, ingestionSchema.dataSchema.getDataSource(), ingestionSchema, context, authorizerMapper, chatHandlerProvider, rowIngestionMetersFactory);
    }

    public IndexTask(String id, String groupId, TaskResource resource, String dataSource, IndexIngestionSpec ingestionSchema, Map<String, Object> context, AuthorizerMapper authorizerMapper, ChatHandlerProvider chatHandlerProvider, RowIngestionMetersFactory rowIngestionMetersFactory) {
        super(IndexTask.getOrMakeId(id, TYPE, dataSource), groupId, resource, dataSource, context);
        this.ingestionSchema = ingestionSchema;
        this.authorizerMapper = authorizerMapper;
        this.chatHandlerProvider = Optional.fromNullable((Object)chatHandlerProvider);
        if (ingestionSchema.getTuningConfig().getMaxSavedParseExceptions() > 0) {
            this.determinePartitionsSavedParseExceptions = new CircularBuffer(ingestionSchema.getTuningConfig().getMaxSavedParseExceptions());
            this.buildSegmentsSavedParseExceptions = new CircularBuffer(ingestionSchema.getTuningConfig().getMaxSavedParseExceptions());
        }
        this.ingestionState = IngestionState.NOT_STARTED;
        this.determinePartitionsMeters = rowIngestionMetersFactory.createRowIngestionMeters();
        this.buildSegmentsMeters = rowIngestionMetersFactory.createRowIngestionMeters();
    }

    @Override
    public int getPriority() {
        return this.getContextValue("priority", 50);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public boolean isReady(TaskActionClient taskActionClient) throws Exception {
        Optional intervals = this.ingestionSchema.getDataSchema().getGranularitySpec().bucketIntervals();
        if (intervals.isPresent()) {
            return IndexTask.isReady(taskActionClient, (SortedSet)intervals.get());
        }
        return true;
    }

    static boolean isReady(TaskActionClient actionClient, SortedSet<Interval> intervals) throws IOException {
        for (Interval interval : intervals) {
            if (interval.toDurationMillis() != 0L) continue;
            throw new ISE("Cannot run with empty interval[%s]", new Object[]{interval});
        }
        List<TaskLock> locks = IndexTask.getTaskLocks(actionClient);
        if (locks.size() == 0) {
            try {
                Tasks.tryAcquireExclusiveLocks(actionClient, intervals);
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    @GET
    @Path(value="/unparseableEvents")
    @Produces(value={"application/json"})
    public Response getUnparseableEvents(@Context HttpServletRequest req, @QueryParam(value="full") String full) {
        IndexTaskUtils.datasourceAuthorizationCheck(req, Action.READ, this.getDataSource(), this.authorizerMapper);
        HashMap<String, List<String>> events = new HashMap<String, List<String>>();
        boolean needsDeterminePartitions = false;
        boolean needsBuildSegments = false;
        if (full != null) {
            needsDeterminePartitions = true;
            needsBuildSegments = true;
        } else {
            switch (this.ingestionState) {
                case DETERMINE_PARTITIONS: {
                    needsDeterminePartitions = true;
                    break;
                }
                case BUILD_SEGMENTS: 
                case COMPLETED: {
                    needsBuildSegments = true;
                    break;
                }
            }
        }
        if (needsDeterminePartitions) {
            events.put("determinePartitions", IndexTaskUtils.getMessagesFromSavedParseExceptions(this.determinePartitionsSavedParseExceptions));
        }
        if (needsBuildSegments) {
            events.put("buildSegments", IndexTaskUtils.getMessagesFromSavedParseExceptions(this.buildSegmentsSavedParseExceptions));
        }
        return Response.ok(events).build();
    }

    @GET
    @Path(value="/rowStats")
    @Produces(value={"application/json"})
    public Response getRowStats(@Context HttpServletRequest req, @QueryParam(value="full") String full) {
        IndexTaskUtils.datasourceAuthorizationCheck(req, Action.READ, this.getDataSource(), this.authorizerMapper);
        HashMap returnMap = new HashMap();
        HashMap<String, RowIngestionMetersTotals> totalsMap = new HashMap<String, RowIngestionMetersTotals>();
        HashMap<String, Map<String, Object>> averagesMap = new HashMap<String, Map<String, Object>>();
        boolean needsDeterminePartitions = false;
        boolean needsBuildSegments = false;
        if (full != null) {
            needsDeterminePartitions = true;
            needsBuildSegments = true;
        } else {
            switch (this.ingestionState) {
                case DETERMINE_PARTITIONS: {
                    needsDeterminePartitions = true;
                    break;
                }
                case BUILD_SEGMENTS: 
                case COMPLETED: {
                    needsBuildSegments = true;
                    break;
                }
            }
        }
        if (needsDeterminePartitions) {
            totalsMap.put("determinePartitions", this.determinePartitionsMeters.getTotals());
            averagesMap.put("determinePartitions", this.determinePartitionsMeters.getMovingAverages());
        }
        if (needsBuildSegments) {
            totalsMap.put("buildSegments", this.buildSegmentsMeters.getTotals());
            averagesMap.put("buildSegments", this.buildSegmentsMeters.getMovingAverages());
        }
        returnMap.put("totals", totalsMap);
        returnMap.put("movingAverages", averagesMap);
        return Response.ok(returnMap).build();
    }

    @JsonProperty(value="spec")
    public IndexIngestionSpec getIngestionSchema() {
        return this.ingestionSchema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskStatus run(TaskToolbox toolbox) {
        try {
            DataSchema dataSchema;
            Map<Interval, String> versions;
            if (this.chatHandlerProvider.isPresent()) {
                log.info("Found chat handler of class[%s]", new Object[]{((ChatHandlerProvider)this.chatHandlerProvider.get()).getClass().getName()});
                if (((ChatHandlerProvider)this.chatHandlerProvider.get()).get(this.getId()).isPresent()) {
                    log.warn("Chat handler is already registered. Skipping chat handler registration.", new Object[0]);
                } else {
                    ((ChatHandlerProvider)this.chatHandlerProvider.get()).register(this.getId(), (ChatHandler)this, false);
                }
            } else {
                log.warn("No chat handler detected", new Object[0]);
            }
            boolean determineIntervals = !this.ingestionSchema.getDataSchema().getGranularitySpec().bucketIntervals().isPresent();
            FirehoseFactory firehoseFactory = this.ingestionSchema.getIOConfig().getFirehoseFactory();
            this.setFirehoseFactoryToolbox(firehoseFactory, toolbox);
            File firehoseTempDir = toolbox.getFirehoseTemporaryDir();
            FileUtils.forceMkdir((File)firehoseTempDir);
            this.ingestionState = IngestionState.DETERMINE_PARTITIONS;
            IndexTuningConfig tuningConfig = this.ingestionSchema.tuningConfig;
            Integer maxRowsPerSegment = IndexTask.getValidMaxRowsPerSegment(tuningConfig);
            Long maxTotalRows = IndexTask.getValidMaxTotalRows(tuningConfig);
            ShardSpecs shardSpecs = this.determineShardSpecs(toolbox, firehoseFactory, firehoseTempDir, maxRowsPerSegment);
            if (determineIntervals) {
                TreeSet<Interval> intervals = new TreeSet<Interval>(Comparators.intervalsByStartThenEnd());
                intervals.addAll(shardSpecs.getIntervals());
                Map<Interval, TaskLock> locks = Tasks.tryAcquireExclusiveLocks(toolbox.getTaskActionClient(), intervals);
                versions = locks.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((TaskLock)entry.getValue()).getVersion()));
                dataSchema = this.ingestionSchema.getDataSchema().withGranularitySpec(this.ingestionSchema.getDataSchema().getGranularitySpec().withIntervals((List)JodaUtils.condenseIntervals(shardSpecs.getIntervals())));
            } else {
                versions = IndexTask.getTaskLocks(toolbox.getTaskActionClient()).stream().collect(Collectors.toMap(TaskLock::getInterval, TaskLock::getVersion));
                dataSchema = this.ingestionSchema.getDataSchema();
            }
            this.ingestionState = IngestionState.BUILD_SEGMENTS;
            TaskStatus taskStatus = this.generateAndPublishSegments(toolbox, dataSchema, shardSpecs, versions, firehoseFactory, firehoseTempDir, maxRowsPerSegment, maxTotalRows);
            return taskStatus;
        }
        catch (Exception e) {
            log.error((Throwable)e, "Encountered exception in %s.", new Object[]{this.ingestionState});
            this.errorMsg = Throwables.getStackTraceAsString((Throwable)e);
            toolbox.getTaskReportFileWriter().write(this.getTaskCompletionReports());
            TaskStatus taskStatus = TaskStatus.failure((String)this.getId(), (String)this.errorMsg);
            return taskStatus;
        }
        finally {
            if (this.chatHandlerProvider.isPresent()) {
                ((ChatHandlerProvider)this.chatHandlerProvider.get()).unregister(this.getId());
            }
        }
    }

    private void setFirehoseFactoryToolbox(FirehoseFactory firehoseFactory, TaskToolbox toolbox) {
        if (firehoseFactory instanceof IngestSegmentFirehoseFactory) {
            ((IngestSegmentFirehoseFactory)firehoseFactory).setTaskToolbox(toolbox);
            return;
        }
        if (firehoseFactory instanceof CombiningFirehoseFactory) {
            for (FirehoseFactory delegateFactory : ((CombiningFirehoseFactory)firehoseFactory).getDelegateFactoryList()) {
                if (delegateFactory instanceof IngestSegmentFirehoseFactory) {
                    ((IngestSegmentFirehoseFactory)delegateFactory).setTaskToolbox(toolbox);
                    continue;
                }
                if (!(delegateFactory instanceof CombiningFirehoseFactory)) continue;
                this.setFirehoseFactoryToolbox(delegateFactory, toolbox);
            }
        }
    }

    private Map<String, TaskReport> getTaskCompletionReports() {
        return TaskReport.buildTaskReports(new IngestionStatsAndErrorsTaskReport(this.getId(), new IngestionStatsAndErrorsTaskReportData(this.ingestionState, this.getTaskCompletionUnparseableEvents(), this.getTaskCompletionRowStats(), this.errorMsg)));
    }

    private Map<String, Object> getTaskCompletionUnparseableEvents() {
        HashMap<String, Object> unparseableEventsMap = new HashMap<String, Object>();
        List<String> determinePartitionsParseExceptionMessages = IndexTaskUtils.getMessagesFromSavedParseExceptions(this.determinePartitionsSavedParseExceptions);
        List<String> buildSegmentsParseExceptionMessages = IndexTaskUtils.getMessagesFromSavedParseExceptions(this.buildSegmentsSavedParseExceptions);
        if (determinePartitionsParseExceptionMessages != null || buildSegmentsParseExceptionMessages != null) {
            unparseableEventsMap.put("determinePartitions", determinePartitionsParseExceptionMessages);
            unparseableEventsMap.put("buildSegments", buildSegmentsParseExceptionMessages);
        }
        return unparseableEventsMap;
    }

    private Map<String, Object> getTaskCompletionRowStats() {
        HashMap<String, Object> metrics = new HashMap<String, Object>();
        metrics.put("determinePartitions", this.determinePartitionsMeters.getTotals());
        metrics.put("buildSegments", this.buildSegmentsMeters.getTotals());
        return metrics;
    }

    private static String findVersion(Map<Interval, String> versions, Interval interval) {
        return versions.entrySet().stream().filter(entry -> ((Interval)entry.getKey()).contains((ReadableInterval)interval)).map(Map.Entry::getValue).findFirst().orElseThrow(() -> new ISE("Cannot find a version for interval[%s]", new Object[]{interval}));
    }

    private static boolean isGuaranteedRollup(IndexIOConfig ioConfig, IndexTuningConfig tuningConfig) {
        Preconditions.checkState((!tuningConfig.isForceGuaranteedRollup() || !ioConfig.isAppendToExisting() ? 1 : 0) != 0, (Object)"Perfect rollup cannot be guaranteed when appending to existing dataSources");
        return tuningConfig.isForceGuaranteedRollup();
    }

    private static boolean isExtendableShardSpecs(IndexIOConfig ioConfig, IndexTuningConfig tuningConfig) {
        return tuningConfig.isForceExtendableShardSpecs() || ioConfig.isAppendToExisting();
    }

    private ShardSpecs determineShardSpecs(TaskToolbox toolbox, FirehoseFactory firehoseFactory, File firehoseTempDir, @Nullable Integer maxRowsPerSegment) throws IOException {
        boolean determineNumPartitions;
        ObjectMapper jsonMapper = toolbox.getObjectMapper();
        IndexTuningConfig tuningConfig = this.ingestionSchema.getTuningConfig();
        IndexIOConfig ioConfig = this.ingestionSchema.getIOConfig();
        GranularitySpec granularitySpec = this.ingestionSchema.getDataSchema().getGranularitySpec();
        boolean determineIntervals = !granularitySpec.bucketIntervals().isPresent();
        boolean bl = determineNumPartitions = tuningConfig.getNumShards() == null && IndexTask.isGuaranteedRollup(ioConfig, tuningConfig);
        if (!determineNumPartitions && !determineIntervals) {
            log.info("Skipping determine partition scan", new Object[0]);
            return IndexTask.createShardSpecWithoutInputScan(jsonMapper, granularitySpec, ioConfig, tuningConfig);
        }
        return this.createShardSpecsFromInput(jsonMapper, this.ingestionSchema, firehoseFactory, firehoseTempDir, granularitySpec, tuningConfig, determineIntervals, determineNumPartitions, maxRowsPerSegment);
    }

    private static ShardSpecs createShardSpecWithoutInputScan(ObjectMapper jsonMapper, GranularitySpec granularitySpec, IndexIOConfig ioConfig, IndexTuningConfig tuningConfig) {
        HashMap<Interval, List<ShardSpec>> shardSpecs = new HashMap<Interval, List<ShardSpec>>();
        SortedSet intervals = (SortedSet)granularitySpec.bucketIntervals().get();
        if (IndexTask.isGuaranteedRollup(ioConfig, tuningConfig)) {
            int numShards = tuningConfig.getNumShards() == null ? 1 : tuningConfig.getNumShards();
            BiFunction<Integer, Integer, ShardSpec> shardSpecCreateFn = IndexTask.getShardSpecCreateFunction(numShards, tuningConfig.getPartitionDimensions(), jsonMapper);
            for (Interval interval : intervals) {
                List intervalShardSpecs = IntStream.range(0, numShards).mapToObj(shardId -> (ShardSpec)shardSpecCreateFn.apply(shardId, numShards)).collect(Collectors.toList());
                shardSpecs.put(interval, intervalShardSpecs);
            }
        } else {
            for (Interval interval : intervals) {
                shardSpecs.put(interval, (List<ShardSpec>)ImmutableList.of());
            }
        }
        return new ShardSpecs(shardSpecs);
    }

    private ShardSpecs createShardSpecsFromInput(ObjectMapper jsonMapper, IndexIngestionSpec ingestionSchema, FirehoseFactory firehoseFactory, File firehoseTempDir, GranularitySpec granularitySpec, IndexTuningConfig tuningConfig, boolean determineIntervals, boolean determineNumPartitions, @Nullable Integer maxRowsPerSegment) throws IOException {
        log.info("Determining intervals and shardSpecs", new Object[0]);
        long determineShardSpecsStartMillis = System.currentTimeMillis();
        Map<Interval, Optional<HyperLogLogCollector>> hllCollectors = this.collectIntervalsAndShardSpecs(jsonMapper, ingestionSchema, firehoseFactory, firehoseTempDir, granularitySpec, determineIntervals, determineNumPartitions);
        HashMap<Interval, List<ShardSpec>> intervalToShardSpecs = new HashMap<Interval, List<ShardSpec>>();
        int defaultNumShards = tuningConfig.getNumShards() == null ? 1 : tuningConfig.getNumShards();
        for (Map.Entry<Interval, Optional<HyperLogLogCollector>> entry : hllCollectors.entrySet()) {
            int numShards;
            Interval interval = entry.getKey();
            HyperLogLogCollector collector = (HyperLogLogCollector)entry.getValue().orNull();
            if (determineNumPartitions) {
                long numRows = ((HyperLogLogCollector)Preconditions.checkNotNull((Object)collector, (Object)"HLL collector")).estimateCardinalityRound();
                numShards = (int)Math.ceil((double)numRows / (double)((Integer)Preconditions.checkNotNull((Object)maxRowsPerSegment, (Object)"maxRowsPerSegment")).intValue());
                log.info("Estimated [%,d] rows of data for interval [%s], creating [%,d] shards", new Object[]{numRows, interval, numShards});
            } else {
                numShards = defaultNumShards;
                log.info("Creating [%,d] shards for interval [%s]", new Object[]{numShards, interval});
            }
            if (IndexTask.isGuaranteedRollup(ingestionSchema.getIOConfig(), ingestionSchema.getTuningConfig())) {
                BiFunction<Integer, Integer, ShardSpec> shardSpecCreateFn = IndexTask.getShardSpecCreateFunction(numShards, tuningConfig.getPartitionDimensions(), jsonMapper);
                List intervalShardSpecs = IntStream.range(0, numShards).mapToObj(shardId -> (ShardSpec)shardSpecCreateFn.apply(shardId, numShards)).collect(Collectors.toList());
                intervalToShardSpecs.put(interval, intervalShardSpecs);
                continue;
            }
            intervalToShardSpecs.put(interval, (List<ShardSpec>)ImmutableList.of());
        }
        log.info("Found intervals and shardSpecs in %,dms", new Object[]{System.currentTimeMillis() - determineShardSpecsStartMillis});
        return new ShardSpecs(intervalToShardSpecs);
    }

    /*
     * Exception decompiling
     */
    private Map<Interval, Optional<HyperLogLogCollector>> collectIntervalsAndShardSpecs(ObjectMapper jsonMapper, IndexIngestionSpec ingestionSchema, FirehoseFactory firehoseFactory, File firehoseTempDir, GranularitySpec granularitySpec, boolean determineIntervals, boolean determineNumPartitions) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static BiFunction<Integer, Integer, ShardSpec> getShardSpecCreateFunction(Integer numShards, List<String> partitionDimensions, ObjectMapper jsonMapper) {
        Preconditions.checkNotNull((Object)numShards, (Object)"numShards");
        if (numShards == 1) {
            return (shardId, totalNumShards) -> NoneShardSpec.instance();
        }
        return (shardId, totalNumShards) -> new HashBasedNumberedShardSpec(shardId.intValue(), totalNumShards.intValue(), partitionDimensions, jsonMapper);
    }

    /*
     * Exception decompiling
     */
    private TaskStatus generateAndPublishSegments(TaskToolbox toolbox, DataSchema dataSchema, ShardSpecs shardSpecs, Map<Interval, String> versions, FirehoseFactory firehoseFactory, File firehoseTempDir, @Nullable Integer maxRowsPerSegment, @Nullable Long maxTotalRows) throws IOException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Integer getValidMaxRowsPerSegment(IndexTuningConfig tuningConfig) {
        Integer numShards = tuningConfig.numShards;
        Integer maxRowsPerSegment = tuningConfig.maxRowsPerSegment;
        if (numShards == null || numShards == -1) {
            return maxRowsPerSegment == null || maxRowsPerSegment.equals(-1) ? 5000000 : maxRowsPerSegment;
        }
        return null;
    }

    public static Long getValidMaxTotalRows(IndexTuningConfig tuningConfig) {
        Integer numShards = tuningConfig.numShards;
        Long maxTotalRows = tuningConfig.maxTotalRows;
        if (numShards == null || numShards == -1) {
            return maxTotalRows == null ? 20000000L : maxTotalRows;
        }
        return null;
    }

    private void handleParseException(ParseException e) {
        if (e.isFromPartiallyValidRow()) {
            this.buildSegmentsMeters.incrementProcessedWithError();
        } else {
            this.buildSegmentsMeters.incrementUnparseable();
        }
        if (this.ingestionSchema.tuningConfig.isLogParseExceptions()) {
            log.error((Throwable)e, "Encountered parse exception:", new Object[0]);
        }
        if (this.buildSegmentsSavedParseExceptions != null) {
            this.buildSegmentsSavedParseExceptions.add((Object)e);
        }
        if (this.buildSegmentsMeters.getUnparseable() + this.buildSegmentsMeters.getProcessedWithError() > (long)this.ingestionSchema.tuningConfig.getMaxParseExceptions()) {
            log.error("Max parse exceptions exceeded, terminating task...", new Object[0]);
            throw new RuntimeException("Max parse exceptions exceeded, terminating task...", e);
        }
    }

    private static SegmentsAndMetadata awaitPublish(ListenableFuture<SegmentsAndMetadata> publishFuture, long publishTimeout) throws ExecutionException, InterruptedException, TimeoutException {
        if (publishTimeout == 0L) {
            return (SegmentsAndMetadata)publishFuture.get();
        }
        return (SegmentsAndMetadata)publishFuture.get(publishTimeout, TimeUnit.MILLISECONDS);
    }

    private static Appenderator newAppenderator(FireDepartmentMetrics metrics, TaskToolbox toolbox, DataSchema dataSchema, IndexTuningConfig tuningConfig) {
        return Appenderators.createOffline((DataSchema)dataSchema, (AppenderatorConfig)tuningConfig.withBasePersistDirectory(toolbox.getPersistDir()), (FireDepartmentMetrics)metrics, (DataSegmentPusher)toolbox.getSegmentPusher(), (ObjectMapper)toolbox.getObjectMapper(), (IndexIO)toolbox.getIndexIO(), (IndexMerger)toolbox.getIndexMergerV9());
    }

    private static BatchAppenderatorDriver newDriver(Appenderator appenderator, TaskToolbox toolbox, SegmentAllocator segmentAllocator) {
        return new BatchAppenderatorDriver(appenderator, segmentAllocator, (UsedSegmentChecker)new ActionBasedUsedSegmentChecker(toolbox.getTaskActionClient()), toolbox.getDataSegmentKiller());
    }

    private static /* synthetic */ SegmentPublishResult lambda$generateAndPublishSegments$11(TaskToolbox toolbox, Set segments, Object commitMetadata) throws IOException {
        SegmentTransactionalInsertAction action = new SegmentTransactionalInsertAction(segments);
        return toolbox.getTaskActionClient().submit(action);
    }

    private /* synthetic */ SegmentIdWithShardSpec lambda$generateAndPublishSegments$10(GranularitySpec granularitySpec, ShardSpecs shardSpecs, Map counters, Map versions, InputRow row, String sequenceName, String previousSegmentId, boolean skipSegmentLineageCheck) throws IOException {
        DateTime timestamp = row.getTimestamp();
        Optional maybeInterval = granularitySpec.bucketInterval(timestamp);
        if (!maybeInterval.isPresent()) {
            throw new ISE("Could not find interval for timestamp [%s]", new Object[]{timestamp});
        }
        Interval interval = (Interval)maybeInterval.get();
        if (!shardSpecs.getMap().containsKey(interval)) {
            throw new ISE("Could not find shardSpec for interval[%s]", new Object[]{interval});
        }
        int partitionNum = counters.computeIfAbsent(interval, x -> new AtomicInteger()).getAndIncrement();
        return new SegmentIdWithShardSpec(this.getDataSource(), interval, IndexTask.findVersion(versions, interval), (ShardSpec)new NumberedShardSpec(partitionNum, 0));
    }

    private static /* synthetic */ TaskAction lambda$generateAndPublishSegments$8(DataSchema schema, InputRow row, String sequenceName, String previousSegmentId, boolean skipSegmentLineageCheck) {
        return new SegmentAllocateAction(schema.getDataSource(), row.getTimestamp(), schema.getGranularitySpec().getQueryGranularity(), schema.getGranularitySpec().getSegmentGranularity(), sequenceName, previousSegmentId, skipSegmentLineageCheck);
    }

    private static /* synthetic */ SegmentIdWithShardSpec lambda$generateAndPublishSegments$7(Map lookup, InputRow row, String sequenceName, String previousSegmentId, boolean skipSegmentLineageCheck) throws IOException {
        return (SegmentIdWithShardSpec)lookup.get(sequenceName);
    }

    @JsonTypeName(value="index")
    public static class IndexTuningConfig
    implements TuningConfig,
    AppenderatorConfig {
        static final int DEFAULT_MAX_ROWS_PER_SEGMENT = 5000000;
        static final int DEFAULT_MAX_TOTAL_ROWS = 20000000;
        private static final IndexSpec DEFAULT_INDEX_SPEC = new IndexSpec();
        private static final int DEFAULT_MAX_PENDING_PERSISTS = 0;
        private static final boolean DEFAULT_FORCE_EXTENDABLE_SHARD_SPECS = false;
        private static final boolean DEFAULT_GUARANTEE_ROLLUP = false;
        private static final boolean DEFAULT_REPORT_PARSE_EXCEPTIONS = false;
        private static final long DEFAULT_PUSH_TIMEOUT = 0L;
        @Nullable
        private final Integer maxRowsPerSegment;
        private final int maxRowsInMemory;
        private final long maxBytesInMemory;
        @Nullable
        private final Long maxTotalRows;
        @Nullable
        private final Integer numShards;
        private final List<String> partitionDimensions;
        private final IndexSpec indexSpec;
        private final File basePersistDirectory;
        private final int maxPendingPersists;
        private final boolean forceExtendableShardSpecs;
        private final boolean forceGuaranteedRollup;
        private final boolean reportParseExceptions;
        private final long pushTimeout;
        private final boolean logParseExceptions;
        private final int maxParseExceptions;
        private final int maxSavedParseExceptions;
        @Nullable
        private final SegmentWriteOutMediumFactory segmentWriteOutMediumFactory;

        public static IndexTuningConfig createDefault() {
            return new IndexTuningConfig();
        }

        @JsonCreator
        public IndexTuningConfig(@JsonProperty(value="targetPartitionSize") @Deprecated @Nullable Integer targetPartitionSize, @JsonProperty(value="maxRowsPerSegment") @Nullable Integer maxRowsPerSegment, @JsonProperty(value="maxRowsInMemory") @Nullable Integer maxRowsInMemory, @JsonProperty(value="maxBytesInMemory") @Nullable Long maxBytesInMemory, @JsonProperty(value="maxTotalRows") @Nullable Long maxTotalRows, @JsonProperty(value="rowFlushBoundary") @Nullable Integer rowFlushBoundary_forBackCompatibility, @JsonProperty(value="numShards") @Nullable Integer numShards, @JsonProperty(value="partitionDimensions") @Nullable List<String> partitionDimensions, @JsonProperty(value="indexSpec") @Nullable IndexSpec indexSpec, @JsonProperty(value="maxPendingPersists") @Nullable Integer maxPendingPersists, @JsonProperty(value="buildV9Directly") @Nullable Boolean buildV9Directly, @JsonProperty(value="forceExtendableShardSpecs") @Nullable Boolean forceExtendableShardSpecs, @JsonProperty(value="forceGuaranteedRollup") @Nullable Boolean forceGuaranteedRollup, @Deprecated @JsonProperty(value="reportParseExceptions") @Nullable Boolean reportParseExceptions, @JsonProperty(value="publishTimeout") @Nullable Long publishTimeout, @JsonProperty(value="pushTimeout") @Nullable Long pushTimeout, @JsonProperty(value="segmentWriteOutMediumFactory") @Nullable SegmentWriteOutMediumFactory segmentWriteOutMediumFactory, @JsonProperty(value="logParseExceptions") @Nullable Boolean logParseExceptions, @JsonProperty(value="maxParseExceptions") @Nullable Integer maxParseExceptions, @JsonProperty(value="maxSavedParseExceptions") @Nullable Integer maxSavedParseExceptions) {
            this(maxRowsPerSegment == null ? targetPartitionSize : maxRowsPerSegment, maxRowsInMemory != null ? maxRowsInMemory : rowFlushBoundary_forBackCompatibility, maxBytesInMemory != null ? maxBytesInMemory : 0L, maxTotalRows, numShards, partitionDimensions, indexSpec, maxPendingPersists, forceExtendableShardSpecs, forceGuaranteedRollup, reportParseExceptions, pushTimeout != null ? pushTimeout : publishTimeout, null, segmentWriteOutMediumFactory, logParseExceptions, maxParseExceptions, maxSavedParseExceptions);
            Preconditions.checkArgument((targetPartitionSize == null || maxRowsPerSegment == null ? 1 : 0) != 0, (Object)"Can't use targetPartitionSize and maxRowsPerSegment together");
        }

        private IndexTuningConfig() {
            this(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
        }

        private IndexTuningConfig(@Nullable Integer maxRowsPerSegment, @Nullable Integer maxRowsInMemory, @Nullable Long maxBytesInMemory, @Nullable Long maxTotalRows, @Nullable Integer numShards, @Nullable List<String> partitionDimensions, @Nullable IndexSpec indexSpec, @Nullable Integer maxPendingPersists, @Nullable Boolean forceExtendableShardSpecs, @Nullable Boolean forceGuaranteedRollup, @Nullable Boolean reportParseExceptions, @Nullable Long pushTimeout, @Nullable File basePersistDirectory, @Nullable SegmentWriteOutMediumFactory segmentWriteOutMediumFactory, @Nullable Boolean logParseExceptions, @Nullable Integer maxParseExceptions, @Nullable Integer maxSavedParseExceptions) {
            Preconditions.checkArgument((maxRowsPerSegment == null || maxRowsPerSegment.equals(-1) || numShards == null || numShards.equals(-1) ? 1 : 0) != 0, (Object)"maxRowsPerSegment and numShards cannot both be set");
            this.maxRowsPerSegment = maxRowsPerSegment != null && maxRowsPerSegment == -1 ? null : maxRowsPerSegment;
            this.maxRowsInMemory = maxRowsInMemory == null ? 1000000 : maxRowsInMemory;
            this.maxBytesInMemory = maxBytesInMemory == null ? 0L : maxBytesInMemory;
            this.maxTotalRows = maxTotalRows;
            this.numShards = numShards == null || numShards.equals(-1) ? null : numShards;
            this.partitionDimensions = partitionDimensions == null ? Collections.emptyList() : partitionDimensions;
            this.indexSpec = indexSpec == null ? DEFAULT_INDEX_SPEC : indexSpec;
            this.maxPendingPersists = maxPendingPersists == null ? 0 : maxPendingPersists;
            this.forceExtendableShardSpecs = forceExtendableShardSpecs == null ? false : forceExtendableShardSpecs;
            this.forceGuaranteedRollup = forceGuaranteedRollup == null ? false : forceGuaranteedRollup;
            this.reportParseExceptions = reportParseExceptions == null ? false : reportParseExceptions;
            this.pushTimeout = pushTimeout == null ? 0L : pushTimeout;
            this.basePersistDirectory = basePersistDirectory;
            this.segmentWriteOutMediumFactory = segmentWriteOutMediumFactory;
            if (this.reportParseExceptions) {
                this.maxParseExceptions = 0;
                this.maxSavedParseExceptions = maxSavedParseExceptions == null ? 0 : Math.min(1, maxSavedParseExceptions);
            } else {
                this.maxParseExceptions = maxParseExceptions == null ? Integer.MAX_VALUE : maxParseExceptions;
                this.maxSavedParseExceptions = maxSavedParseExceptions == null ? 0 : maxSavedParseExceptions;
            }
            this.logParseExceptions = logParseExceptions == null ? false : logParseExceptions;
        }

        public IndexTuningConfig withBasePersistDirectory(File dir) {
            return new IndexTuningConfig(this.maxRowsPerSegment, this.maxRowsInMemory, this.maxBytesInMemory, this.maxTotalRows, this.numShards, this.partitionDimensions, this.indexSpec, this.maxPendingPersists, this.forceExtendableShardSpecs, this.forceGuaranteedRollup, this.reportParseExceptions, this.pushTimeout, dir, this.segmentWriteOutMediumFactory, this.logParseExceptions, this.maxParseExceptions, this.maxSavedParseExceptions);
        }

        public IndexTuningConfig withMaxRowsPerSegment(int maxRowsPerSegment) {
            return new IndexTuningConfig(maxRowsPerSegment, this.maxRowsInMemory, this.maxBytesInMemory, this.maxTotalRows, this.numShards, this.partitionDimensions, this.indexSpec, this.maxPendingPersists, this.forceExtendableShardSpecs, this.forceGuaranteedRollup, this.reportParseExceptions, this.pushTimeout, this.basePersistDirectory, this.segmentWriteOutMediumFactory, this.logParseExceptions, this.maxParseExceptions, this.maxSavedParseExceptions);
        }

        @Nullable
        @JsonProperty
        public Integer getMaxRowsPerSegment() {
            return this.maxRowsPerSegment;
        }

        @JsonProperty
        public int getMaxRowsInMemory() {
            return this.maxRowsInMemory;
        }

        @JsonProperty
        public long getMaxBytesInMemory() {
            return this.maxBytesInMemory;
        }

        @JsonProperty
        @Nullable
        public Long getMaxTotalRows() {
            return this.maxTotalRows;
        }

        @JsonProperty
        public Integer getNumShards() {
            return this.numShards;
        }

        @JsonProperty
        public List<String> getPartitionDimensions() {
            return this.partitionDimensions;
        }

        @JsonProperty
        public IndexSpec getIndexSpec() {
            return this.indexSpec;
        }

        public File getBasePersistDirectory() {
            return this.basePersistDirectory;
        }

        @JsonProperty
        public int getMaxPendingPersists() {
            return this.maxPendingPersists;
        }

        @Deprecated
        @JsonProperty
        public boolean isBuildV9Directly() {
            return true;
        }

        @JsonProperty
        public boolean isForceExtendableShardSpecs() {
            return this.forceExtendableShardSpecs;
        }

        @JsonProperty
        public boolean isForceGuaranteedRollup() {
            return this.forceGuaranteedRollup;
        }

        @JsonProperty
        public boolean isReportParseExceptions() {
            return this.reportParseExceptions;
        }

        @JsonProperty
        public long getPushTimeout() {
            return this.pushTimeout;
        }

        @JsonProperty
        public boolean isLogParseExceptions() {
            return this.logParseExceptions;
        }

        @JsonProperty
        public int getMaxParseExceptions() {
            return this.maxParseExceptions;
        }

        @JsonProperty
        public int getMaxSavedParseExceptions() {
            return this.maxSavedParseExceptions;
        }

        public Period getIntermediatePersistPeriod() {
            return new Period(Integer.MAX_VALUE);
        }

        @Nullable
        @JsonProperty
        public SegmentWriteOutMediumFactory getSegmentWriteOutMediumFactory() {
            return this.segmentWriteOutMediumFactory;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IndexTuningConfig that = (IndexTuningConfig)o;
            return this.maxRowsInMemory == that.maxRowsInMemory && Objects.equals(this.maxTotalRows, that.maxTotalRows) && this.maxPendingPersists == that.maxPendingPersists && this.forceExtendableShardSpecs == that.forceExtendableShardSpecs && this.forceGuaranteedRollup == that.forceGuaranteedRollup && this.reportParseExceptions == that.reportParseExceptions && this.pushTimeout == that.pushTimeout && Objects.equals(this.maxRowsPerSegment, that.maxRowsPerSegment) && Objects.equals(this.numShards, that.numShards) && Objects.equals(this.indexSpec, that.indexSpec) && Objects.equals(this.basePersistDirectory, that.basePersistDirectory) && Objects.equals(this.segmentWriteOutMediumFactory, that.segmentWriteOutMediumFactory) && this.logParseExceptions == that.logParseExceptions && this.maxParseExceptions == that.maxParseExceptions && this.maxSavedParseExceptions == that.maxSavedParseExceptions;
        }

        public int hashCode() {
            return Objects.hash(this.maxRowsPerSegment, this.maxRowsInMemory, this.maxTotalRows, this.numShards, this.indexSpec, this.basePersistDirectory, this.maxPendingPersists, this.forceExtendableShardSpecs, this.forceGuaranteedRollup, this.reportParseExceptions, this.pushTimeout, this.segmentWriteOutMediumFactory, this.logParseExceptions, this.maxParseExceptions, this.maxSavedParseExceptions);
        }

        public String toString() {
            return "IndexTuningConfig{maxRowsPerSegment=" + this.maxRowsPerSegment + ", maxRowsInMemory=" + this.maxRowsInMemory + ", maxBytesInMemory=" + this.maxBytesInMemory + ", maxTotalRows=" + this.maxTotalRows + ", numShards=" + this.numShards + ", indexSpec=" + this.indexSpec + ", basePersistDirectory=" + this.basePersistDirectory + ", maxPendingPersists=" + this.maxPendingPersists + ", forceExtendableShardSpecs=" + this.forceExtendableShardSpecs + ", forceGuaranteedRollup=" + this.forceGuaranteedRollup + ", reportParseExceptions=" + this.reportParseExceptions + ", pushTimeout=" + this.pushTimeout + ", logParseExceptions=" + this.logParseExceptions + ", maxParseExceptions=" + this.maxParseExceptions + ", maxSavedParseExceptions=" + this.maxSavedParseExceptions + ", segmentWriteOutMediumFactory=" + this.segmentWriteOutMediumFactory + '}';
        }
    }

    @JsonTypeName(value="index")
    public static class IndexIOConfig
    implements IOConfig {
        private static final boolean DEFAULT_APPEND_TO_EXISTING = false;
        private final FirehoseFactory firehoseFactory;
        private final boolean appendToExisting;

        @JsonCreator
        public IndexIOConfig(@JsonProperty(value="firehose") FirehoseFactory firehoseFactory, @JsonProperty(value="appendToExisting") @Nullable Boolean appendToExisting) {
            this.firehoseFactory = firehoseFactory;
            this.appendToExisting = appendToExisting == null ? false : appendToExisting;
        }

        @JsonProperty(value="firehose")
        public FirehoseFactory getFirehoseFactory() {
            return this.firehoseFactory;
        }

        @JsonProperty(value="appendToExisting")
        public boolean isAppendToExisting() {
            return this.appendToExisting;
        }
    }

    public static class IndexIngestionSpec
    extends IngestionSpec<IndexIOConfig, IndexTuningConfig> {
        private final DataSchema dataSchema;
        private final IndexIOConfig ioConfig;
        private final IndexTuningConfig tuningConfig;

        @JsonCreator
        public IndexIngestionSpec(@JsonProperty(value="dataSchema") DataSchema dataSchema, @JsonProperty(value="ioConfig") IndexIOConfig ioConfig, @JsonProperty(value="tuningConfig") IndexTuningConfig tuningConfig) {
            super(dataSchema, (IOConfig)ioConfig, (TuningConfig)tuningConfig);
            this.dataSchema = dataSchema;
            this.ioConfig = ioConfig;
            this.tuningConfig = tuningConfig == null ? new IndexTuningConfig() : tuningConfig;
        }

        @JsonProperty(value="dataSchema")
        public DataSchema getDataSchema() {
            return this.dataSchema;
        }

        @JsonProperty(value="ioConfig")
        public IndexIOConfig getIOConfig() {
            return this.ioConfig;
        }

        @JsonProperty(value="tuningConfig")
        public IndexTuningConfig getTuningConfig() {
            return this.tuningConfig;
        }
    }

    static class ShardSpecs {
        private final Map<Interval, List<ShardSpec>> map;

        ShardSpecs(Map<Interval, List<ShardSpec>> map) {
            this.map = map;
        }

        Map<Interval, List<ShardSpec>> getMap() {
            return this.map;
        }

        Set<Interval> getIntervals() {
            return this.map.keySet();
        }

        ShardSpec getShardSpec(Interval interval, InputRow row) {
            List<ShardSpec> shardSpecs = this.map.get(interval);
            if (shardSpecs == null || shardSpecs.isEmpty()) {
                throw new ISE("Failed to get shardSpec for interval[%s]", new Object[]{interval});
            }
            return shardSpecs.get(0).getLookup(shardSpecs).getShardSpec(row.getTimestampFromEpoch(), row);
        }
    }
}

