/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.DoubleDimensionSchema;
import org.apache.druid.data.input.impl.FloatDimensionSchema;
import org.apache.druid.data.input.impl.LongDimensionSchema;
import org.apache.druid.data.input.impl.NoopInputRowParser;
import org.apache.druid.data.input.impl.ParseSpec;
import org.apache.druid.data.input.impl.StringDimensionSchema;
import org.apache.druid.data.input.impl.TimeAndDimsParseSpec;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.actions.SegmentListUsedAction;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.common.stats.RowIngestionMetersFactory;
import org.apache.druid.indexing.common.task.AbstractTask;
import org.apache.druid.indexing.common.task.IndexTask;
import org.apache.druid.indexing.common.task.TaskResource;
import org.apache.druid.indexing.firehose.IngestSegmentFirehoseFactory;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.JodaUtils;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.granularity.GranularityType;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.segment.DimensionHandler;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.column.ColumnHolder;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.segment.indexing.granularity.GranularitySpec;
import org.apache.druid.segment.indexing.granularity.UniformGranularitySpec;
import org.apache.druid.segment.loading.SegmentLoadingException;
import org.apache.druid.segment.realtime.firehose.ChatHandlerProvider;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.TimelineObjectHolder;
import org.apache.druid.timeline.VersionedIntervalTimeline;
import org.apache.druid.timeline.partition.PartitionChunk;
import org.apache.druid.timeline.partition.PartitionHolder;
import org.joda.time.Interval;
import org.joda.time.Period;

public class CompactionTask
extends AbstractTask {
    private static final Logger log = new Logger(CompactionTask.class);
    private static final String TYPE = "compact";
    private final Interval interval;
    private final List<DataSegment> segments;
    @Nullable
    private final DimensionsSpec dimensionsSpec;
    @Nullable
    private final AggregatorFactory[] metricsSpec;
    @Deprecated
    @Nullable
    private final Boolean keepSegmentGranularity;
    private final Granularity segmentGranularity;
    @Nullable
    private final Long targetCompactionSizeBytes;
    @Nullable
    private final IndexTask.IndexTuningConfig tuningConfig;
    private final ObjectMapper jsonMapper;
    @JsonIgnore
    private final SegmentProvider segmentProvider;
    @JsonIgnore
    private final PartitionConfigurationManager partitionConfigurationManager;
    @JsonIgnore
    private final AuthorizerMapper authorizerMapper;
    @JsonIgnore
    private final ChatHandlerProvider chatHandlerProvider;
    @JsonIgnore
    private final RowIngestionMetersFactory rowIngestionMetersFactory;
    @JsonIgnore
    private List<IndexTask> indexTaskSpecs;

    @JsonCreator
    public CompactionTask(@JsonProperty(value="id") String id, @JsonProperty(value="resource") TaskResource taskResource, @JsonProperty(value="dataSource") String dataSource, @Nullable @JsonProperty(value="interval") Interval interval, @Nullable @JsonProperty(value="segments") List<DataSegment> segments, @Nullable @JsonProperty(value="dimensions") DimensionsSpec dimensions, @Nullable @JsonProperty(value="dimensionsSpec") DimensionsSpec dimensionsSpec, @Nullable @JsonProperty(value="metricsSpec") AggregatorFactory[] metricsSpec, @Nullable @JsonProperty(value="keepSegmentGranularity") @Deprecated Boolean keepSegmentGranularity, @Nullable @JsonProperty(value="segmentGranularity") Granularity segmentGranularity, @Nullable @JsonProperty(value="targetCompactionSizeBytes") Long targetCompactionSizeBytes, @Nullable @JsonProperty(value="tuningConfig") IndexTask.IndexTuningConfig tuningConfig, @Nullable @JsonProperty(value="context") Map<String, Object> context, @JacksonInject ObjectMapper jsonMapper, @JacksonInject AuthorizerMapper authorizerMapper, @JacksonInject ChatHandlerProvider chatHandlerProvider, @JacksonInject RowIngestionMetersFactory rowIngestionMetersFactory) {
        super(CompactionTask.getOrMakeId(id, TYPE, dataSource), null, taskResource, dataSource, context);
        Preconditions.checkArgument((interval != null || segments != null ? 1 : 0) != 0, (Object)"interval or segments should be specified");
        Preconditions.checkArgument((interval == null || segments == null ? 1 : 0) != 0, (Object)"one of interval and segments should be null");
        if (interval != null && interval.toDurationMillis() == 0L) {
            throw new IAE("Interval[%s] is empty, must specify a nonempty interval", new Object[]{interval});
        }
        if (keepSegmentGranularity != null && keepSegmentGranularity.booleanValue() && segmentGranularity != null) {
            throw new IAE("keepSegmentGranularity and segmentGranularity can't be used together", new Object[0]);
        }
        if (keepSegmentGranularity != null) {
            log.warn("keepSegmentGranularity is deprecated. Set a proper segmentGranularity instead", new Object[0]);
        }
        this.interval = interval;
        this.segments = segments;
        this.dimensionsSpec = dimensionsSpec == null ? dimensions : dimensionsSpec;
        this.metricsSpec = metricsSpec;
        this.keepSegmentGranularity = keepSegmentGranularity;
        this.segmentGranularity = segmentGranularity;
        this.targetCompactionSizeBytes = targetCompactionSizeBytes;
        this.tuningConfig = tuningConfig;
        this.jsonMapper = jsonMapper;
        this.segmentProvider = segments == null ? new SegmentProvider(dataSource, interval) : new SegmentProvider(segments);
        this.partitionConfigurationManager = new PartitionConfigurationManager(targetCompactionSizeBytes, tuningConfig);
        this.authorizerMapper = authorizerMapper;
        this.chatHandlerProvider = chatHandlerProvider;
        this.rowIngestionMetersFactory = rowIngestionMetersFactory;
    }

    @JsonProperty
    public Interval getInterval() {
        return this.interval;
    }

    @JsonProperty
    public List<DataSegment> getSegments() {
        return this.segments;
    }

    @JsonProperty
    public DimensionsSpec getDimensionsSpec() {
        return this.dimensionsSpec;
    }

    @JsonProperty
    public AggregatorFactory[] getMetricsSpec() {
        return this.metricsSpec;
    }

    @JsonProperty
    @Deprecated
    @Nullable
    public Boolean isKeepSegmentGranularity() {
        return this.keepSegmentGranularity;
    }

    @JsonProperty
    public Granularity getSegmentGranularity() {
        return this.segmentGranularity;
    }

    @Nullable
    @JsonProperty
    public Long getTargetCompactionSizeBytes() {
        return this.targetCompactionSizeBytes;
    }

    @Nullable
    @JsonProperty
    public IndexTask.IndexTuningConfig getTuningConfig() {
        return this.tuningConfig;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public int getPriority() {
        return this.getContextValue("priority", 25);
    }

    @VisibleForTesting
    SegmentProvider getSegmentProvider() {
        return this.segmentProvider;
    }

    @Override
    public boolean isReady(TaskActionClient taskActionClient) throws Exception {
        TreeSet<Interval> intervals = new TreeSet<Interval>(Comparators.intervalsByStartThenEnd());
        intervals.add(this.segmentProvider.interval);
        return IndexTask.isReady(taskActionClient, intervals);
    }

    @Override
    public TaskStatus run(TaskToolbox toolbox) throws Exception {
        if (this.indexTaskSpecs == null) {
            this.indexTaskSpecs = CompactionTask.createIngestionSchema(toolbox, this.segmentProvider, this.partitionConfigurationManager, this.dimensionsSpec, this.metricsSpec, this.keepSegmentGranularity, this.segmentGranularity, this.jsonMapper).stream().map(spec -> new IndexTask(this.getId(), this.getGroupId(), this.getTaskResource(), this.getDataSource(), (IndexTask.IndexIngestionSpec)((Object)spec), this.getContext(), this.authorizerMapper, this.chatHandlerProvider, this.rowIngestionMetersFactory)).collect(Collectors.toList());
        }
        if (this.indexTaskSpecs.isEmpty()) {
            log.warn("Interval[%s] has no segments, nothing to do.", new Object[]{this.interval});
            return TaskStatus.failure((String)this.getId());
        }
        int totalNumSpecs = this.indexTaskSpecs.size();
        log.info("Generated [%d] compaction task specs", new Object[]{totalNumSpecs});
        int failCnt = 0;
        for (IndexTask eachSpec : this.indexTaskSpecs) {
            String json = this.jsonMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)eachSpec);
            log.info("Running indexSpec: " + json, new Object[0]);
            try {
                TaskStatus eachResult = eachSpec.run(toolbox);
                if (eachResult.isSuccess()) continue;
                ++failCnt;
                log.warn("Failed to run indexSpec: [%s].\nTrying the next indexSpec.", new Object[]{json});
            }
            catch (Exception e) {
                ++failCnt;
                log.warn((Throwable)e, "Failed to run indexSpec: [%s].\nTrying the next indexSpec.", new Object[]{json});
            }
        }
        log.info("Run [%d] specs, [%d] succeeded, [%d] failed", new Object[]{totalNumSpecs, totalNumSpecs - failCnt, failCnt});
        return failCnt == 0 ? TaskStatus.success((String)this.getId()) : TaskStatus.failure((String)this.getId());
    }

    @VisibleForTesting
    static List<IndexTask.IndexIngestionSpec> createIngestionSchema(TaskToolbox toolbox, SegmentProvider segmentProvider, PartitionConfigurationManager partitionConfigurationManager, @Nullable DimensionsSpec dimensionsSpec, @Nullable AggregatorFactory[] metricsSpec, @Nullable Boolean keepSegmentGranularity, @Nullable Granularity segmentGranularity, ObjectMapper jsonMapper) throws IOException, SegmentLoadingException {
        Pair<Map<DataSegment, File>, List<TimelineObjectHolder<String, DataSegment>>> pair = CompactionTask.prepareSegments(toolbox, segmentProvider);
        Map segmentFileMap = (Map)pair.lhs;
        List timelineSegments = (List)pair.rhs;
        if (timelineSegments.size() == 0) {
            return Collections.emptyList();
        }
        List<Pair<QueryableIndex, DataSegment>> queryableIndexAndSegments = CompactionTask.loadSegments(timelineSegments, segmentFileMap, toolbox.getIndexIO());
        IndexTask.IndexTuningConfig compactionTuningConfig = partitionConfigurationManager.computeTuningConfig(queryableIndexAndSegments);
        if (segmentGranularity == null) {
            if (keepSegmentGranularity != null && !keepSegmentGranularity.booleanValue()) {
                DataSchema dataSchema = CompactionTask.createDataSchema(segmentProvider.dataSource, segmentProvider.interval, queryableIndexAndSegments, dimensionsSpec, metricsSpec, Granularities.ALL, jsonMapper);
                return Collections.singletonList(new IndexTask.IndexIngestionSpec(dataSchema, CompactionTask.createIoConfig(toolbox, dataSchema, segmentProvider.interval), compactionTuningConfig));
            }
            TreeMap intervalToSegments = new TreeMap(Comparators.intervalsByStartThenEnd());
            queryableIndexAndSegments.forEach(p -> intervalToSegments.computeIfAbsent(((DataSegment)p.rhs).getInterval(), k -> new ArrayList()).add(p));
            ArrayList<IndexTask.IndexIngestionSpec> specs = new ArrayList<IndexTask.IndexIngestionSpec>(intervalToSegments.size());
            for (Map.Entry entry : intervalToSegments.entrySet()) {
                Interval interval = (Interval)entry.getKey();
                List segmentsToCompact = (List)entry.getValue();
                DataSchema dataSchema = CompactionTask.createDataSchema(segmentProvider.dataSource, interval, segmentsToCompact, dimensionsSpec, metricsSpec, GranularityType.fromPeriod((Period)interval.toPeriod()).getDefaultGranularity(), jsonMapper);
                specs.add(new IndexTask.IndexIngestionSpec(dataSchema, CompactionTask.createIoConfig(toolbox, dataSchema, interval), compactionTuningConfig));
            }
            return specs;
        }
        if (keepSegmentGranularity != null && keepSegmentGranularity.booleanValue()) {
            throw new ISE("segmentGranularity[%s] and keepSegmentGranularity can't be used together", new Object[]{segmentGranularity});
        }
        DataSchema dataSchema = CompactionTask.createDataSchema(segmentProvider.dataSource, segmentProvider.interval, queryableIndexAndSegments, dimensionsSpec, metricsSpec, segmentGranularity, jsonMapper);
        return Collections.singletonList(new IndexTask.IndexIngestionSpec(dataSchema, CompactionTask.createIoConfig(toolbox, dataSchema, segmentProvider.interval), compactionTuningConfig));
    }

    private static IndexTask.IndexIOConfig createIoConfig(TaskToolbox toolbox, DataSchema dataSchema, Interval interval) {
        return new IndexTask.IndexIOConfig(new IngestSegmentFirehoseFactory(dataSchema.getDataSource(), interval, null, dataSchema.getParser().getParseSpec().getDimensionsSpec().getDimensionNames(), Arrays.stream(dataSchema.getAggregators()).map(AggregatorFactory::getName).collect(Collectors.toList()), toolbox.getIndexIO()), false);
    }

    private static Pair<Map<DataSegment, File>, List<TimelineObjectHolder<String, DataSegment>>> prepareSegments(TaskToolbox toolbox, SegmentProvider segmentProvider) throws IOException, SegmentLoadingException {
        List<DataSegment> usedSegments = segmentProvider.checkAndGetSegments(toolbox);
        Map<DataSegment, File> segmentFileMap = toolbox.fetchSegments(usedSegments);
        List timelineSegments = VersionedIntervalTimeline.forSegments(usedSegments).lookup(segmentProvider.interval);
        return Pair.of(segmentFileMap, (Object)timelineSegments);
    }

    private static DataSchema createDataSchema(String dataSource, Interval totalInterval, List<Pair<QueryableIndex, DataSegment>> queryableIndexAndSegments, @Nullable DimensionsSpec dimensionsSpec, @Nullable AggregatorFactory[] metricsSpec, Granularity segmentGranularity, ObjectMapper jsonMapper) {
        for (Pair<QueryableIndex, DataSegment> pair2 : queryableIndexAndSegments) {
            QueryableIndex index = (QueryableIndex)pair2.lhs;
            if (index.getMetadata() != null) continue;
            throw new RE("Index metadata doesn't exist for segment[%s]", new Object[]{((DataSegment)pair2.rhs).getId()});
        }
        boolean rollup = queryableIndexAndSegments.stream().allMatch(pair -> {
            Boolean isRollup = ((QueryableIndex)pair.lhs).getMetadata().isRollup();
            return isRollup != null && isRollup != false;
        });
        UniformGranularitySpec granularitySpec = new UniformGranularitySpec((Granularity)Preconditions.checkNotNull((Object)segmentGranularity), Granularities.NONE, Boolean.valueOf(rollup), Collections.singletonList(totalInterval));
        DimensionsSpec finalDimensionsSpec = dimensionsSpec == null ? CompactionTask.createDimensionsSpec(queryableIndexAndSegments) : dimensionsSpec;
        AggregatorFactory[] finalMetricsSpec = metricsSpec == null ? CompactionTask.createMetricsSpec(queryableIndexAndSegments) : CompactionTask.convertToCombiningFactories(metricsSpec);
        NoopInputRowParser parser = new NoopInputRowParser((ParseSpec)new TimeAndDimsParseSpec(null, finalDimensionsSpec));
        return new DataSchema(dataSource, (Map)jsonMapper.convertValue((Object)parser, JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT), finalMetricsSpec, (GranularitySpec)granularitySpec, null, jsonMapper);
    }

    private static AggregatorFactory[] createMetricsSpec(List<Pair<QueryableIndex, DataSegment>> queryableIndexAndSegments) {
        List aggregatorFactories = queryableIndexAndSegments.stream().map(pair -> ((QueryableIndex)pair.lhs).getMetadata().getAggregators()).collect(Collectors.toList());
        AggregatorFactory[] mergedAggregators = AggregatorFactory.mergeAggregators(aggregatorFactories);
        if (mergedAggregators == null) {
            throw new ISE("Failed to merge aggregators[%s]", new Object[]{aggregatorFactories});
        }
        return mergedAggregators;
    }

    private static AggregatorFactory[] convertToCombiningFactories(AggregatorFactory[] metricsSpec) {
        return (AggregatorFactory[])Arrays.stream(metricsSpec).map(AggregatorFactory::getCombiningFactory).toArray(AggregatorFactory[]::new);
    }

    private static DimensionsSpec createDimensionsSpec(List<Pair<QueryableIndex, DataSegment>> queryableIndices) {
        HashBiMap uniqueDims = HashBiMap.create();
        HashMap<String, DimensionSchema> dimensionSchemaMap = new HashMap<String, DimensionSchema>();
        Comparator intervalComparator = Comparators.intervalsByStartThenEnd();
        for (int i2 = 0; i2 < queryableIndices.size() - 1; ++i2) {
            Interval shouldBeLarger;
            Interval shouldBeSmaller = ((QueryableIndex)queryableIndices.get((int)i2).lhs).getDataInterval();
            Preconditions.checkState((intervalComparator.compare(shouldBeSmaller, shouldBeLarger = ((QueryableIndex)queryableIndices.get((int)(i2 + 1)).lhs).getDataInterval()) <= 0 ? 1 : 0) != 0, (String)"QueryableIndexes are not sorted! Interval[%s] of segment[%s] is laster than interval[%s] of segment[%s]", (Object[])new Object[]{shouldBeSmaller, ((DataSegment)queryableIndices.get((int)i2).rhs).getId(), shouldBeLarger, ((DataSegment)queryableIndices.get((int)(i2 + 1)).rhs).getId()});
        }
        int index = 0;
        for (Pair pair : Lists.reverse(queryableIndices)) {
            QueryableIndex queryableIndex = (QueryableIndex)pair.lhs;
            Map dimensionHandlerMap = queryableIndex.getDimensionHandlers();
            for (String dimension : queryableIndex.getAvailableDimensions()) {
                ColumnHolder columnHolder = (ColumnHolder)Preconditions.checkNotNull((Object)queryableIndex.getColumnHolder(dimension), (String)"Cannot find column for dimension[%s]", (Object[])new Object[]{dimension});
                if (uniqueDims.containsKey((Object)dimension)) continue;
                DimensionHandler dimensionHandler = (DimensionHandler)Preconditions.checkNotNull(dimensionHandlerMap.get(dimension), (String)"Cannot find dimensionHandler for dimension[%s]", (Object[])new Object[]{dimension});
                uniqueDims.put((Object)dimension, (Object)index++);
                dimensionSchemaMap.put(dimension, CompactionTask.createDimensionSchema(columnHolder.getCapabilities().getType(), dimension, dimensionHandler.getMultivalueHandling(), columnHolder.getCapabilities().hasBitmapIndexes()));
            }
        }
        BiMap orderedDims = uniqueDims.inverse();
        List dimensionSchemas = IntStream.range(0, orderedDims.size()).mapToObj(i -> {
            String dimName = (String)orderedDims.get((Object)i);
            return (DimensionSchema)Preconditions.checkNotNull(dimensionSchemaMap.get(dimName), (String)"Cannot find dimension[%s] from dimensionSchemaMap", (Object[])new Object[]{dimName});
        }).collect(Collectors.toList());
        return new DimensionsSpec(dimensionSchemas, null, null);
    }

    private static List<Pair<QueryableIndex, DataSegment>> loadSegments(List<TimelineObjectHolder<String, DataSegment>> timelineObjectHolders, Map<DataSegment, File> segmentFileMap, IndexIO indexIO) throws IOException {
        ArrayList<Pair<QueryableIndex, DataSegment>> segments = new ArrayList<Pair<QueryableIndex, DataSegment>>();
        for (TimelineObjectHolder<String, DataSegment> timelineObjectHolder : timelineObjectHolders) {
            PartitionHolder partitionHolder = timelineObjectHolder.getObject();
            for (PartitionChunk chunk : partitionHolder) {
                DataSegment segment = (DataSegment)chunk.getObject();
                QueryableIndex queryableIndex = indexIO.loadIndex((File)Preconditions.checkNotNull((Object)segmentFileMap.get(segment), (String)"File for segment %s", (Object[])new Object[]{segment.getId()}));
                segments.add((Pair<QueryableIndex, DataSegment>)Pair.of((Object)queryableIndex, (Object)segment));
            }
        }
        return segments;
    }

    private static DimensionSchema createDimensionSchema(ValueType type, String name, DimensionSchema.MultiValueHandling multiValueHandling, boolean hasBitmapIndexes) {
        switch (type) {
            case FLOAT: {
                Preconditions.checkArgument((multiValueHandling == null ? 1 : 0) != 0, (String)"multi-value dimension [%s] is not supported for float type yet", (Object[])new Object[]{name});
                return new FloatDimensionSchema(name);
            }
            case LONG: {
                Preconditions.checkArgument((multiValueHandling == null ? 1 : 0) != 0, (String)"multi-value dimension [%s] is not supported for long type yet", (Object[])new Object[]{name});
                return new LongDimensionSchema(name);
            }
            case DOUBLE: {
                Preconditions.checkArgument((multiValueHandling == null ? 1 : 0) != 0, (String)"multi-value dimension [%s] is not supported for double type yet", (Object[])new Object[]{name});
                return new DoubleDimensionSchema(name);
            }
            case STRING: {
                return new StringDimensionSchema(name, multiValueHandling, Boolean.valueOf(hasBitmapIndexes));
            }
        }
        throw new ISE("Unsupported value type[%s] for dimension[%s]", new Object[]{type, name});
    }

    public static class Builder {
        private final String dataSource;
        private final ObjectMapper jsonMapper;
        private final AuthorizerMapper authorizerMapper;
        private final ChatHandlerProvider chatHandlerProvider;
        private final RowIngestionMetersFactory rowIngestionMetersFactory;
        @Nullable
        private Interval interval;
        @Nullable
        private List<DataSegment> segments;
        @Nullable
        private DimensionsSpec dimensionsSpec;
        @Nullable
        private AggregatorFactory[] metricsSpec;
        @Nullable
        private Boolean keepSegmentGranularity;
        @Nullable
        private Granularity segmentGranularity;
        @Nullable
        private Long targetCompactionSizeBytes;
        @Nullable
        private IndexTask.IndexTuningConfig tuningConfig;
        @Nullable
        private Map<String, Object> context;

        public Builder(String dataSource, ObjectMapper jsonMapper, AuthorizerMapper authorizerMapper, ChatHandlerProvider chatHandlerProvider, RowIngestionMetersFactory rowIngestionMetersFactory) {
            this.dataSource = dataSource;
            this.jsonMapper = jsonMapper;
            this.authorizerMapper = authorizerMapper;
            this.chatHandlerProvider = chatHandlerProvider;
            this.rowIngestionMetersFactory = rowIngestionMetersFactory;
        }

        public Builder interval(Interval interval) {
            this.interval = interval;
            return this;
        }

        public Builder segments(List<DataSegment> segments) {
            this.segments = segments;
            return this;
        }

        public Builder dimensionsSpec(DimensionsSpec dimensionsSpec) {
            this.dimensionsSpec = dimensionsSpec;
            return this;
        }

        public Builder metricsSpec(AggregatorFactory[] metricsSpec) {
            this.metricsSpec = metricsSpec;
            return this;
        }

        public Builder keepSegmentGranularity(boolean keepSegmentGranularity) {
            this.keepSegmentGranularity = keepSegmentGranularity;
            return this;
        }

        public Builder segmentGranularity(Granularity segmentGranularity) {
            this.segmentGranularity = segmentGranularity;
            return this;
        }

        public Builder targetCompactionSizeBytes(long targetCompactionSizeBytes) {
            this.targetCompactionSizeBytes = targetCompactionSizeBytes;
            return this;
        }

        public Builder tuningConfig(IndexTask.IndexTuningConfig tuningConfig) {
            this.tuningConfig = tuningConfig;
            return this;
        }

        public Builder context(Map<String, Object> context) {
            this.context = context;
            return this;
        }

        public CompactionTask build() {
            return new CompactionTask(null, null, this.dataSource, this.interval, this.segments, null, this.dimensionsSpec, this.metricsSpec, this.keepSegmentGranularity, this.segmentGranularity, this.targetCompactionSizeBytes, this.tuningConfig, this.context, this.jsonMapper, this.authorizerMapper, this.chatHandlerProvider, this.rowIngestionMetersFactory);
        }
    }

    @VisibleForTesting
    static class PartitionConfigurationManager {
        @Nullable
        private final Long targetCompactionSizeBytes;
        @Nullable
        private final IndexTask.IndexTuningConfig tuningConfig;

        PartitionConfigurationManager(@Nullable Long targetCompactionSizeBytes, @Nullable IndexTask.IndexTuningConfig tuningConfig) {
            this.targetCompactionSizeBytes = PartitionConfigurationManager.getValidTargetCompactionSizeBytes(targetCompactionSizeBytes, tuningConfig);
            this.tuningConfig = tuningConfig;
        }

        @Nullable
        IndexTask.IndexTuningConfig computeTuningConfig(List<Pair<QueryableIndex, DataSegment>> queryableIndexAndSegments) {
            if (!PartitionConfigurationManager.hasPartitionConfig(this.tuningConfig)) {
                long nonNullTargetCompactionSizeBytes = (Long)Preconditions.checkNotNull((Object)this.targetCompactionSizeBytes, (Object)"targetCompactionSizeBytes");
                long totalNumRows = queryableIndexAndSegments.stream().mapToLong(queryableIndexAndDataSegment -> ((QueryableIndex)queryableIndexAndDataSegment.lhs).getNumRows()).sum();
                long totalSizeBytes = queryableIndexAndSegments.stream().mapToLong(queryableIndexAndDataSegment -> ((DataSegment)queryableIndexAndDataSegment.rhs).getSize()).sum();
                if (totalSizeBytes == 0L) {
                    throw new ISE("Total input segment size is 0 byte", new Object[0]);
                }
                double avgRowsPerByte = (double)totalNumRows / (double)totalSizeBytes;
                int maxRowsPerSegment = Math.toIntExact(Math.round(avgRowsPerByte * (double)nonNullTargetCompactionSizeBytes));
                Preconditions.checkState((maxRowsPerSegment > 0 ? 1 : 0) != 0, (String)"Negative maxRowsPerSegment[%s]", (Object[])new Object[]{maxRowsPerSegment});
                log.info("Estimated maxRowsPerSegment[%d] = avgRowsPerByte[%f] * targetCompactionSizeBytes[%d]", new Object[]{maxRowsPerSegment, avgRowsPerByte, nonNullTargetCompactionSizeBytes});
                return (this.tuningConfig == null ? IndexTask.IndexTuningConfig.createDefault() : this.tuningConfig).withMaxRowsPerSegment(maxRowsPerSegment);
            }
            return this.tuningConfig;
        }

        @Nullable
        private static Long getValidTargetCompactionSizeBytes(@Nullable Long targetCompactionSizeBytes, @Nullable IndexTask.IndexTuningConfig tuningConfig) {
            if (targetCompactionSizeBytes != null && tuningConfig != null) {
                Preconditions.checkArgument((!PartitionConfigurationManager.hasPartitionConfig(tuningConfig) ? 1 : 0) != 0, (String)"targetCompactionSizeBytes[%s] cannot be used with maxRowsPerSegment[%s], maxTotalRows[%s], or numShards[%s] of tuningConfig", (Object[])new Object[]{targetCompactionSizeBytes, tuningConfig.getMaxRowsPerSegment(), tuningConfig.getMaxTotalRows(), tuningConfig.getNumShards()});
                return targetCompactionSizeBytes;
            }
            return PartitionConfigurationManager.hasPartitionConfig(tuningConfig) ? null : Long.valueOf(0x19000000L);
        }

        private static boolean hasPartitionConfig(@Nullable IndexTask.IndexTuningConfig tuningConfig) {
            if (tuningConfig != null) {
                return tuningConfig.getMaxRowsPerSegment() != null || tuningConfig.getMaxTotalRows() != null || tuningConfig.getNumShards() != null;
            }
            return false;
        }
    }

    @VisibleForTesting
    static class SegmentProvider {
        private final String dataSource;
        private final Interval interval;
        private final List<DataSegment> segments;

        SegmentProvider(String dataSource, Interval interval) {
            this.dataSource = (String)Preconditions.checkNotNull((Object)dataSource);
            this.interval = (Interval)Preconditions.checkNotNull((Object)interval);
            this.segments = null;
        }

        SegmentProvider(List<DataSegment> segments) {
            Preconditions.checkArgument((segments != null && !segments.isEmpty() ? 1 : 0) != 0);
            String dataSource = segments.get(0).getDataSource();
            Preconditions.checkArgument((boolean)segments.stream().allMatch(segment -> segment.getDataSource().equals(dataSource)), (Object)"segments should have the same dataSource");
            this.segments = segments;
            this.dataSource = dataSource;
            this.interval = JodaUtils.umbrellaInterval((Iterable)segments.stream().map(DataSegment::getInterval).collect(Collectors.toList()));
        }

        List<DataSegment> getSegments() {
            return this.segments;
        }

        List<DataSegment> checkAndGetSegments(TaskToolbox toolbox) throws IOException {
            List<DataSegment> usedSegments = toolbox.getTaskActionClient().submit(new SegmentListUsedAction(this.dataSource, this.interval, null));
            VersionedIntervalTimeline timeline = VersionedIntervalTimeline.forSegments(usedSegments);
            List<DataSegment> latestSegments = timeline.lookup(this.interval).stream().map(TimelineObjectHolder::getObject).flatMap(partitionHolder -> StreamSupport.stream(partitionHolder.spliterator(), false)).map(PartitionChunk::getObject).collect(Collectors.toList());
            if (this.segments != null) {
                Collections.sort(latestSegments);
                Collections.sort(this.segments);
                if (!latestSegments.equals(this.segments)) {
                    List unknownSegments = this.segments.stream().filter(segment -> !latestSegments.contains(segment)).collect(Collectors.toList());
                    List missingSegments = latestSegments.stream().filter(segment -> !this.segments.contains(segment)).collect(Collectors.toList());
                    throw new ISE("Specified segments in the spec are different from the current used segments. There are unknown segments[%s] and missing segments[%s] in the spec.", new Object[]{unknownSegments, missingSegments});
                }
            }
            return latestSegments;
        }
    }
}

