/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.task.MergeTaskBase;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.segment.IndexMergerV9;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.QueryableIndexIndexableAdapter;
import org.apache.druid.segment.RowFilteringIndexAdapter;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.TimelineObjectHolder;
import org.apache.druid.timeline.VersionedIntervalTimeline;
import org.apache.druid.timeline.partition.PartitionChunk;
import org.joda.time.Interval;

public class AppendTask
extends MergeTaskBase {
    private final IndexSpec indexSpec;
    private final List<AggregatorFactory> aggregators;

    @JsonCreator
    public AppendTask(@JsonProperty(value="id") String id, @JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="segments") List<DataSegment> segments, @JsonProperty(value="aggregations") List<AggregatorFactory> aggregators, @JsonProperty(value="indexSpec") IndexSpec indexSpec, @JsonProperty(value="buildV9Directly") Boolean buildV9Directly, @JsonProperty(value="segmentWriteOutMediumFactory") @Nullable SegmentWriteOutMediumFactory segmentWriteOutMediumFactory, @JsonProperty(value="context") Map<String, Object> context) {
        super(id, dataSource, segments, segmentWriteOutMediumFactory, context);
        this.indexSpec = indexSpec == null ? new IndexSpec() : indexSpec;
        this.aggregators = aggregators;
    }

    @Override
    public File merge(TaskToolbox toolbox, final Map<DataSegment, File> segments, File outDir) throws Exception {
        VersionedIntervalTimeline timeline = VersionedIntervalTimeline.forSegments(segments.keySet());
        Iterable segmentsToMerge = Iterables.concat((Iterable)Iterables.transform((Iterable)timeline.lookup(Intervals.of((String)"1000-01-01/3000-01-01")), (Function)new Function<TimelineObjectHolder<String, DataSegment>, Iterable<SegmentToMergeHolder>>(){

            public Iterable<SegmentToMergeHolder> apply(final TimelineObjectHolder<String, DataSegment> input) {
                return Iterables.transform((Iterable)input.getObject(), (Function)new Function<PartitionChunk<DataSegment>, SegmentToMergeHolder>(){

                    @Nullable
                    public SegmentToMergeHolder apply(PartitionChunk<DataSegment> chunkInput) {
                        DataSegment segment = (DataSegment)chunkInput.getObject();
                        return new SegmentToMergeHolder(input.getInterval(), (File)Preconditions.checkNotNull(segments.get(segment), (String)"File for segment %s", (Object[])new Object[]{segment.getId()}));
                    }
                });
            }
        }));
        ArrayList<RowFilteringIndexAdapter> adapters = new ArrayList<RowFilteringIndexAdapter>();
        for (SegmentToMergeHolder holder : segmentsToMerge) {
            adapters.add(new RowFilteringIndexAdapter(new QueryableIndexIndexableAdapter(toolbox.getIndexIO().loadIndex(holder.getFile())), rowPointer -> holder.getInterval().contains(rowPointer.getTimestamp())));
        }
        IndexMergerV9 indexMerger = toolbox.getIndexMergerV9();
        return indexMerger.append(adapters, this.aggregators == null ? null : this.aggregators.toArray(new AggregatorFactory[0]), outDir, this.indexSpec, this.getSegmentWriteOutMediumFactory());
    }

    @Override
    public String getType() {
        return "append";
    }

    @JsonProperty(value="aggregations")
    public List<AggregatorFactory> getAggregators() {
        return this.aggregators;
    }

    private static class SegmentToMergeHolder {
        private final Interval interval;
        private final File file;

        private SegmentToMergeHolder(Interval interval, File file) {
            this.interval = interval;
            this.file = file;
        }

        public Interval getInterval() {
            return this.interval;
        }

        public File getFile() {
            return this.file;
        }
    }
}

