/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.stats;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import java.util.HashMap;
import java.util.Map;
import org.apache.druid.indexing.common.stats.RowIngestionMeters;
import org.apache.druid.indexing.common.stats.RowIngestionMetersTotals;

public class DropwizardRowIngestionMeters
implements RowIngestionMeters {
    public static final String ONE_MINUTE_NAME = "1m";
    public static final String FIVE_MINUTE_NAME = "5m";
    public static final String FIFTEEN_MINUTE_NAME = "15m";
    private final MetricRegistry metricRegistry = new MetricRegistry();
    private final Meter processed = this.metricRegistry.meter("processed");
    private final Meter processedWithError = this.metricRegistry.meter("processedWithError");
    private final Meter unparseable = this.metricRegistry.meter("unparseable");
    private final Meter thrownAway = this.metricRegistry.meter("thrownAway");

    @Override
    public long getProcessed() {
        return this.processed.getCount();
    }

    @Override
    public void incrementProcessed() {
        this.processed.mark();
    }

    @Override
    public long getProcessedWithError() {
        return this.processedWithError.getCount();
    }

    @Override
    public void incrementProcessedWithError() {
        this.processedWithError.mark();
    }

    @Override
    public long getUnparseable() {
        return this.unparseable.getCount();
    }

    @Override
    public void incrementUnparseable() {
        this.unparseable.mark();
    }

    @Override
    public long getThrownAway() {
        return this.thrownAway.getCount();
    }

    @Override
    public void incrementThrownAway() {
        this.thrownAway.mark();
    }

    @Override
    public RowIngestionMetersTotals getTotals() {
        return new RowIngestionMetersTotals(this.processed.getCount(), this.processedWithError.getCount(), this.thrownAway.getCount(), this.unparseable.getCount());
    }

    @Override
    public Map<String, Object> getMovingAverages() {
        HashMap<String, Object> movingAverages = new HashMap<String, Object>();
        HashMap<String, Double> oneMinute = new HashMap<String, Double>();
        oneMinute.put("processed", this.processed.getOneMinuteRate());
        oneMinute.put("processedWithError", this.processedWithError.getOneMinuteRate());
        oneMinute.put("unparseable", this.unparseable.getOneMinuteRate());
        oneMinute.put("thrownAway", this.thrownAway.getOneMinuteRate());
        HashMap<String, Double> fiveMinute = new HashMap<String, Double>();
        fiveMinute.put("processed", this.processed.getFiveMinuteRate());
        fiveMinute.put("processedWithError", this.processedWithError.getFiveMinuteRate());
        fiveMinute.put("unparseable", this.unparseable.getFiveMinuteRate());
        fiveMinute.put("thrownAway", this.thrownAway.getFiveMinuteRate());
        HashMap<String, Double> fifteenMinute = new HashMap<String, Double>();
        fifteenMinute.put("processed", this.processed.getFifteenMinuteRate());
        fifteenMinute.put("processedWithError", this.processedWithError.getFifteenMinuteRate());
        fifteenMinute.put("unparseable", this.unparseable.getFifteenMinuteRate());
        fifteenMinute.put("thrownAway", this.thrownAway.getFifteenMinuteRate());
        movingAverages.put(ONE_MINUTE_NAME, oneMinute);
        movingAverages.put(FIVE_MINUTE_NAME, fiveMinute);
        movingAverages.put(FIFTEEN_MINUTE_NAME, fifteenMinute);
        return movingAverages;
    }
}

