/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.index;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.druid.data.input.Committer;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.IndexMergerV9;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.SegmentUtils;
import org.apache.druid.segment.incremental.IncrementalIndexAddResult;
import org.apache.druid.segment.incremental.IndexSizeExceededException;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.segment.indexing.RealtimeTuningConfig;
import org.apache.druid.segment.indexing.TuningConfigs;
import org.apache.druid.segment.loading.DataSegmentPusher;
import org.apache.druid.segment.realtime.FireDepartmentMetrics;
import org.apache.druid.segment.realtime.FireHydrant;
import org.apache.druid.segment.realtime.plumber.Plumber;
import org.apache.druid.segment.realtime.plumber.PlumberSchool;
import org.apache.druid.segment.realtime.plumber.Sink;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.Interval;

@JsonTypeName(value="historical")
public class YeOldePlumberSchool
implements PlumberSchool {
    private final Interval interval;
    private final String version;
    private final DataSegmentPusher dataSegmentPusher;
    private final File tmpSegmentDir;
    private final IndexMergerV9 indexMergerV9;
    private final IndexIO indexIO;
    private static final Logger log = new Logger(YeOldePlumberSchool.class);

    @JsonCreator
    public YeOldePlumberSchool(@JsonProperty(value="interval") Interval interval, @JsonProperty(value="version") String version, @JacksonInject(value="segmentPusher") DataSegmentPusher dataSegmentPusher, @JacksonInject(value="tmpSegmentDir") File tmpSegmentDir, @JacksonInject IndexMergerV9 indexMergerV9, @JacksonInject IndexIO indexIO) {
        this.interval = interval;
        this.version = version;
        this.dataSegmentPusher = dataSegmentPusher;
        this.tmpSegmentDir = tmpSegmentDir;
        this.indexMergerV9 = (IndexMergerV9)Preconditions.checkNotNull((Object)indexMergerV9, (Object)"Null IndexMergerV9");
        this.indexIO = (IndexIO)Preconditions.checkNotNull((Object)indexIO, (Object)"Null IndexIO");
    }

    public Plumber findPlumber(final DataSchema schema, final RealtimeTuningConfig config, final FireDepartmentMetrics metrics) {
        final Sink theSink = new Sink(this.interval, schema, config.getShardSpec(), this.version, config.getMaxRowsInMemory(), TuningConfigs.getMaxBytesInMemoryOrDefault((long)config.getMaxBytesInMemory()), config.isReportParseExceptions(), config.getDedupColumn());
        final File persistDir = new File(this.tmpSegmentDir, theSink.getSegment().getId().toString());
        final HashSet spilled = new HashSet();
        return new Plumber(){

            public Object startJob() {
                return null;
            }

            public IncrementalIndexAddResult add(InputRow row, Supplier<Committer> committerSupplier) throws IndexSizeExceededException {
                Sink sink = this.getSink(row.getTimestampFromEpoch());
                if (sink == null) {
                    return Plumber.THROWAWAY;
                }
                IncrementalIndexAddResult addResult = sink.add(row, false);
                if (!sink.canAppendRow()) {
                    this.persist((Committer)committerSupplier.get());
                }
                return addResult;
            }

            private Sink getSink(long timestamp) {
                if (theSink.getInterval().contains(timestamp)) {
                    return theSink;
                }
                return null;
            }

            public <T> QueryRunner<T> getQueryRunner(Query<T> query) {
                throw new UnsupportedOperationException("Don't query me, bro.");
            }

            public void persist(Committer committer) {
                this.spillIfSwappable();
                committer.run();
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void finishJob() {
                File fileToUpload = null;
                try {
                    Preconditions.checkState((!theSink.swappable() ? 1 : 0) != 0, (Object)"All data must be persisted before fininshing the job!");
                    if (spilled.size() == 0) {
                        throw new IllegalStateException("Nothing indexed?");
                    }
                    if (spilled.size() == 1) {
                        fileToUpload = (File)Iterables.getOnlyElement((Iterable)spilled);
                    } else {
                        ArrayList<QueryableIndex> indexes = new ArrayList<QueryableIndex>();
                        for (File oneSpill : spilled) {
                            indexes.add(YeOldePlumberSchool.this.indexIO.loadIndex(oneSpill));
                        }
                        fileToUpload = new File(YeOldePlumberSchool.this.tmpSegmentDir, "merged");
                        YeOldePlumberSchool.this.indexMergerV9.mergeQueryableIndex(indexes, schema.getGranularitySpec().isRollup(), schema.getAggregators(), fileToUpload, config.getIndexSpec(), config.getSegmentWriteOutMediumFactory());
                    }
                    QueryableIndex mappedSegment = YeOldePlumberSchool.this.indexIO.loadIndex(fileToUpload);
                    DataSegment segmentToUpload = theSink.getSegment().withDimensions((List)ImmutableList.copyOf((Iterable)mappedSegment.getAvailableDimensions())).withBinaryVersion(SegmentUtils.getVersionFromDir((File)fileToUpload));
                    YeOldePlumberSchool.this.dataSegmentPusher.push(fileToUpload, segmentToUpload, false);
                    log.info("Uploaded segment[%s]", new Object[]{segmentToUpload.getId()});
                }
                catch (Exception e) {
                    try {
                        log.warn((Throwable)e, "Failed to merge and upload", new Object[0]);
                        throw Throwables.propagate((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        try {
                            if (fileToUpload == null) throw throwable;
                            log.info("Deleting Index File[%s]", new Object[]{fileToUpload});
                            FileUtils.deleteDirectory(fileToUpload);
                            throw throwable;
                        }
                        catch (IOException e2) {
                            log.warn((Throwable)e2, "Error deleting directory[%s]", new Object[]{fileToUpload});
                        }
                        throw throwable;
                    }
                }
                try {
                    if (fileToUpload == null) return;
                    log.info("Deleting Index File[%s]", new Object[]{fileToUpload});
                    FileUtils.deleteDirectory((File)fileToUpload);
                    return;
                }
                catch (IOException e) {
                    log.warn((Throwable)e, "Error deleting directory[%s]", new Object[]{fileToUpload});
                    return;
                }
            }

            private void spillIfSwappable() {
                if (theSink.swappable()) {
                    FireHydrant indexToPersist = theSink.swap();
                    int rowsToPersist = indexToPersist.getIndex().size();
                    File dirToPersist = this.getSpillDir(indexToPersist.getCount());
                    log.info("Spilling index[%d] with rows[%d] to: %s", new Object[]{indexToPersist.getCount(), rowsToPersist, dirToPersist});
                    try {
                        YeOldePlumberSchool.this.indexMergerV9.persist(indexToPersist.getIndex(), dirToPersist, config.getIndexSpec(), config.getSegmentWriteOutMediumFactory());
                        indexToPersist.swapSegment(null);
                        metrics.incrementRowOutputCount((long)rowsToPersist);
                        spilled.add(dirToPersist);
                    }
                    catch (Exception e) {
                        log.warn((Throwable)e, "Failed to spill index[%d]", new Object[]{indexToPersist.getCount()});
                        throw Throwables.propagate((Throwable)e);
                    }
                }
            }

            private File getSpillDir(int n) {
                return new File(persistDir, StringUtils.format((String)"spill%d", (Object[])new Object[]{n}));
            }
        };
    }
}

