/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.index;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import java.io.File;
import javax.annotation.Nullable;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.indexing.TuningConfig;
import org.apache.druid.segment.realtime.appenderator.AppenderatorConfig;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.druid.timeline.partition.NoneShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.joda.time.Period;

@JsonTypeName(value="realtime_appenderator")
public class RealtimeAppenderatorTuningConfig
implements TuningConfig,
AppenderatorConfig {
    private static final int defaultMaxRowsInMemory = 1000000;
    private static final int defaultMaxRowsPerSegment = 5000000;
    private static final Period defaultIntermediatePersistPeriod = new Period((Object)"PT10M");
    private static final int defaultMaxPendingPersists = 0;
    private static final ShardSpec defaultShardSpec = NoneShardSpec.instance();
    private static final IndexSpec defaultIndexSpec = new IndexSpec();
    private static final Boolean defaultReportParseExceptions = Boolean.FALSE;
    private static final long defaultPublishAndHandoffTimeout = 0L;
    private static final long defaultAlertTimeout = 0L;
    private final int maxRowsInMemory;
    private final long maxBytesInMemory;
    private final int maxRowsPerSegment;
    @Nullable
    private final Long maxTotalRows;
    private final Period intermediatePersistPeriod;
    private final File basePersistDirectory;
    private final int maxPendingPersists;
    private final ShardSpec shardSpec;
    private final IndexSpec indexSpec;
    private final boolean reportParseExceptions;
    private final long publishAndHandoffTimeout;
    private final long alertTimeout;
    @Nullable
    private final SegmentWriteOutMediumFactory segmentWriteOutMediumFactory;
    private final boolean logParseExceptions;
    private final int maxParseExceptions;
    private final int maxSavedParseExceptions;

    private static File createNewBasePersistDirectory() {
        return Files.createTempDir();
    }

    @JsonCreator
    public RealtimeAppenderatorTuningConfig(@JsonProperty(value="maxRowsInMemory") Integer maxRowsInMemory, @JsonProperty(value="maxBytesInMemory") @Nullable Long maxBytesInMemory, @JsonProperty(value="maxRowsPerSegment") @Nullable Integer maxRowsPerSegment, @JsonProperty(value="maxTotalRows") @Nullable Long maxTotalRows, @JsonProperty(value="intermediatePersistPeriod") Period intermediatePersistPeriod, @JsonProperty(value="basePersistDirectory") File basePersistDirectory, @JsonProperty(value="maxPendingPersists") Integer maxPendingPersists, @JsonProperty(value="shardSpec") ShardSpec shardSpec, @JsonProperty(value="indexSpec") IndexSpec indexSpec, @JsonProperty(value="reportParseExceptions") Boolean reportParseExceptions, @JsonProperty(value="publishAndHandoffTimeout") Long publishAndHandoffTimeout, @JsonProperty(value="alertTimeout") Long alertTimeout, @JsonProperty(value="segmentWriteOutMediumFactory") @Nullable SegmentWriteOutMediumFactory segmentWriteOutMediumFactory, @JsonProperty(value="logParseExceptions") @Nullable Boolean logParseExceptions, @JsonProperty(value="maxParseExceptions") @Nullable Integer maxParseExceptions, @JsonProperty(value="maxSavedParseExceptions") @Nullable Integer maxSavedParseExceptions) {
        this.maxRowsInMemory = maxRowsInMemory == null ? 1000000 : maxRowsInMemory;
        this.maxRowsPerSegment = maxRowsPerSegment == null ? 5000000 : maxRowsPerSegment;
        this.maxBytesInMemory = maxBytesInMemory == null ? 0L : maxBytesInMemory;
        this.maxTotalRows = maxTotalRows;
        this.intermediatePersistPeriod = intermediatePersistPeriod == null ? defaultIntermediatePersistPeriod : intermediatePersistPeriod;
        this.basePersistDirectory = basePersistDirectory == null ? RealtimeAppenderatorTuningConfig.createNewBasePersistDirectory() : basePersistDirectory;
        this.maxPendingPersists = maxPendingPersists == null ? 0 : maxPendingPersists;
        this.shardSpec = shardSpec == null ? defaultShardSpec : shardSpec;
        this.indexSpec = indexSpec == null ? defaultIndexSpec : indexSpec;
        this.reportParseExceptions = reportParseExceptions == null ? defaultReportParseExceptions : reportParseExceptions;
        this.publishAndHandoffTimeout = publishAndHandoffTimeout == null ? 0L : publishAndHandoffTimeout;
        Preconditions.checkArgument((this.publishAndHandoffTimeout >= 0L ? 1 : 0) != 0, (Object)"publishAndHandoffTimeout must be >= 0");
        this.alertTimeout = alertTimeout == null ? 0L : alertTimeout;
        Preconditions.checkArgument((this.alertTimeout >= 0L ? 1 : 0) != 0, (Object)"alertTimeout must be >= 0");
        this.segmentWriteOutMediumFactory = segmentWriteOutMediumFactory;
        if (this.reportParseExceptions) {
            this.maxParseExceptions = 0;
            this.maxSavedParseExceptions = maxSavedParseExceptions == null ? 0 : Math.min(1, maxSavedParseExceptions);
        } else {
            this.maxParseExceptions = maxParseExceptions == null ? Integer.MAX_VALUE : maxParseExceptions;
            this.maxSavedParseExceptions = maxSavedParseExceptions == null ? 0 : maxSavedParseExceptions;
        }
        this.logParseExceptions = logParseExceptions == null ? false : logParseExceptions;
    }

    @JsonProperty
    public int getMaxRowsInMemory() {
        return this.maxRowsInMemory;
    }

    public long getMaxBytesInMemory() {
        return this.maxBytesInMemory;
    }

    @JsonProperty
    public Integer getMaxRowsPerSegment() {
        return this.maxRowsPerSegment;
    }

    @JsonProperty
    @Nullable
    public Long getMaxTotalRows() {
        return this.maxTotalRows;
    }

    @JsonProperty
    public Period getIntermediatePersistPeriod() {
        return this.intermediatePersistPeriod;
    }

    @JsonProperty
    public File getBasePersistDirectory() {
        return this.basePersistDirectory;
    }

    @JsonProperty
    public int getMaxPendingPersists() {
        return this.maxPendingPersists;
    }

    @JsonProperty
    public ShardSpec getShardSpec() {
        return this.shardSpec;
    }

    @JsonProperty
    public IndexSpec getIndexSpec() {
        return this.indexSpec;
    }

    @JsonProperty
    public boolean isReportParseExceptions() {
        return this.reportParseExceptions;
    }

    @JsonProperty
    public long getPublishAndHandoffTimeout() {
        return this.publishAndHandoffTimeout;
    }

    @JsonProperty
    public long getAlertTimeout() {
        return this.alertTimeout;
    }

    @JsonProperty
    @Nullable
    public SegmentWriteOutMediumFactory getSegmentWriteOutMediumFactory() {
        return this.segmentWriteOutMediumFactory;
    }

    @JsonProperty
    public boolean isLogParseExceptions() {
        return this.logParseExceptions;
    }

    @JsonProperty
    public int getMaxParseExceptions() {
        return this.maxParseExceptions;
    }

    @JsonProperty
    public int getMaxSavedParseExceptions() {
        return this.maxSavedParseExceptions;
    }

    public RealtimeAppenderatorTuningConfig withBasePersistDirectory(File dir) {
        return new RealtimeAppenderatorTuningConfig(this.maxRowsInMemory, this.maxBytesInMemory, this.maxRowsPerSegment, this.maxTotalRows, this.intermediatePersistPeriod, dir, this.maxPendingPersists, this.shardSpec, this.indexSpec, this.reportParseExceptions, this.publishAndHandoffTimeout, this.alertTimeout, this.segmentWriteOutMediumFactory, this.logParseExceptions, this.maxParseExceptions, this.maxSavedParseExceptions);
    }
}

