/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.nio.file.Paths;
import java.util.List;
import org.joda.time.Period;

public class TaskConfig {
    public static final List<String> DEFAULT_DEFAULT_HADOOP_COORDINATES = ImmutableList.of((Object)"org.apache.hadoop:hadoop-client:2.8.3");
    private static final Period DEFAULT_DIRECTORY_LOCK_TIMEOUT = new Period((Object)"PT10M");
    private static final Period DEFAULT_GRACEFUL_SHUTDOWN_TIMEOUT = new Period((Object)"PT5M");
    @JsonProperty
    private final String baseDir;
    @JsonProperty
    private final File baseTaskDir;
    @JsonProperty
    private final String hadoopWorkingPath;
    @JsonProperty
    private final int defaultRowFlushBoundary;
    @JsonProperty
    private final List<String> defaultHadoopCoordinates;
    @JsonProperty
    private final boolean restoreTasksOnRestart;
    @JsonProperty
    private final Period gracefulShutdownTimeout;
    @JsonProperty
    private final Period directoryLockTimeout;

    @JsonCreator
    public TaskConfig(@JsonProperty(value="baseDir") String baseDir, @JsonProperty(value="baseTaskDir") String baseTaskDir, @JsonProperty(value="hadoopWorkingPath") String hadoopWorkingPath, @JsonProperty(value="defaultRowFlushBoundary") Integer defaultRowFlushBoundary, @JsonProperty(value="defaultHadoopCoordinates") List<String> defaultHadoopCoordinates, @JsonProperty(value="restoreTasksOnRestart") boolean restoreTasksOnRestart, @JsonProperty(value="gracefulShutdownTimeout") Period gracefulShutdownTimeout, @JsonProperty(value="directoryLockTimeout") Period directoryLockTimeout) {
        this.baseDir = baseDir == null ? System.getProperty("java.io.tmpdir") : baseDir;
        this.baseTaskDir = new File(this.defaultDir(baseTaskDir, "persistent/task"));
        this.hadoopWorkingPath = hadoopWorkingPath == null ? "/tmp/druid-indexing" : hadoopWorkingPath;
        this.defaultRowFlushBoundary = defaultRowFlushBoundary == null ? 75000 : defaultRowFlushBoundary;
        this.defaultHadoopCoordinates = defaultHadoopCoordinates == null ? DEFAULT_DEFAULT_HADOOP_COORDINATES : defaultHadoopCoordinates;
        this.restoreTasksOnRestart = restoreTasksOnRestart;
        this.gracefulShutdownTimeout = gracefulShutdownTimeout == null ? DEFAULT_GRACEFUL_SHUTDOWN_TIMEOUT : gracefulShutdownTimeout;
        this.directoryLockTimeout = directoryLockTimeout == null ? DEFAULT_DIRECTORY_LOCK_TIMEOUT : directoryLockTimeout;
    }

    @JsonProperty
    public String getBaseDir() {
        return this.baseDir;
    }

    @JsonProperty
    public File getBaseTaskDir() {
        return this.baseTaskDir;
    }

    public File getTaskDir(String taskId) {
        return new File(this.baseTaskDir, taskId);
    }

    public File getTaskWorkDir(String taskId) {
        return new File(this.getTaskDir(taskId), "work");
    }

    public File getTaskLockFile(String taskId) {
        return new File(this.getTaskDir(taskId), "lock");
    }

    @JsonProperty
    public String getHadoopWorkingPath() {
        return this.hadoopWorkingPath;
    }

    @JsonProperty
    public int getDefaultRowFlushBoundary() {
        return this.defaultRowFlushBoundary;
    }

    @JsonProperty
    public List<String> getDefaultHadoopCoordinates() {
        return this.defaultHadoopCoordinates;
    }

    @JsonProperty
    public boolean isRestoreTasksOnRestart() {
        return this.restoreTasksOnRestart;
    }

    @JsonProperty
    public Period getGracefulShutdownTimeout() {
        return this.gracefulShutdownTimeout;
    }

    @JsonProperty
    public Period getDirectoryLockTimeout() {
        return this.directoryLockTimeout;
    }

    private String defaultDir(String configParameter, String defaultVal) {
        if (configParameter == null) {
            return Paths.get(this.getBaseDir(), defaultVal).toString();
        }
        return configParameter;
    }
}

