/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.actions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.druid.indexing.common.actions.TaskAction;
import org.apache.druid.indexing.common.actions.TaskActionPreconditions;
import org.apache.druid.indexing.common.actions.TaskActionToolbox;
import org.apache.druid.indexing.common.task.IndexTaskUtils;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.CriticalAction;
import org.apache.druid.indexing.overlord.DataSourceMetadata;
import org.apache.druid.indexing.overlord.SegmentPublishResult;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.timeline.DataSegment;

public class SegmentTransactionalInsertAction
implements TaskAction<SegmentPublishResult> {
    private final Set<DataSegment> segments;
    private final DataSourceMetadata startMetadata;
    private final DataSourceMetadata endMetadata;

    public SegmentTransactionalInsertAction(Set<DataSegment> segments) {
        this(segments, null, null);
    }

    @JsonCreator
    public SegmentTransactionalInsertAction(@JsonProperty(value="segments") Set<DataSegment> segments, @JsonProperty(value="startMetadata") DataSourceMetadata startMetadata, @JsonProperty(value="endMetadata") DataSourceMetadata endMetadata) {
        this.segments = ImmutableSet.copyOf(segments);
        this.startMetadata = startMetadata;
        this.endMetadata = endMetadata;
    }

    @JsonProperty
    public Set<DataSegment> getSegments() {
        return this.segments;
    }

    @JsonProperty
    public DataSourceMetadata getStartMetadata() {
        return this.startMetadata;
    }

    @JsonProperty
    public DataSourceMetadata getEndMetadata() {
        return this.endMetadata;
    }

    @Override
    public TypeReference<SegmentPublishResult> getReturnTypeReference() {
        return new TypeReference<SegmentPublishResult>(){};
    }

    @Override
    public SegmentPublishResult perform(Task task, TaskActionToolbox toolbox) {
        SegmentPublishResult retVal;
        TaskActionPreconditions.checkLockCoversSegments(task, toolbox.getTaskLockbox(), this.segments);
        try {
            retVal = toolbox.getTaskLockbox().doInCriticalSection(task, this.segments.stream().map(DataSegment::getInterval).collect(Collectors.toList()), CriticalAction.builder().onValidLocks(() -> toolbox.getIndexerMetadataStorageCoordinator().announceHistoricalSegments(this.segments, this.startMetadata, this.endMetadata)).onInvalidLocks(SegmentPublishResult::fail).build());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ServiceMetricEvent.Builder metricBuilder = new ServiceMetricEvent.Builder();
        IndexTaskUtils.setTaskDimensions(metricBuilder, task);
        if (retVal.isSuccess()) {
            toolbox.getEmitter().emit(metricBuilder.build("segment/txn/success", (Number)1));
        } else {
            toolbox.getEmitter().emit(metricBuilder.build("segment/txn/failure", (Number)1));
        }
        for (DataSegment segment : retVal.getSegments()) {
            metricBuilder.setDimension("interval", segment.getInterval().toString());
            toolbox.getEmitter().emit(metricBuilder.build("segment/added/bytes", (Number)segment.getSize()));
        }
        return retVal;
    }

    @Override
    public boolean isAudited() {
        return true;
    }

    @Override
    public String toString() {
        return "SegmentTransactionalInsertAction{segments=" + this.segments + ", startMetadata=" + this.startMetadata + ", endMetadata=" + this.endMetadata + '}';
    }
}

