/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.actions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.druid.indexing.common.actions.TaskAction;
import org.apache.druid.indexing.common.actions.TaskActionToolbox;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.java.util.common.JodaUtils;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.Interval;

public class SegmentListUsedAction
implements TaskAction<List<DataSegment>> {
    @JsonIgnore
    private final String dataSource;
    @JsonIgnore
    private final List<Interval> intervals;

    @JsonCreator
    public SegmentListUsedAction(@JsonProperty(value="dataSource") String dataSource, @Deprecated @JsonProperty(value="interval") Interval interval, @JsonProperty(value="intervals") List<Interval> intervals) {
        this.dataSource = dataSource;
        Preconditions.checkArgument((interval == null || intervals == null ? 1 : 0) != 0, (Object)"please specify intervals only");
        Object theIntervals = null;
        if (interval != null) {
            theIntervals = ImmutableList.of((Object)interval);
        } else if (intervals != null && intervals.size() > 0) {
            theIntervals = JodaUtils.condenseIntervals(intervals);
        }
        this.intervals = (List)Preconditions.checkNotNull((Object)theIntervals, (Object)"no intervals found");
    }

    @JsonProperty
    public String getDataSource() {
        return this.dataSource;
    }

    @JsonProperty
    public List<Interval> getIntervals() {
        return this.intervals;
    }

    @Override
    public TypeReference<List<DataSegment>> getReturnTypeReference() {
        return new TypeReference<List<DataSegment>>(){};
    }

    @Override
    public List<DataSegment> perform(Task task, TaskActionToolbox toolbox) {
        return toolbox.getIndexerMetadataStorageCoordinator().getUsedSegmentsForIntervals(this.dataSource, this.intervals);
    }

    @Override
    public boolean isAudited() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SegmentListUsedAction that = (SegmentListUsedAction)o;
        if (!this.dataSource.equals(that.dataSource)) {
            return false;
        }
        return this.intervals.equals(that.intervals);
    }

    public int hashCode() {
        int result = this.dataSource.hashCode();
        result = 31 * result + this.intervals.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "SegmentListUsedAction{dataSource='" + this.dataSource + '\'' + ", intervals=" + this.intervals + '}';
    }
}

