/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.actions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Set;
import org.apache.druid.indexing.common.actions.SegmentTransactionalInsertAction;
import org.apache.druid.indexing.common.actions.TaskAction;
import org.apache.druid.indexing.common.actions.TaskActionToolbox;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.timeline.DataSegment;

public class SegmentInsertAction
implements TaskAction<Set<DataSegment>> {
    private final Set<DataSegment> segments;

    @JsonCreator
    public SegmentInsertAction(@JsonProperty(value="segments") Set<DataSegment> segments) {
        this.segments = ImmutableSet.copyOf(segments);
    }

    @JsonProperty
    public Set<DataSegment> getSegments() {
        return this.segments;
    }

    @Override
    public TypeReference<Set<DataSegment>> getReturnTypeReference() {
        return new TypeReference<Set<DataSegment>>(){};
    }

    @Override
    public Set<DataSegment> perform(Task task, TaskActionToolbox toolbox) {
        return new SegmentTransactionalInsertAction(this.segments, null, null).perform(task, toolbox).getSegments();
    }

    @Override
    public boolean isAudited() {
        return true;
    }

    @Override
    public String toString() {
        return "SegmentInsertAction{segments=" + Iterables.transform(this.segments, DataSegment::getId) + '}';
    }
}

