/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.actions;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import org.apache.druid.client.indexing.IndexingService;
import org.apache.druid.discovery.DruidLeaderClient;
import org.apache.druid.indexing.common.RetryPolicyFactory;
import org.apache.druid.indexing.common.actions.RemoteTaskActionClient;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.common.actions.TaskActionClientFactory;
import org.apache.druid.indexing.common.task.Task;

public class RemoteTaskActionClientFactory
implements TaskActionClientFactory {
    private final DruidLeaderClient druidLeaderClient;
    private final RetryPolicyFactory retryPolicyFactory;
    private final ObjectMapper jsonMapper;

    @Inject
    public RemoteTaskActionClientFactory(@IndexingService DruidLeaderClient leaderHttpClient, RetryPolicyFactory retryPolicyFactory, ObjectMapper jsonMapper) {
        this.druidLeaderClient = leaderHttpClient;
        this.retryPolicyFactory = retryPolicyFactory;
        this.jsonMapper = jsonMapper;
    }

    @Override
    public TaskActionClient create(Task task) {
        return new RemoteTaskActionClient(task, this.druidLeaderClient, this.retryPolicyFactory, this.jsonMapper);
    }
}

