/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.actions;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.druid.discovery.DruidLeaderClient;
import org.apache.druid.indexing.common.RetryPolicy;
import org.apache.druid.indexing.common.RetryPolicyFactory;
import org.apache.druid.indexing.common.actions.TaskAction;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.common.actions.TaskActionHolder;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.java.util.common.IOE;
import org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.http.client.response.FullResponseHolder;
import org.jboss.netty.channel.ChannelException;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.joda.time.Duration;

public class RemoteTaskActionClient
implements TaskActionClient {
    private final Task task;
    private final RetryPolicyFactory retryPolicyFactory;
    private final ObjectMapper jsonMapper;
    private final DruidLeaderClient druidLeaderClient;
    private static final Logger log = new Logger(RemoteTaskActionClient.class);

    public RemoteTaskActionClient(Task task, DruidLeaderClient druidLeaderClient, RetryPolicyFactory retryPolicyFactory, ObjectMapper jsonMapper) {
        this.task = task;
        this.retryPolicyFactory = retryPolicyFactory;
        this.jsonMapper = jsonMapper;
        this.druidLeaderClient = druidLeaderClient;
    }

    /*
     * Loose catch block
     */
    @Override
    public <RetType> RetType submit(TaskAction<RetType> taskAction) throws IOException {
        log.info("Performing action for task[%s]: %s", new Object[]{this.task.getId(), taskAction});
        byte[] dataToSend = this.jsonMapper.writeValueAsBytes((Object)new TaskActionHolder(this.task, taskAction));
        RetryPolicy retryPolicy = this.retryPolicyFactory.makeRetryPolicy();
        while (true) {
            try {
                log.info("Submitting action for task[%s] to overlord: [%s].", new Object[]{this.task.getId(), taskAction});
                FullResponseHolder fullResponseHolder = this.druidLeaderClient.go(this.druidLeaderClient.makeRequest(HttpMethod.POST, "/druid/indexer/v1/action").setContent("application/json", dataToSend));
                if (fullResponseHolder.getStatus().getCode() / 100 == 2) {
                    Map responseDict = (Map)this.jsonMapper.readValue(fullResponseHolder.getContent(), JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT);
                    return (RetType)this.jsonMapper.convertValue(responseDict.get("result"), taskAction.getReturnTypeReference());
                }
                throw new IOE("Error with status[%s] and message[%s]. Check overlord logs for details.", new Object[]{fullResponseHolder.getStatus(), fullResponseHolder.getContent()});
            }
            catch (IOException | ChannelException e) {
                log.warn(e, "Exception submitting action for task[%s]", new Object[]{this.task.getId()});
                Duration delay = retryPolicy.getAndIncrementRetryDelay();
                if (delay == null) {
                    throw e;
                }
                try {
                    long sleepTime = this.jitter(delay.getMillis());
                    log.info("Will try again in [%s].", new Object[]{new Duration(sleepTime).toString()});
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException e2) {
                    throw Throwables.propagate((Throwable)e2);
                }
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private long jitter(long input) {
        double jitter = ThreadLocalRandom.current().nextGaussian() * (double)input / 4.0;
        long retval = input + (long)jitter;
        return retval < 0L ? 0L : retval;
    }
}

