/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.actions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import javax.annotation.Nullable;
import org.apache.druid.indexing.common.TaskLock;
import org.apache.druid.indexing.common.TaskLockType;
import org.apache.druid.indexing.common.actions.TaskAction;
import org.apache.druid.indexing.common.actions.TaskActionToolbox;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.LockResult;
import org.joda.time.Interval;

public class LockTryAcquireAction
implements TaskAction<TaskLock> {
    @JsonIgnore
    private final TaskLockType type;
    @JsonIgnore
    private final Interval interval;

    @JsonCreator
    public LockTryAcquireAction(@JsonProperty(value="lockType") @Nullable TaskLockType type, @JsonProperty(value="interval") Interval interval) {
        this.type = type == null ? TaskLockType.EXCLUSIVE : type;
        this.interval = interval;
    }

    @JsonProperty(value="lockType")
    public TaskLockType getType() {
        return this.type;
    }

    @JsonProperty
    public Interval getInterval() {
        return this.interval;
    }

    @Override
    public TypeReference<TaskLock> getReturnTypeReference() {
        return new TypeReference<TaskLock>(){};
    }

    @Override
    public TaskLock perform(Task task, TaskActionToolbox toolbox) {
        LockResult result = toolbox.getTaskLockbox().tryLock(this.type, task, this.interval);
        return result.isOk() ? result.getTaskLock() : null;
    }

    @Override
    public boolean isAudited() {
        return false;
    }

    @Override
    public String toString() {
        return "LockTryAcquireAction{lockType=" + (Object)((Object)this.type) + ", interval=" + this.interval + '}';
    }
}

