/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.actions;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.apache.druid.indexing.common.actions.TaskAction;
import org.apache.druid.indexing.common.actions.TaskActionToolbox;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.DataSourceMetadata;

public class CheckPointDataSourceMetadataAction
implements TaskAction<Boolean> {
    private final String supervisorId;
    @Nullable
    private final Integer taskGroupId;
    @Deprecated
    private final String baseSequenceName;
    private final DataSourceMetadata previousCheckPoint;
    private final DataSourceMetadata currentCheckPoint;

    public CheckPointDataSourceMetadataAction(@JsonProperty(value="supervisorId") String supervisorId, @JsonProperty(value="taskGroupId") @Nullable Integer taskGroupId, @JsonProperty(value="sequenceName") @Deprecated String baseSequenceName, @JsonProperty(value="previousCheckPoint") DataSourceMetadata previousCheckPoint, @JsonProperty(value="currentCheckPoint") DataSourceMetadata currentCheckPoint) {
        this.supervisorId = (String)Preconditions.checkNotNull((Object)supervisorId, (Object)"supervisorId");
        this.taskGroupId = taskGroupId;
        this.baseSequenceName = (String)Preconditions.checkNotNull((Object)baseSequenceName, (Object)"sequenceName");
        this.previousCheckPoint = (DataSourceMetadata)Preconditions.checkNotNull((Object)previousCheckPoint, (Object)"previousCheckPoint");
        this.currentCheckPoint = (DataSourceMetadata)Preconditions.checkNotNull((Object)currentCheckPoint, (Object)"currentCheckPoint");
    }

    @JsonProperty
    public String getSupervisorId() {
        return this.supervisorId;
    }

    @Deprecated
    @JsonProperty(value="sequenceName")
    public String getBaseSequenceName() {
        return this.baseSequenceName;
    }

    @Nullable
    @JsonProperty
    public Integer getTaskGroupId() {
        return this.taskGroupId;
    }

    @JsonProperty
    public DataSourceMetadata getPreviousCheckPoint() {
        return this.previousCheckPoint;
    }

    @JsonProperty
    public DataSourceMetadata getCurrentCheckPoint() {
        return this.currentCheckPoint;
    }

    @Override
    public TypeReference<Boolean> getReturnTypeReference() {
        return new TypeReference<Boolean>(){};
    }

    @Override
    public Boolean perform(Task task, TaskActionToolbox toolbox) {
        return toolbox.getSupervisorManager().checkPointDataSourceMetadata(this.supervisorId, this.taskGroupId, this.baseSequenceName, this.previousCheckPoint, this.currentCheckPoint);
    }

    @Override
    public boolean isAudited() {
        return true;
    }

    @Override
    public String toString() {
        return "CheckPointDataSourceMetadataAction{supervisorId='" + this.supervisorId + '\'' + ", baseSequenceName='" + this.baseSequenceName + '\'' + ", taskGroupId='" + this.taskGroupId + '\'' + ", previousCheckPoint=" + this.previousCheckPoint + ", currentCheckPoint=" + this.currentCheckPoint + '}';
    }
}

