/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.inject.Provider;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.apache.druid.client.cache.Cache;
import org.apache.druid.client.cache.CacheConfig;
import org.apache.druid.client.cache.CachePopulatorStats;
import org.apache.druid.discovery.DataNodeService;
import org.apache.druid.discovery.DruidNodeAnnouncer;
import org.apache.druid.discovery.LookupNodeService;
import org.apache.druid.indexing.common.TaskReportFileWriter;
import org.apache.druid.indexing.common.actions.SegmentInsertAction;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.common.config.TaskConfig;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.metrics.MonitorScheduler;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.IndexMergerV9;
import org.apache.druid.segment.loading.DataSegmentArchiver;
import org.apache.druid.segment.loading.DataSegmentKiller;
import org.apache.druid.segment.loading.DataSegmentMover;
import org.apache.druid.segment.loading.DataSegmentPusher;
import org.apache.druid.segment.loading.SegmentLoader;
import org.apache.druid.segment.loading.SegmentLoadingException;
import org.apache.druid.segment.realtime.plumber.SegmentHandoffNotifierFactory;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.coordination.DataSegmentAnnouncer;
import org.apache.druid.server.coordination.DataSegmentServerAnnouncer;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.Interval;

public class TaskToolbox {
    private final TaskConfig config;
    private final TaskActionClient taskActionClient;
    private final ServiceEmitter emitter;
    private final DataSegmentPusher segmentPusher;
    private final DataSegmentKiller dataSegmentKiller;
    private final DataSegmentArchiver dataSegmentArchiver;
    private final DataSegmentMover dataSegmentMover;
    private final DataSegmentAnnouncer segmentAnnouncer;
    private final DataSegmentServerAnnouncer serverAnnouncer;
    private final SegmentHandoffNotifierFactory handoffNotifierFactory;
    private final Provider<QueryRunnerFactoryConglomerate> queryRunnerFactoryConglomerateProvider;
    private final MonitorScheduler monitorScheduler;
    private final ExecutorService queryExecutorService;
    private final SegmentLoader segmentLoader;
    private final ObjectMapper objectMapper;
    private final File taskWorkDir;
    private final IndexIO indexIO;
    private final Cache cache;
    private final CacheConfig cacheConfig;
    private final CachePopulatorStats cachePopulatorStats;
    private final IndexMergerV9 indexMergerV9;
    private final TaskReportFileWriter taskReportFileWriter;
    private final DruidNodeAnnouncer druidNodeAnnouncer;
    private final DruidNode druidNode;
    private final LookupNodeService lookupNodeService;
    private final DataNodeService dataNodeService;

    public TaskToolbox(TaskConfig config, TaskActionClient taskActionClient, ServiceEmitter emitter, DataSegmentPusher segmentPusher, DataSegmentKiller dataSegmentKiller, DataSegmentMover dataSegmentMover, DataSegmentArchiver dataSegmentArchiver, DataSegmentAnnouncer segmentAnnouncer, DataSegmentServerAnnouncer serverAnnouncer, SegmentHandoffNotifierFactory handoffNotifierFactory, Provider<QueryRunnerFactoryConglomerate> queryRunnerFactoryConglomerateProvider, ExecutorService queryExecutorService, MonitorScheduler monitorScheduler, SegmentLoader segmentLoader, ObjectMapper objectMapper, File taskWorkDir, IndexIO indexIO, Cache cache, CacheConfig cacheConfig, CachePopulatorStats cachePopulatorStats, IndexMergerV9 indexMergerV9, DruidNodeAnnouncer druidNodeAnnouncer, DruidNode druidNode, LookupNodeService lookupNodeService, DataNodeService dataNodeService, TaskReportFileWriter taskReportFileWriter) {
        this.config = config;
        this.taskActionClient = taskActionClient;
        this.emitter = emitter;
        this.segmentPusher = segmentPusher;
        this.dataSegmentKiller = dataSegmentKiller;
        this.dataSegmentMover = dataSegmentMover;
        this.dataSegmentArchiver = dataSegmentArchiver;
        this.segmentAnnouncer = segmentAnnouncer;
        this.serverAnnouncer = serverAnnouncer;
        this.handoffNotifierFactory = handoffNotifierFactory;
        this.queryRunnerFactoryConglomerateProvider = queryRunnerFactoryConglomerateProvider;
        this.queryExecutorService = queryExecutorService;
        this.monitorScheduler = monitorScheduler;
        this.segmentLoader = segmentLoader;
        this.objectMapper = objectMapper;
        this.taskWorkDir = taskWorkDir;
        this.indexIO = (IndexIO)Preconditions.checkNotNull((Object)indexIO, (Object)"Null IndexIO");
        this.cache = cache;
        this.cacheConfig = cacheConfig;
        this.cachePopulatorStats = cachePopulatorStats;
        this.indexMergerV9 = (IndexMergerV9)Preconditions.checkNotNull((Object)indexMergerV9, (Object)"Null IndexMergerV9");
        this.druidNodeAnnouncer = druidNodeAnnouncer;
        this.druidNode = druidNode;
        this.lookupNodeService = lookupNodeService;
        this.dataNodeService = dataNodeService;
        this.taskReportFileWriter = taskReportFileWriter;
        this.taskReportFileWriter.setObjectMapper(this.objectMapper);
    }

    public TaskConfig getConfig() {
        return this.config;
    }

    public TaskActionClient getTaskActionClient() {
        return this.taskActionClient;
    }

    public ServiceEmitter getEmitter() {
        return this.emitter;
    }

    public DataSegmentPusher getSegmentPusher() {
        return this.segmentPusher;
    }

    public DataSegmentKiller getDataSegmentKiller() {
        return this.dataSegmentKiller;
    }

    public DataSegmentMover getDataSegmentMover() {
        return this.dataSegmentMover;
    }

    public DataSegmentArchiver getDataSegmentArchiver() {
        return this.dataSegmentArchiver;
    }

    public DataSegmentAnnouncer getSegmentAnnouncer() {
        return this.segmentAnnouncer;
    }

    public DataSegmentServerAnnouncer getDataSegmentServerAnnouncer() {
        return this.serverAnnouncer;
    }

    public SegmentHandoffNotifierFactory getSegmentHandoffNotifierFactory() {
        return this.handoffNotifierFactory;
    }

    public QueryRunnerFactoryConglomerate getQueryRunnerFactoryConglomerate() {
        return (QueryRunnerFactoryConglomerate)this.queryRunnerFactoryConglomerateProvider.get();
    }

    public ExecutorService getQueryExecutorService() {
        return this.queryExecutorService;
    }

    public MonitorScheduler getMonitorScheduler() {
        return this.monitorScheduler;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public Map<DataSegment, File> fetchSegments(List<DataSegment> segments) throws SegmentLoadingException {
        LinkedHashMap retVal = Maps.newLinkedHashMap();
        for (DataSegment segment : segments) {
            retVal.put(segment, this.segmentLoader.getSegmentFiles(segment));
        }
        return retVal;
    }

    public void publishSegments(Iterable<DataSegment> segments) throws IOException {
        ImmutableListMultimap segmentMultimap = Multimaps.index(segments, (Function)new Function<DataSegment, Interval>(){

            public Interval apply(DataSegment segment) {
                return segment.getInterval();
            }
        });
        for (Collection segmentCollection : segmentMultimap.asMap().values()) {
            this.getTaskActionClient().submit(new SegmentInsertAction((Set<DataSegment>)ImmutableSet.copyOf((Collection)segmentCollection)));
        }
    }

    public IndexIO getIndexIO() {
        return this.indexIO;
    }

    public Cache getCache() {
        return this.cache;
    }

    public CacheConfig getCacheConfig() {
        return this.cacheConfig;
    }

    public CachePopulatorStats getCachePopulatorStats() {
        return this.cachePopulatorStats;
    }

    public IndexMergerV9 getIndexMergerV9() {
        return this.indexMergerV9;
    }

    public File getFirehoseTemporaryDir() {
        return new File(this.taskWorkDir, "firehose");
    }

    public File getMergeDir() {
        return new File(this.taskWorkDir, "merge");
    }

    public File getPersistDir() {
        return new File(this.taskWorkDir, "persist");
    }

    public DruidNodeAnnouncer getDruidNodeAnnouncer() {
        return this.druidNodeAnnouncer;
    }

    public LookupNodeService getLookupNodeService() {
        return this.lookupNodeService;
    }

    public DataNodeService getDataNodeService() {
        return this.dataNodeService;
    }

    public DruidNode getDruidNode() {
        return this.druidNode;
    }

    public TaskReportFileWriter getTaskReportFileWriter() {
        return this.taskReportFileWriter;
    }
}

