/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.druid.indexing.common.TaskReport;
import org.apache.druid.java.util.common.logger.Logger;

public class TaskReportFileWriter {
    private static final Logger log = new Logger(TaskReportFileWriter.class);
    private final File reportsFile;
    private ObjectMapper objectMapper;

    public TaskReportFileWriter(File reportFile) {
        this.reportsFile = reportFile;
    }

    public void write(Map<String, TaskReport> reports) {
        try {
            File reportsFileParent = this.reportsFile.getParentFile();
            if (reportsFileParent != null) {
                FileUtils.forceMkdir((File)reportsFileParent);
            }
            this.objectMapper.writeValue(this.reportsFile, reports);
        }
        catch (Exception e) {
            log.error((Throwable)e, "Encountered exception in write().", new Object[0]);
        }
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

