/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.apache.druid.indexing.common.TaskLockType;
import org.joda.time.Interval;

public class TaskLock {
    private final TaskLockType type;
    private final String groupId;
    private final String dataSource;
    private final Interval interval;
    private final String version;
    private final Integer priority;
    private final boolean revoked;

    public static TaskLock withPriority(TaskLock lock, int priority) {
        return new TaskLock(lock.type, lock.getGroupId(), lock.getDataSource(), lock.getInterval(), lock.getVersion(), priority, lock.isRevoked());
    }

    @JsonCreator
    public TaskLock(@JsonProperty(value="type") @Nullable TaskLockType type, @JsonProperty(value="groupId") String groupId, @JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="interval") Interval interval, @JsonProperty(value="version") String version, @JsonProperty(value="priority") @Nullable Integer priority, @JsonProperty(value="revoked") boolean revoked) {
        this.type = type == null ? TaskLockType.EXCLUSIVE : type;
        this.groupId = (String)Preconditions.checkNotNull((Object)groupId, (Object)"groupId");
        this.dataSource = (String)Preconditions.checkNotNull((Object)dataSource, (Object)"dataSource");
        this.interval = (Interval)Preconditions.checkNotNull((Object)interval, (Object)"interval");
        this.version = (String)Preconditions.checkNotNull((Object)version, (Object)"version");
        this.priority = priority;
        this.revoked = revoked;
    }

    public TaskLock(TaskLockType type, String groupId, String dataSource, Interval interval, String version, int priority) {
        this(type, groupId, dataSource, interval, version, priority, false);
    }

    public TaskLock revokedCopy() {
        return new TaskLock(this.type, this.groupId, this.dataSource, this.interval, this.version, this.priority, true);
    }

    @JsonProperty
    public TaskLockType getType() {
        return this.type;
    }

    @JsonProperty
    public String getGroupId() {
        return this.groupId;
    }

    @JsonProperty
    public String getDataSource() {
        return this.dataSource;
    }

    @JsonProperty
    public Interval getInterval() {
        return this.interval;
    }

    @JsonProperty
    public String getVersion() {
        return this.version;
    }

    @JsonProperty
    @Nullable
    public Integer getPriority() {
        return this.priority;
    }

    public int getNonNullPriority() {
        return (Integer)Preconditions.checkNotNull((Object)this.priority, (Object)"priority");
    }

    @JsonProperty
    public boolean isRevoked() {
        return this.revoked;
    }

    public boolean equals(Object o) {
        if (!(o instanceof TaskLock)) {
            return false;
        }
        TaskLock that = (TaskLock)o;
        return this.type.equals((Object)that.type) && this.groupId.equals(that.groupId) && this.dataSource.equals(that.dataSource) && this.interval.equals((Object)that.interval) && this.version.equals(that.version) && Objects.equal((Object)this.priority, (Object)that.priority) && this.revoked == that.revoked;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.type, this.groupId, this.dataSource, this.interval, this.version, this.priority, this.revoked});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("type", (Object)this.type).add("groupId", (Object)this.groupId).add("dataSource", (Object)this.dataSource).add("interval", (Object)this.interval).add("version", (Object)this.version).add("priority", (Object)this.priority).add("revoked", this.revoked).toString();
    }
}

